/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.tools.AbstractCommonCrawlFormat;
import org.apache.nutch.tools.CommonCrawlConfig;

public class CommonCrawlFormatSimple
extends AbstractCommonCrawlFormat {
    private StringBuilder sb = new StringBuilder();
    private int tabCount = 0;

    public CommonCrawlFormatSimple(String url, Content content, Metadata metadata, Configuration nutchConf, CommonCrawlConfig config) throws IOException {
        super(url, content, metadata, nutchConf, config);
    }

    @Override
    protected void writeKeyValue(String key, String value) throws IOException {
        this.sb.append(this.printTabs() + "\"" + key + "\": " + CommonCrawlFormatSimple.quote(value) + ",\n");
    }

    @Override
    protected void writeKeyNull(String key) throws IOException {
        this.sb.append(this.printTabs() + "\"" + key + "\": null,\n");
    }

    @Override
    protected void startArray(String key, boolean nested, boolean newline) throws IOException {
        Object name = key != null ? "\"" + key + "\": " : "";
        String nl = newline ? "\n" : "";
        this.sb.append(this.printTabs() + (String)name + "[" + nl);
        if (newline) {
            ++this.tabCount;
        }
    }

    @Override
    protected void closeArray(String key, boolean nested, boolean newline) throws IOException {
        String nl;
        if (this.sb.charAt(this.sb.length() - 1) == ',') {
            this.sb.deleteCharAt(this.sb.length() - 1);
        } else if (this.sb.charAt(this.sb.length() - 2) == ',') {
            this.sb.deleteCharAt(this.sb.length() - 2);
        }
        String string = nl = newline ? this.printTabs() : "";
        if (newline) {
            ++this.tabCount;
        }
        this.sb.append(nl + "],\n");
    }

    @Override
    protected void writeArrayValue(String value) {
        this.sb.append("\"" + value + "\",");
    }

    @Override
    protected void startObject(String key) throws IOException {
        Object name = "";
        if (key != null) {
            name = "\"" + key + "\": ";
        }
        this.sb.append(this.printTabs() + (String)name + "{\n");
        ++this.tabCount;
    }

    @Override
    protected void closeObject(String key) throws IOException {
        if (this.sb.charAt(this.sb.length() - 2) == ',') {
            this.sb.deleteCharAt(this.sb.length() - 2);
        }
        --this.tabCount;
        this.sb.append(this.printTabs() + "},\n");
    }

    @Override
    protected String generateJson() throws IOException {
        this.sb.deleteCharAt(this.sb.length() - 1);
        this.sb.deleteCharAt(this.sb.length() - 1);
        return this.sb.toString();
    }

    private String printTabs() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tabCount; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }

    private static String quote(String string) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (string == null || string.length() == 0) {
            sb.append("\"\"");
            return sb.toString();
        }
        char c = '\u0000';
        int len = string.length();
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        sb.append("\\u");
                        String hhhh = Integer.toHexString(c);
                        sb.append("0000", 0, 4 - hhhh.length());
                        sb.append(hhhh);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

