/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe.spi;

import dev.failsafe.ExecutionContext;
import dev.failsafe.spi.ExecutionInternal;
import dev.failsafe.spi.ExecutionResult;
import dev.failsafe.spi.PolicyExecutor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;

public class FailsafeFuture<R>
extends CompletableFuture<R> {
    private final BiConsumer<ExecutionResult<R>, ExecutionContext<R>> completionHandler;
    private ExecutionInternal<R> newestExecution;
    private Map<Integer, BiConsumer<Boolean, ExecutionResult<R>>> cancelFunctions;
    private boolean cancelledWithInterrupt;

    public FailsafeFuture(BiConsumer<ExecutionResult<R>, ExecutionContext<R>> completionHandler) {
        this.completionHandler = completionHandler;
    }

    @Override
    public synchronized boolean complete(R value) {
        return this.completeResult(ExecutionResult.success(value));
    }

    @Override
    public synchronized boolean completeExceptionally(Throwable exception) {
        return this.completeResult(ExecutionResult.exception(exception));
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancelledWithInterrupt = mayInterruptIfRunning;
        this.newestExecution.cancel();
        boolean cancelResult = super.cancel(mayInterruptIfRunning);
        this.cancelDependencies(null, mayInterruptIfRunning, null);
        ExecutionResult result = ExecutionResult.exception(new CancellationException());
        super.completeExceptionally(result.getException());
        this.completionHandler.accept(result, this.newestExecution);
        return cancelResult;
    }

    public synchronized boolean completeResult(ExecutionResult<R> result) {
        if (this.isDone()) {
            return false;
        }
        Throwable exception = result.getException();
        boolean completed = exception == null ? super.complete(result.getResult()) : super.completeExceptionally(exception);
        if (completed) {
            this.completionHandler.accept(result, this.newestExecution);
        }
        return completed;
    }

    public synchronized void cancelDependencies(PolicyExecutor<R> cancellingPolicyExecutor, boolean mayInterrupt, ExecutionResult<R> cancelResult) {
        if (this.cancelFunctions != null) {
            int cancellingPolicyIndex = cancellingPolicyExecutor == null ? Integer.MAX_VALUE : cancellingPolicyExecutor.getPolicyIndex();
            Iterator<Map.Entry<Integer, BiConsumer<Boolean, ExecutionResult<R>>>> it = this.cancelFunctions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, BiConsumer<Boolean, ExecutionResult<R>>> entry = it.next();
                if (cancellingPolicyIndex <= entry.getKey()) continue;
                try {
                    entry.getValue().accept(mayInterrupt, cancelResult);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                it.remove();
            }
        }
    }

    public synchronized void setExecution(ExecutionInternal<R> execution) {
        this.newestExecution = execution;
    }

    public synchronized void setCancelFn(int policyIndex, BiConsumer<Boolean, ExecutionResult<R>> cancelFn) {
        if (this.cancelFunctions == null) {
            this.cancelFunctions = new TreeMap(Collections.reverseOrder());
        }
        this.cancelFunctions.put(policyIndex, cancelFn);
    }

    public synchronized void setCancelFn(PolicyExecutor<R> policyExecutor, BiConsumer<Boolean, ExecutionResult<R>> cancelFn) {
        this.setCancelFn(policyExecutor.getPolicyIndex(), cancelFn);
    }

    public synchronized void propagateCancellation(Future<R> future) {
        if (this.isCancelled()) {
            future.cancel(this.cancelledWithInterrupt);
        } else {
            this.setCancelFn(-2, (Boolean mayInterrupt, ExecutionResult<R> cancelResult) -> future.cancel((boolean)mayInterrupt));
        }
    }
}

