/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.jexl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.util.JexlUtil;
import org.apache.nutch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlIndexingFilter
implements IndexingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Configuration conf;
    private JexlScript expr;

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        MapContext jcontext = new MapContext();
        jcontext.set("status", (Object)CrawlDatum.getStatusName((byte)datum.getStatus()));
        jcontext.set("fetchTime", (Object)datum.getFetchTime());
        jcontext.set("modifiedTime", (Object)datum.getModifiedTime());
        jcontext.set("retries", (Object)datum.getRetriesSinceFetch());
        jcontext.set("interval", (Object)datum.getFetchInterval());
        jcontext.set("score", (Object)Float.valueOf(datum.getScore()));
        jcontext.set("signature", (Object)StringUtil.toHexString((byte[])datum.getSignature()));
        jcontext.set("url", (Object)url.toString());
        jcontext.set("text", (Object)parse.getText());
        jcontext.set("title", (Object)parse.getData().getTitle());
        MapContext httpStatusContext = new MapContext();
        httpStatusContext.set("majorCode", (Object)parse.getData().getStatus().getMajorCode());
        httpStatusContext.set("minorCode", (Object)parse.getData().getStatus().getMinorCode());
        httpStatusContext.set("message", (Object)parse.getData().getStatus().getMessage());
        jcontext.set("httpStatus", (Object)httpStatusContext);
        jcontext.set("documentMeta", (Object)this.metadataToContext(doc.getDocumentMeta()));
        jcontext.set("contentMeta", (Object)this.metadataToContext(parse.getData().getContentMeta()));
        jcontext.set("parseMeta", (Object)this.metadataToContext(parse.getData().getParseMeta()));
        MapContext context = new MapContext();
        for (Map.Entry entry : doc) {
            List values = ((NutchField)entry.getValue()).getValues();
            context.set((String)entry.getKey(), (Object)(values.size() > 1 ? values : values.get(0)));
        }
        jcontext.set("doc", (Object)context);
        try {
            if (Boolean.TRUE.equals(this.expr.execute((JexlContext)jcontext))) {
                return doc;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed evaluating JEXL {}", (Object)this.expr.getSourceText(), (Object)e);
        }
        return null;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String strExpr = conf.get("index.jexl.filter");
        if (strExpr == null) {
            LOG.error("The property index.jexl.filter must have a value when index-jexl-filter is used. You can use 'true' or 'false' to index all/none");
            throw new RuntimeException("The property index.jexl.filter must have a value when index-jexl-filter is used. You can use 'true' or 'false' to index all/none");
        }
        this.expr = JexlUtil.parseExpression((String)strExpr);
        if (this.expr == null) {
            LOG.error("Failed parsing JEXL from index.jexl.filter: {}", (Object)strExpr);
            throw new RuntimeException("Failed parsing JEXL from index.jexl.filter");
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    private JexlContext metadataToContext(Metadata metadata) {
        MapContext context = new MapContext();
        String[] stringArray = metadata.names();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String name;
            String[] values = metadata.getValues(name = stringArray[i]);
            context.set(name, values.length > 1 ? values : values[0]);
        }
        return context;
    }
}

