/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.action.TransportActionNodeProxy;
import org.opensearch.client.transport.TransportClientNodesService;
import org.opensearch.common.settings.Settings;
import org.opensearch.transport.TransportService;

final class TransportProxyClient {
    private final TransportClientNodesService nodesService;
    private final Map<ActionType, TransportActionNodeProxy> proxies;

    TransportProxyClient(Settings settings, TransportService transportService, TransportClientNodesService nodesService, List<ActionType> actions) {
        this.nodesService = nodesService;
        HashMap proxies = new HashMap();
        for (ActionType action : actions) {
            proxies.put(action, new TransportActionNodeProxy(settings, action, transportService));
        }
        this.proxies = Collections.unmodifiableMap(proxies);
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response>> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        TransportActionNodeProxy proxy = this.proxies.get(action);
        assert (proxy != null) : "no proxy found for action: " + action;
        this.nodesService.execute((n, l) -> proxy.execute(n, request, l), listener);
    }
}

