/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import org.opensearch.action.search.ArraySearchPhaseResults;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.concurrent.CountDown;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchShardTarget;

final class CountedCollector<R extends SearchPhaseResult> {
    private final ArraySearchPhaseResults<R> resultConsumer;
    private final CountDown counter;
    private final Runnable onFinish;
    private final SearchPhaseContext context;

    CountedCollector(ArraySearchPhaseResults<R> resultConsumer, int expectedOps, Runnable onFinish, SearchPhaseContext context) {
        this.resultConsumer = resultConsumer;
        this.counter = new CountDown(expectedOps);
        this.onFinish = onFinish;
        this.context = context;
    }

    void countDown() {
        assert (!this.counter.isCountedDown()) : "more operations executed than specified";
        if (this.counter.countDown()) {
            this.onFinish.run();
        }
    }

    void onResult(R result) {
        this.resultConsumer.consumeResult(result, this::countDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
        try {
            this.context.onShardFailure(shardIndex, shardTarget, e);
        }
        finally {
            this.countDown();
        }
    }
}

