/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.common.ParseField;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.search.aggregations.metrics.ExtendedStats;
import org.opensearch.search.aggregations.metrics.ParsedStats;

public class ParsedExtendedStats
extends ParsedStats
implements ExtendedStats {
    protected double sumOfSquares;
    protected double variance;
    protected double variancePopulation;
    protected double varianceSampling;
    protected double stdDeviation;
    protected double stdDeviationPopulation;
    protected double stdDeviationSampling;
    protected double stdDeviationBoundUpper;
    protected double stdDeviationBoundLower;
    protected double stdDeviationBoundUpperPopulation;
    protected double stdDeviationBoundLowerPopulation;
    protected double stdDeviationBoundUpperSampling;
    protected double stdDeviationBoundLowerSampling;
    protected double sum;
    protected double avg;
    private static final ObjectParser<ParsedExtendedStats, Void> PARSER = new ObjectParser(ParsedExtendedStats.class.getSimpleName(), true, ParsedExtendedStats::new);
    private static final ConstructingObjectParser<List<Double>, Void> STD_BOUNDS_PARSER = new ConstructingObjectParser(ParsedExtendedStats.class.getSimpleName() + "_STD_BOUNDS", true, args -> Arrays.stream(args).map(d -> (Double)d).collect(Collectors.toList()));
    private static final ConstructingObjectParser<List<String>, Void> STD_BOUNDS_AS_STRING_PARSER = new ConstructingObjectParser(ParsedExtendedStats.class.getSimpleName() + "_STD_BOUNDS_AS_STRING", true, args -> Arrays.stream(args).map(d -> (String)d).collect(Collectors.toList()));

    @Override
    public String getType() {
        return "extended_stats";
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getVariancePopulation() {
        return this.variancePopulation;
    }

    @Override
    public double getVarianceSampling() {
        return this.varianceSampling;
    }

    @Override
    public double getStdDeviation() {
        return this.stdDeviation;
    }

    @Override
    public double getStdDeviationPopulation() {
        return this.stdDeviationPopulation;
    }

    @Override
    public double getStdDeviationSampling() {
        return this.stdDeviationSampling;
    }

    private void setStdDeviationBounds(List<Double> bounds) {
        this.stdDeviationBoundUpper = bounds.get(0);
        this.stdDeviationBoundLower = bounds.get(1);
        this.stdDeviationBoundUpperPopulation = bounds.get(2) == null ? 0.0 : bounds.get(2);
        this.stdDeviationBoundLowerPopulation = bounds.get(3) == null ? 0.0 : bounds.get(3);
        this.stdDeviationBoundUpperSampling = bounds.get(4) == null ? 0.0 : bounds.get(4);
        this.stdDeviationBoundLowerSampling = bounds.get(5) == null ? 0.0 : bounds.get(5);
    }

    @Override
    public double getStdDeviationBound(ExtendedStats.Bounds bound) {
        switch (bound) {
            case UPPER: {
                return this.stdDeviationBoundUpper;
            }
            case UPPER_POPULATION: {
                return this.stdDeviationBoundUpperPopulation;
            }
            case UPPER_SAMPLING: {
                return this.stdDeviationBoundUpperSampling;
            }
            case LOWER: {
                return this.stdDeviationBoundLower;
            }
            case LOWER_POPULATION: {
                return this.stdDeviationBoundLowerPopulation;
            }
            case LOWER_SAMPLING: {
                return this.stdDeviationBoundLowerSampling;
            }
        }
        throw new IllegalArgumentException("Unknown bounds type " + (Object)((Object)bound));
    }

    private void setStdDeviationBoundsAsString(List<String> boundsAsString) {
        this.valueAsString.put("std_deviation_bounds_as_string_upper", boundsAsString.get(0));
        this.valueAsString.put("std_deviation_bounds_as_string_lower", boundsAsString.get(1));
        if (boundsAsString.get(2) != null) {
            this.valueAsString.put("std_deviation_bounds_as_string_upper_population", boundsAsString.get(2));
        }
        if (boundsAsString.get(3) != null) {
            this.valueAsString.put("std_deviation_bounds_as_string_lower_population", boundsAsString.get(3));
        }
        if (boundsAsString.get(4) != null) {
            this.valueAsString.put("std_deviation_bounds_as_string_upper_sampling", boundsAsString.get(4));
        }
        if (boundsAsString.get(5) != null) {
            this.valueAsString.put("std_deviation_bounds_as_string_lower_sampling", boundsAsString.get(5));
        }
    }

    @Override
    public String getStdDeviationAsString() {
        return this.valueAsString.getOrDefault("std_deviation_as_string", Double.toString(this.stdDeviation));
    }

    @Override
    public String getStdDeviationPopulationAsString() {
        return this.valueAsString.getOrDefault("std_deviation_population_as_string", Double.toString(this.stdDeviationPopulation));
    }

    @Override
    public String getStdDeviationSamplingAsString() {
        return this.valueAsString.getOrDefault("std_deviation_sampling_as_string", Double.toString(this.stdDeviationSampling));
    }

    @Override
    public String getStdDeviationBoundAsString(ExtendedStats.Bounds bound) {
        switch (bound) {
            case UPPER: {
                return this.valueAsString.getOrDefault("std_deviation_bounds_as_string_upper", Double.toString(this.stdDeviationBoundUpper));
            }
            case UPPER_POPULATION: {
                return this.valueAsString.getOrDefault("std_deviation_bounds_as_string_upper_population", Double.toString(this.stdDeviationBoundUpperPopulation));
            }
            case UPPER_SAMPLING: {
                return this.valueAsString.getOrDefault("std_deviation_bounds_as_string_upper_sampling", Double.toString(this.stdDeviationBoundUpperSampling));
            }
            case LOWER: {
                return this.valueAsString.getOrDefault("std_deviation_bounds_as_string_lower", Double.toString(this.stdDeviationBoundLower));
            }
            case LOWER_POPULATION: {
                return this.valueAsString.getOrDefault("std_deviation_bounds_as_string_lower_population", Double.toString(this.stdDeviationBoundLowerPopulation));
            }
            case LOWER_SAMPLING: {
                return this.valueAsString.getOrDefault("std_deviation_bounds_as_string_lower_sampling", Double.toString(this.stdDeviationBoundLowerSampling));
            }
        }
        throw new IllegalArgumentException("Unknown bounds type " + (Object)((Object)bound));
    }

    @Override
    public String getSumOfSquaresAsString() {
        return this.valueAsString.getOrDefault("sum_of_squares_as_string", Double.toString(this.sumOfSquares));
    }

    @Override
    public String getVarianceAsString() {
        return this.valueAsString.getOrDefault("variance_as_string", Double.toString(this.variance));
    }

    @Override
    public String getVariancePopulationAsString() {
        return this.valueAsString.getOrDefault("variance_population_as_string", Double.toString(this.variancePopulation));
    }

    @Override
    public String getVarianceSamplingAsString() {
        return this.valueAsString.getOrDefault("variance_sampling_as_string", Double.toString(this.varianceSampling));
    }

    @Override
    protected XContentBuilder otherStatsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.count != 0L) {
            builder.field("sum_of_squares", this.sumOfSquares);
            builder.field("variance", this.getVariance());
            builder.field("variance_population", this.getVariancePopulation());
            builder.field("variance_sampling", this.getVarianceSampling());
            builder.field("std_deviation", this.getStdDeviation());
            builder.field("std_deviation_population", this.getStdDeviationPopulation());
            builder.field("std_deviation_sampling", this.getStdDeviationSampling());
            builder.startObject("std_deviation_bounds");
            builder.field("upper", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER));
            builder.field("lower", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER));
            builder.field("upper_population", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_POPULATION));
            builder.field("lower_population", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_POPULATION));
            builder.field("upper_sampling", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_SAMPLING));
            builder.field("lower_sampling", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_SAMPLING));
            builder.endObject();
            if (this.valueAsString.containsKey("sum_of_squares_as_string")) {
                builder.field("sum_of_squares_as_string", this.getSumOfSquaresAsString());
                builder.field("variance_as_string", this.getVarianceAsString());
                builder.field("variance_population_as_string", this.getVariancePopulationAsString());
                builder.field("variance_sampling_as_string", this.getVarianceSamplingAsString());
                builder.field("std_deviation_as_string", this.getStdDeviationAsString());
                builder.field("std_deviation_population_as_string", this.getStdDeviationPopulationAsString());
                builder.field("std_deviation_sampling_as_string", this.getStdDeviationSamplingAsString());
                builder.startObject("std_deviation_bounds_as_string");
                builder.field("upper", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER));
                builder.field("lower", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER));
                builder.field("upper_population", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER_POPULATION));
                builder.field("lower_population", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER_POPULATION));
                builder.field("upper_sampling", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER_SAMPLING));
                builder.field("lower_sampling", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER_SAMPLING));
                builder.endObject();
            }
        } else {
            builder.nullField("sum_of_squares");
            builder.nullField("variance");
            builder.nullField("variance_population");
            builder.nullField("variance_sampling");
            builder.nullField("std_deviation");
            builder.nullField("std_deviation_population");
            builder.nullField("std_deviation_sampling");
            builder.startObject("std_deviation_bounds");
            builder.nullField("upper");
            builder.nullField("lower");
            builder.nullField("upper_population");
            builder.nullField("lower_population");
            builder.nullField("upper_sampling");
            builder.nullField("lower_sampling");
            builder.endObject();
        }
        return builder;
    }

    protected static void declareExtendedStatsFields(ObjectParser<? extends ParsedExtendedStats, Void> objectParser) {
        ParsedExtendedStats.declareAggregationFields(objectParser);
        ParsedExtendedStats.declareStatsFields(objectParser);
        objectParser.declareField((agg, value) -> {
            agg.sumOfSquares = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("sum_of_squares", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.variance = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("variance", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.variancePopulation = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("variance_population", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.varianceSampling = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("variance_sampling", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.stdDeviation = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("std_deviation", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.stdDeviationPopulation = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("std_deviation_population", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.stdDeviationSampling = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("std_deviation_sampling", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareObject(ParsedExtendedStats::setStdDeviationBounds, STD_BOUNDS_PARSER, new ParseField("std_deviation_bounds", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("sum_of_squares_as_string", value), new ParseField("sum_of_squares_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("variance_as_string", value), new ParseField("variance_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("variance_population_as_string", value), new ParseField("variance_population_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("variance_sampling_as_string", value), new ParseField("variance_sampling_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("std_deviation_as_string", value), new ParseField("std_deviation_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("std_deviation_population_as_string", value), new ParseField("std_deviation_population_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("std_deviation_sampling_as_string", value), new ParseField("std_deviation_sampling_as_string", new String[0]));
        objectParser.declareObject(ParsedExtendedStats::setStdDeviationBoundsAsString, STD_BOUNDS_AS_STRING_PARSER, new ParseField("std_deviation_bounds_as_string", new String[0]));
    }

    public static ParsedExtendedStats fromXContent(XContentParser parser, String name) {
        ParsedExtendedStats parsedStats = (ParsedExtendedStats)PARSER.apply(parser, null);
        parsedStats.setName(name);
        return parsedStats;
    }

    static {
        STD_BOUNDS_PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("upper", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        STD_BOUNDS_PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("lower", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        STD_BOUNDS_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("upper_population", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        STD_BOUNDS_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("lower_population", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        STD_BOUNDS_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("upper_sampling", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        STD_BOUNDS_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("lower_sampling", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        STD_BOUNDS_AS_STRING_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("upper", new String[0]));
        STD_BOUNDS_AS_STRING_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("lower", new String[0]));
        STD_BOUNDS_AS_STRING_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("upper_population", new String[0]));
        STD_BOUNDS_AS_STRING_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("lower_population", new String[0]));
        STD_BOUNDS_AS_STRING_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("upper_sampling", new String[0]));
        STD_BOUNDS_AS_STRING_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("lower_sampling", new String[0]));
        ParsedExtendedStats.declareExtendedStatsFields(PARSER);
    }
}

