/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.logging.LogManager;

public class Initializer {
    public static final String CONFIG_FILE_PROPERTY = "java.util.logging.config.file";
    private static final String PATTERN_PROPERTY = "java.util.logging.FileHandler.pattern";
    private static final String PATTERN = "%p";

    public Initializer() throws IOException {
        String file = System.getProperty(CONFIG_FILE_PROPERTY);
        if (file != null) {
            Initializer.reload(Path.of(file, new String[0]));
        }
    }

    public static void reload(Path path) throws IOException {
        path = path.normalize();
        StringBuilder buffer = new StringBuilder(600);
        for (String line : Files.readAllLines(path)) {
            int i;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            int base = buffer.length();
            buffer.append(line).append('\n');
            if (!line.startsWith(PATTERN_PROPERTY) || (i = buffer.indexOf(PATTERN, base + PATTERN_PROPERTY.length())) < 0) continue;
            Path parent = path;
            int j = Math.min(parent.getNameCount(), 2);
            while (--j >= 0) {
                parent = parent.getParent();
            }
            String replacement = parent != null ? parent.toString() : ".";
            replacement = replacement.replace(File.separatorChar, '/');
            buffer.replace(i, i + PATTERN.length(), replacement);
        }
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(buffer.toString().getBytes()));
    }
}

