/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;

final class VerticalInfo {
    private VerticalInfo next;
    private final DefaultVerticalExtent extent;
    final Unit<Length> unit;
    private VerticalCRS compatibleCRS;

    VerticalInfo(VerticalInfo next, DefaultExtent extents, double minimum, double maximum, Unit<Length> unit) {
        this.next = next;
        this.unit = unit;
        this.extent = new DefaultVerticalExtent(minimum, maximum, null);
        extents.getVerticalElements().add(this.extent);
    }

    final VerticalInfo resolve(VerticalCRS crs) {
        if (crs != null && DatumOrEnsemble.asDatum(crs).getVerticalDatumType() == VerticalDatumType.GEOIDAL) {
            return this.resolve(crs, crs.getCoordinateSystem().getAxis(0));
        }
        return this;
    }

    private VerticalInfo resolve(VerticalCRS crs, CoordinateSystemAxis axis) {
        if (this.next != null) {
            this.next = this.next.resolve(crs, axis);
        }
        Unit crsUnit = axis.getUnit();
        if (axis.getDirection() == AxisDirection.UP && this.unit.equals((Object)crsUnit)) {
            this.extent.setVerticalCRS(crs);
            return this.next;
        }
        if (this.unit.isCompatible(crsUnit)) {
            this.compatibleCRS = crs;
        }
        return this;
    }

    final VerticalInfo complete(CRSFactory crsFactory, CSFactory csFactory) throws FactoryException {
        String abbreviation;
        String name;
        boolean isUP;
        if (this.next != null) {
            this.next = this.next.complete(crsFactory, csFactory);
        }
        if (this.compatibleCRS == null) {
            return this;
        }
        CoordinateSystemAxis axis = this.compatibleCRS.getCoordinateSystem().getAxis(0);
        boolean bl = isUP = axis.getDirection() == AxisDirection.UP;
        if (isUP) {
            name = axis.getName();
            abbreviation = axis.getAbbreviation();
        } else {
            name = "Gravity-related height";
            abbreviation = "H";
        }
        axis = csFactory.createCoordinateSystemAxis(VerticalInfo.properties(name), abbreviation, AxisDirection.UP, this.unit);
        VerticalCS cs = csFactory.createVerticalCS(VerticalInfo.properties(axis.getName()), axis);
        this.extent.setVerticalCRS(crsFactory.createVerticalCRS(VerticalInfo.properties((isUP ? this.compatibleCRS : axis).getName()), DatumOrEnsemble.asDatum(this.compatibleCRS), cs));
        return this.next;
    }

    private static Map<String, ?> properties(Object name) {
        return Map.of("name", name);
    }
}

