/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlType(name="AffineCSType")
@XmlRootElement(name="AffineCS")
public class DefaultAffineCS
extends AbstractCS
implements AffineCS {
    private static final long serialVersionUID = 7977674229369042440L;

    public DefaultAffineCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, axis0, axis1);
    }

    public DefaultAffineCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
    }

    DefaultAffineCS(DefaultAffineCS original, String name, CoordinateSystemAxis[] axes) {
        super(original, name, axes);
    }

    protected DefaultAffineCS(AffineCS original) {
        super((CoordinateSystem)original);
    }

    public static DefaultAffineCS castOrCopy(AffineCS object) {
        if (object instanceof CartesianCS) {
            return DefaultCartesianCS.castOrCopy((CartesianCS)object);
        }
        return object == null || object instanceof DefaultAffineCS ? (DefaultAffineCS)object : new DefaultAffineCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(direction, true)) {
            return 1;
        }
        if (!(Units.isLinear(unit) || Units.UNITY.equals(unit) || Units.PIXEL.equals(unit))) {
            return 2;
        }
        return 0;
    }

    public Class<? extends AffineCS> getInterface() {
        return AffineCS.class;
    }

    @Override
    public DefaultAffineCS forConvention(AxesConvention convention) {
        return (DefaultAffineCS)super.forConvention(convention);
    }

    @Override
    AbstractCS createForAxes(String name, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 2: 
            case 3: {
                return new DefaultAffineCS(this, name, axes);
            }
        }
        throw DefaultAffineCS.unexpectedDimension(axes, 2, 3);
    }

    DefaultAffineCS() {
    }
}

