/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.SubTypes;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

@XmlType(name="EllipsoidalCSType")
@XmlRootElement(name="EllipsoidalCS")
public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;

    public DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, axis0, axis1);
    }

    public DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
    }

    private DefaultEllipsoidalCS(DefaultEllipsoidalCS original, String name, CoordinateSystemAxis[] axes) {
        super(original, name, axes);
    }

    protected DefaultEllipsoidalCS(EllipsoidalCS original) {
        super((CoordinateSystem)original);
    }

    public static DefaultEllipsoidalCS castOrCopy(EllipsoidalCS object) {
        return object == null || object instanceof DefaultEllipsoidalCS ? (DefaultEllipsoidalCS)object : new DefaultEllipsoidalCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        boolean isVertical;
        boolean bl = isVertical = (direction = AxisDirections.absolute(direction)) == AxisDirection.UP;
        if (!isVertical && direction != AxisDirection.NORTH && direction != AxisDirection.EAST) {
            return 1;
        }
        if (!(!isVertical ? Units.isAngular(unit) : Units.isLinear(unit))) {
            return 2;
        }
        return 0;
    }

    @Override
    final void validate(Map<String, ?> properties) {
        super.validate(properties);
        int i = super.getDimension();
        int n = i - 2;
        while (--i >= 0) {
            AxisDirection direction = super.getAxis(i).getDirection();
            if (!AxisDirections.isVertical(direction) || --n >= 0) continue;
            throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)20, EllipsoidalCS.class, direction));
        }
    }

    public Class<? extends EllipsoidalCS> getInterface() {
        return EllipsoidalCS.class;
    }

    @Override
    public DefaultEllipsoidalCS forConvention(AxesConvention convention) {
        return (DefaultEllipsoidalCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(String name, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 1: {
                return SubTypes.createOneDimensional(this, name, axes);
            }
            case 2: 
            case 3: {
                return new DefaultEllipsoidalCS(this, name, axes);
            }
        }
        throw DefaultEllipsoidalCS.unexpectedDimension(axes, 1, 3);
    }

    private DefaultEllipsoidalCS() {
    }
}

