/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;

@XmlType(name="VerticalCSType")
@XmlRootElement(name="VerticalCS")
public class DefaultVerticalCS
extends AbstractCS
implements VerticalCS {
    private static final long serialVersionUID = 1201155778896630499L;

    public DefaultVerticalCS(Map<String, ?> properties, CoordinateSystemAxis axis) {
        super(properties, axis);
    }

    private DefaultVerticalCS(DefaultVerticalCS original, String name, CoordinateSystemAxis[] axes) {
        super(original, name, axes);
    }

    protected DefaultVerticalCS(VerticalCS original) {
        super((CoordinateSystem)original);
    }

    public static DefaultVerticalCS castOrCopy(VerticalCS object) {
        return object == null || object instanceof DefaultVerticalCS ? (DefaultVerticalCS)object : new DefaultVerticalCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirections.isVertical(direction)) {
            return 1;
        }
        if ((unit = unit.getSystemUnit()).equals((Object)Units.METRE) || unit.equals((Object)Units.PASCAL) || unit.equals((Object)Units.SECOND) || unit.equals((Object)Units.UNITY)) {
            return 0;
        }
        return 2;
    }

    public Class<? extends VerticalCS> getInterface() {
        return VerticalCS.class;
    }

    @Override
    public DefaultVerticalCS forConvention(AxesConvention convention) {
        return (DefaultVerticalCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(String name, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 1: {
                return new DefaultVerticalCS(this, name, axes);
            }
        }
        throw DefaultVerticalCS.unexpectedDimension(axes, 1, 1);
    }

    private DefaultVerticalCS() {
    }
}

