/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.internal.shared.Visitor;
import org.apache.sis.pending.geoapi.filter.BetweenComparisonOperator;
import org.apache.sis.pending.geoapi.filter.BinaryComparisonOperator;
import org.apache.sis.pending.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.LogicalOperator;
import org.apache.sis.pending.geoapi.filter.LogicalOperatorName;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.GeometryEncoding;
import org.apache.sis.storage.sql.feature.SelectionClause;

public class SelectionClauseWriter
extends Visitor<AbstractFeature, SelectionClause> {
    protected static final SelectionClauseWriter DEFAULT = new SelectionClauseWriter();

    private SelectionClauseWriter() {
        this.setFilterHandler((Enum)LogicalOperatorName.AND, new Logic(" AND ", false));
        this.setFilterHandler((Enum)LogicalOperatorName.OR, new Logic(" OR ", false));
        this.setFilterHandler((Enum)LogicalOperatorName.NOT, new Logic("NOT ", true));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_EQUAL_TO, new Comparison(" = "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_NOT_EQUAL_TO, new Comparison(" <> "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_GREATER_THAN, new Comparison(" > "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO, new Comparison(" >= "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_LESS_THAN, new Comparison(" < "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_LESS_THAN_OR_EQUAL_TO, new Comparison(" <= "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_BETWEEN, (f, sql) -> {
            BetweenComparisonOperator filter = (BetweenComparisonOperator)f;
            if (this.write((SelectionClause)sql, (Expression<AbstractFeature, ?>)filter.getExpression())) {
                return;
            }
            sql.append(" BETWEEN ");
            if (this.write((SelectionClause)sql, (Expression<AbstractFeature, ?>)filter.getLowerBoundary())) {
                return;
            }
            sql.append(" AND ");
            this.write((SelectionClause)sql, (Expression<AbstractFeature, ?>)filter.getUpperBoundary());
        });
        this.setNullAndNilHandlers((filter, sql) -> {
            List expressions = filter.getExpressions();
            if (expressions.size() == 1) {
                this.write((SelectionClause)sql, (Expression<AbstractFeature, ?>)((Expression)expressions.get(0)));
                sql.append(" IS NULL");
            } else {
                sql.invalidate();
            }
        });
        this.setFilterHandler((Enum)SpatialOperatorName.CONTAINS, new Function("ST_Contains"));
        this.setFilterHandler((Enum)SpatialOperatorName.CROSSES, new Function("ST_Crosses"));
        this.setFilterHandler((Enum)SpatialOperatorName.DISJOINT, new Function("ST_Disjoint"));
        this.setFilterHandler((Enum)SpatialOperatorName.EQUALS, new Function("ST_Equals"));
        this.setFilterHandler((Enum)SpatialOperatorName.INTERSECTS, new Function("ST_Intersects"));
        this.setFilterHandler((Enum)SpatialOperatorName.OVERLAPS, new Function("ST_Overlaps"));
        this.setFilterHandler((Enum)SpatialOperatorName.TOUCHES, new Function("ST_Touches"));
        this.setFilterHandler((Enum)SpatialOperatorName.WITHIN, new Function("ST_Within"));
        this.setExpressionHandler("Add", new Arithmetic(" + "));
        this.setExpressionHandler("Subtract", new Arithmetic(" - "));
        this.setExpressionHandler("Divide", new Arithmetic(" / "));
        this.setExpressionHandler("Multiply", new Arithmetic(" * "));
        this.setExpressionHandler("Literal", (e, sql) -> sql.appendLiteral(((Literal)e).getValue()));
        this.setExpressionHandler("ValueReference", (e, sql) -> sql.appendColumnName((ValueReference)e));
        this.setExpressionHandler("PropertyName", this.getExpressionHandler("ValueReference"));
    }

    protected SelectionClauseWriter(SelectionClauseWriter source) {
        super((Visitor)source, true, false);
    }

    protected SelectionClauseWriter duplicate() {
        return new SelectionClauseWriter(this);
    }

    final SelectionClauseWriter removeUnsupportedFunctions(Database<?> database) {
        HashMap<String, SpatialOperatorName> unsupported = new HashMap<String, SpatialOperatorName>();
        String[][] accessors = GeometryEncoding.initial();
        try (Connection c = database.source.getConnection();){
            DatabaseMetaData metadata = c.getMetaData();
            boolean lowerCase = metadata.storesLowerCaseIdentifiers();
            boolean upperCase = metadata.storesUpperCaseIdentifiers();
            for (SpatialOperatorName type : SpatialOperatorName.values()) {
                BiConsumer function = this.getFilterHandler((Enum)type);
                if (!(function instanceof Function)) continue;
                String name = ((Function)function).name;
                if (lowerCase) {
                    name = name.toLowerCase(Locale.US);
                }
                if (upperCase) {
                    name = name.toUpperCase(Locale.US);
                }
                unsupported.put(name, type);
            }
            String prefix = database.escapeWildcards(lowerCase ? "st_" : "ST_");
            try (ResultSet r = metadata.getFunctions(database.catalogOfSpatialTables, database.schemaOfSpatialTables, prefix + "%");){
                while (r.next()) {
                    String function = r.getString("FUNCTION_NAME");
                    GeometryEncoding.checkSupport(accessors, function);
                    unsupported.remove(function);
                }
            }
        }
        catch (SQLException e) {
            database.listeners.warning((Exception)e);
        }
        database.setGeometryEncodingFunctions(accessors);
        if (unsupported.isEmpty()) {
            return this;
        }
        SelectionClauseWriter copy = this.duplicate();
        copy.removeFilterHandlers(unsupported.values());
        return copy;
    }

    protected final void typeNotFound(Enum<?> type, Filter<AbstractFeature> filter, SelectionClause sql) {
        sql.invalidate();
    }

    protected final void typeNotFound(String type, Expression<AbstractFeature, ?> expression, SelectionClause sql) {
        sql.invalidate();
    }

    final boolean write(SelectionClause sql, Filter<? super AbstractFeature> filter) {
        this.visit(filter, sql);
        return sql.isInvalid();
    }

    private boolean write(SelectionClause sql, Expression<AbstractFeature, ?> expression) {
        this.visit(expression, sql);
        return sql.isInvalid();
    }

    protected final void writeBinaryOperator(SelectionClause sql, Filter<AbstractFeature> filter, String operator) {
        this.writeParameters(sql, filter.getExpressions(), operator, true);
    }

    private void writeParameters(SelectionClause sql, List<Expression<AbstractFeature, ?>> expressions, String separator, boolean binary) {
        int n = expressions.size();
        if (binary && n != 2) {
            sql.invalidate();
            return;
        }
        sql.append('(');
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sql.append(separator);
            }
            if (!this.write(sql, expressions.get(i))) continue;
            return;
        }
        sql.append(')');
    }

    private final class Logic
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        private final String operator;
        private final boolean unary;

        Logic(String operator, boolean unary) {
            this.operator = operator;
            this.unary = unary;
        }

        @Override
        public void accept(Filter<AbstractFeature> f, SelectionClause sql) {
            LogicalOperator filter = (LogicalOperator)f;
            List operands = filter.getOperands();
            int n = operands.size();
            if (this.unary ? n != 1 : n == 0) {
                sql.invalidate();
            } else {
                if (this.unary) {
                    sql.append(this.operator);
                }
                sql.append('(');
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        sql.append(this.operator);
                    }
                    if (!SelectionClauseWriter.this.write(sql, (Filter<? super AbstractFeature>)((Filter)operands.get(i)))) continue;
                    return;
                }
                sql.append(')');
            }
        }
    }

    private final class Comparison
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        private final String operator;

        Comparison(String operator) {
            this.operator = operator;
        }

        @Override
        public void accept(Filter<AbstractFeature> f, SelectionClause sql) {
            BinaryComparisonOperator filter = (BinaryComparisonOperator)f;
            if (filter.isMatchingCase()) {
                SelectionClauseWriter.this.writeBinaryOperator(sql, (Filter<AbstractFeature>)filter, this.operator);
            } else {
                sql.invalidate();
            }
        }
    }

    private final class Function
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        final String name;

        Function(String name) {
            this.name = name;
        }

        @Override
        public void accept(Filter<AbstractFeature> filter, SelectionClause sql) {
            Expression exp;
            sql.appendSpatialFunction(this.name);
            List expressions = filter.getExpressions();
            Iterator iterator = expressions.iterator();
            while (!(!iterator.hasNext() || (exp = (Expression)iterator.next()) instanceof ValueReference && sql.acceptColumnCRS((ValueReference)exp))) {
            }
            SelectionClauseWriter.this.writeParameters(sql, expressions, ", ", false);
            sql.clearColumnCRS();
        }
    }

    private final class Arithmetic
    implements BiConsumer<Expression<AbstractFeature, ?>, SelectionClause> {
        private final String operator;

        Arithmetic(String operator) {
            this.operator = operator;
        }

        @Override
        public void accept(Expression<AbstractFeature, ?> expression, SelectionClause sql) {
            SelectionClauseWriter.this.writeParameters(sql, expression.getParameters(), this.operator, true);
        }
    }
}

