/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import jakarta.xml.bind.JAXBException;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.AuxiliaryContent;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.base.URIDataStoreProvider;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.storage.wkt.StoreFormat;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.internal.shared.ExceptionSimplifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class PRJDataStore
extends URIDataStore {
    protected static final String PRJ = "prj";
    protected CoordinateReferenceSystem crs;

    protected PRJDataStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.crs = (CoordinateReferenceSystem)connector.getOption(OptionKey.DEFAULT_CRS);
    }

    protected Convention getConvention() {
        return Convention.WKT1_COMMON_UNITS;
    }

    protected final void readPRJ(Class<? extends DataStore> caller, String method) throws DataStoreException {
        this.readWKT(caller, method, CoordinateReferenceSystem.class, PRJ).ifPresent(result -> {
            this.crs = result;
        });
    }

    protected final <T> Optional<T> readWKT(Class<? extends DataStore> caller, String method, Class<T> type, String extension) throws DataStoreException {
        Exception cause = null;
        URISyntaxException suppressed = null;
        try {
            AuxiliaryContent content = this.readAuxiliaryFile(extension, true);
            if (content == null) {
                this.cannotReadAuxiliaryFile(caller, method, extension, null, true);
                return Optional.empty();
            }
            if (content.source != null) {
                try {
                    return Optional.of(type.cast(this.readXML(content.source)));
                }
                catch (JAXBException e) {
                    ExceptionSimplifier s = new ExceptionSimplifier((Object)content.getFilename(), (Exception)((Object)e));
                    throw new DataStoreException(s.getMessage(this.getLocale()), s.exception);
                }
            }
            String wkt = content.toString();
            StoreFormat format = new StoreFormat(this.dataLocale, this.timezone, null, this.listeners);
            format.setConvention(this.getConvention());
            try {
                format.setSourceFile(content.getURI());
            }
            catch (URISyntaxException e) {
                suppressed = e;
            }
            ParsePosition pos = new ParsePosition(0);
            T result = type.cast(format.parse(wkt, pos));
            if (result != null) {
                format.validate(null, caller, method, result);
                return Optional.of(result);
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.cannotReadAuxiliaryFile(caller, method, extension, e, true);
            return Optional.empty();
        }
        catch (IOException | ClassCastException | URISyntaxException | ParseException e) {
            cause = e;
        }
        DataStoreReferencingException e = new DataStoreReferencingException(this.cannotReadAuxiliaryFile(extension), cause);
        if (suppressed != null) {
            e.addSuppressed(suppressed);
        }
        throw e;
    }

    protected final void writePRJ() throws DataStoreException {
        block10: {
            try {
                if (this.crs == null) {
                    this.deleteAuxiliaryFile(PRJ);
                    break block10;
                }
                try (BufferedWriter out = this.writeAuxiliaryFile(PRJ);){
                    StoreFormat format = new StoreFormat(this.dataLocale, this.timezone, null, this.listeners);
                    format.setConvention(Convention.WKT2_2015);
                    format.format(this.crs, out);
                    out.newLine();
                }
            }
            catch (IOException e) {
                String identifier = this.getIdentifier().orElse(null);
                if (identifier == null) {
                    identifier = Classes.getShortClassName((Object)this);
                }
                throw new DataStoreException(Resources.format((short)69, identifier), e);
            }
        }
    }

    @Override
    public Optional<Resource.FileSet> getFileSet() throws DataStoreException {
        return this.listComponentFiles(PRJ);
    }

    protected final Optional<Resource.FileSet> listComponentFiles(String ... auxiliaries) throws DataStoreException {
        return super.getFileSet().map(fileset -> {
            ArrayList<Path> paths = new ArrayList<Path>(fileset.getPaths());
            Path path = paths.get(0);
            String base = PRJDataStore.getBaseFilename(path);
            boolean modified = false;
            for (String extension : auxiliaries) {
                Path p;
                if (extension == null || !Files.isRegularFile(p = path.resolveSibling(base.concat(extension)), new LinkOption[0])) continue;
                modified |= paths.add(p);
            }
            return modified ? new Resource.FileSet(paths) : fileset;
        });
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        Optional<ParameterValueGroup> op = super.getOpenParameters();
        op.ifPresent(pg -> pg.parameter("defaultCRS").setValue((Object)this.crs));
        return op;
    }

    public static abstract class Provider
    extends URIDataStoreProvider {
        static final String CRS_NAME = "defaultCRS";
        public static final ParameterDescriptor<CoordinateReferenceSystem> DEFAULT_CRS;

        protected Provider() {
        }

        @Override
        protected ParameterDescriptorGroup build(ParameterBuilder builder) {
            return builder.createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM, METADATA_PARAM, DEFAULT_CRS});
        }

        @Override
        public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
            StorageConnector connector = Provider.connector(this, Objects.requireNonNull(parameters));
            Parameters pg = Parameters.castOrWrap((ParameterValueGroup)parameters);
            connector.setOption(OptionKey.DEFAULT_CRS, (CoordinateReferenceSystem)pg.getValue(DEFAULT_CRS));
            return this.open(connector);
        }

        static {
            ParameterBuilder builder = new ParameterBuilder();
            DEFAULT_CRS = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)CRS_NAME)).setDescription((CharSequence)Vocabulary.formatInternational((short)36))).create(CoordinateReferenceSystem.class, null);
        }
    }
}

