/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.map.coverage;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.NumberFormat;
import java.util.Arrays;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.pending.jdk.JDK16;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class MultiResolutionCoverageLoader {
    private static final int DEFAULT_SIZE = 512;
    private static final int DEFAULT_SCALE_LOG = 3;
    private static final int DEFAULT_NUM_LEVELS = 4;
    public final GridCoverageResource resource;
    private final double[][] resolutionSquared;
    private final Reference<GridCoverage>[] coverages;
    private final Envelope areaOfInterest;
    private final int[] readRanges;

    public MultiResolutionCoverageLoader(GridCoverageResource resource, Envelope domain, int[] range) throws DataStoreException {
        this.resource = resource;
        this.areaOfInterest = domain;
        this.readRanges = range;
        double[][] resolutions = (double[][])resource.getResolutions().toArray(x$0 -> new double[x$0][]);
        if (resolutions.length <= 1) {
            GridGeometry gg = resource.getGridGeometry();
            if (resolutions.length != 0) {
                resolutions = MultiResolutionCoverageLoader.defaultResolutions(gg, resolutions[0]);
            } else if (gg.isDefined(16)) {
                resolutions = MultiResolutionCoverageLoader.defaultResolutions(gg, gg.getResolution(true));
            }
        }
        this.resolutionSquared = resolutions;
        for (double[] r : resolutions) {
            for (int i = 0; i < r.length; ++i) {
                int n = i;
                r[n] = r[n] * r[i];
            }
        }
        this.coverages = new Reference[Math.max(resolutions.length, 1)];
        resource.setLoadingStrategy(RasterLoadingStrategy.AT_GET_TILE_TIME);
    }

    private static double[][] defaultResolutions(GridGeometry gg, double[] base) {
        int numLevels = 1;
        if (gg.isDefined(2)) {
            Envelope envelope = gg.getEnvelope();
            int i = envelope.getDimension();
            while (--i >= 0) {
                double f = envelope.getSpan(i) / (512.0 * base[i]);
                int n = Math.getExponent(f);
                if (n >= 1023 || (n /= 3) <= numLevels) continue;
                numLevels = n;
            }
        } else {
            numLevels = 4;
        }
        double[][] resolutions = new double[numLevels][];
        resolutions[0] = base;
        for (int j = 1; j < numLevels; ++j) {
            base = (double[])base.clone();
            resolutions[j] = base;
            int i = 0;
            while (i < base.length) {
                int n = i++;
                base[n] = base[n] * 8.0;
            }
        }
        return resolutions;
    }

    final int getLastLevel() {
        return Math.max(this.resolutionSquared.length - 1, 0);
    }

    final int findPyramidLevel(MathTransform dataToObjective, LinearTransform objectiveToDisplay, DirectPosition objectivePOI) throws TransformException {
        int level = this.getLastLevel();
        if (level != 0) {
            LinearTransform displayToObjective = objectiveToDisplay.inverse();
            Matrix m = displayToObjective.getMatrix();
            Matrix d = dataToObjective != null && !dataToObjective.isIdentity() ? dataToObjective.inverse().derivative(objectivePOI) : null;
            int srcDim = m.getNumCol() - 1;
            int objDim = m.getNumRow() - 1;
            int tgtDim = d != null ? d.getNumRow() : objDim;
            block0: for (int j = 0; j < tgtDim; ++j) {
                double sum = 0.0;
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if (d == null) {
                        e = m.getElement(j, i);
                    } else {
                        e = 0.0;
                        for (int k = 0; k < objDim; ++k) {
                            e = Math.fma(d.getElement(j, k), m.getElement(k, i), e);
                        }
                    }
                    sum += e * e;
                }
                int levelOfMin = level;
                double minimum = Double.POSITIVE_INFINITY;
                while (true) {
                    double d2;
                    double r = this.resolutionSquared[level][j];
                    if (!(d2 > sum)) continue block0;
                    if (r < minimum) {
                        minimum = r;
                        levelOfMin = level;
                    }
                    if (level == 0) {
                        level = levelOfMin;
                        break block0;
                    }
                    --level;
                }
            }
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridCoverage getOrLoad(int level) throws DataStoreException {
        Reference<GridCoverage>[] referenceArray = this.coverages;
        synchronized (this.coverages) {
            Reference<GridCoverage> ref = this.coverages[level];
            if (ref != null) {
                GridCoverage coverage = ref.get();
                if (coverage != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return coverage;
                }
                this.coverages[level] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            GridGeometry domain = null;
            if (this.resolutionSquared.length != 0) {
                double[] resolutions = (double[])this.resolutionSquared[level].clone();
                for (int i = 0; i < resolutions.length; ++i) {
                    resolutions[i] = Math.sqrt(resolutions[i]);
                }
                LinearTransform gridToCRS = MathTransforms.scale((double[])resolutions);
                domain = new GridGeometry(PixelInCell.CELL_CORNER, (MathTransform)gridToCRS, this.areaOfInterest, GridRoundingMode.ENCLOSING);
            }
            GridCoverage coverage = this.resource.read(domain, this.readRanges);
            Reference<GridCoverage>[] referenceArray2 = this.coverages;
            synchronized (this.coverages) {
                GridCoverage c;
                Reference<GridCoverage> ref2 = this.coverages[level];
                if (ref2 != null && (c = ref2.get()) != null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return c;
                }
                this.coverages[level] = new SoftReference<GridCoverage>(coverage);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return coverage;
            }
        }
    }

    public final GridCoverage getOrLoad(GridGeometry domain, int[] range) throws DataStoreException {
        if (domain == null && this.areaOfInterest == null && Arrays.equals(this.readRanges, range)) {
            return this.getOrLoad(0);
        }
        if (domain == null) {
            domain = this.resource.getGridGeometry();
        }
        return this.resource.read(domain, this.readRanges);
    }

    public String toString() {
        int count = this.getLastLevel();
        double delta = this.magnitude(0);
        if (count != 0) {
            delta = (this.magnitude(count) - delta) / (double)count;
        }
        int n = Math.max(Math.min(DecimalFunctions.fractionDigitsForDelta((double)delta, (boolean)false), 6), 0);
        NumberFormat f = NumberFormat.getInstance();
        f.setMinimumFractionDigits(n);
        f.setMaximumFractionDigits(n);
        TableAppender table = new TableAppender("  ");
        table.setCellAlignment((byte)1);
        for (int level = 0; level <= count; ++level) {
            double[] rs;
            for (double r : rs = this.resolutionSquared[level]) {
                table.append((CharSequence)f.format(Math.sqrt(r)));
                table.nextColumn();
            }
            Reference<GridCoverage> ref = this.coverages[level];
            if (ref != null && !JDK16.refersTo(ref, null)) {
                table.append((CharSequence)"cached");
            }
            table.nextLine();
        }
        return table.toString();
    }

    private double magnitude(int level) {
        return Math.sqrt(Arrays.stream(this.resolutionSquared[level]).average().orElse(1.0));
    }
}

