/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.metadata.sql.internal.shared.SQLUtilities;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.GeometryEncoding;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Column
implements Cloneable {
    public final String name;
    public final String label;
    private String propertyName;
    public final int type;
    public final String typeName;
    private final int precision;
    public final boolean isNullable;
    private GeometryType geometryType;
    private boolean geometryAsText;
    private CoordinateReferenceSystem defaultCRS;
    ValueGetter<?> valueGetter;

    Column(int type, String typeName, String name) {
        this.label = this.propertyName = name;
        this.name = this.propertyName;
        this.type = type;
        this.typeName = typeName;
        this.precision = 0;
        this.isNullable = false;
    }

    Column(Analyzer analyzer, ResultSet metadata, String quote) throws SQLException {
        this.label = this.name = analyzer.getUniqueString(metadata, "COLUMN_NAME");
        this.type = metadata.getInt("DATA_TYPE");
        this.typeName = Column.localPart(metadata.getString("TYPE_NAME"), quote);
        this.precision = metadata.getInt("COLUMN_SIZE");
        this.isNullable = Boolean.TRUE.equals(SQLUtilities.parseBoolean((String)metadata.getString("IS_NULLABLE")));
        this.propertyName = this.label;
    }

    Column(ResultSetMetaData metadata, int column, String quote) throws SQLException {
        this.name = metadata.getColumnName(column);
        this.label = metadata.getColumnLabel(column);
        this.type = metadata.getColumnType(column);
        this.typeName = Column.localPart(metadata.getColumnTypeName(column), quote);
        this.precision = metadata.getPrecision(column);
        this.isNullable = metadata.isNullable(column) == 1;
        this.propertyName = this.label;
    }

    private static String localPart(String type, String quote) throws SQLDataException {
        int start;
        int end;
        if (type == null) {
            throw new SQLDataException(Errors.format((short)113, (Object)"TYPE_NAME"));
        }
        if (quote != null && (end = type.lastIndexOf(quote)) >= 0 && (start = type.lastIndexOf(quote, end - 1)) >= 0 && end > (start += quote.length())) {
            type = type.substring(start, end);
        }
        return type;
    }

    final void makeSpatial(Database<?> database, GeometryType type, CoordinateReferenceSystem crs) throws DataStoreContentException {
        String property;
        if (this.geometryType != null && !this.geometryType.equals((Object)type)) {
            property = "geometryType";
        } else if (this.defaultCRS != null && !this.defaultCRS.equals((Object)crs)) {
            property = "defaultCRS";
        } else {
            this.geometryType = type;
            this.defaultCRS = crs;
            this.geometryAsText = database.getGeometryEncoding(this) == GeometryEncoding.WKT;
            return;
        }
        throw new DataStoreContentException(Errors.forLocale((Locale)database.listeners.getLocale()).getString((short)202, (Object)property));
    }

    final void tryMakeSpatial(Analyzer analyzer) throws Exception {
        try {
            this.geometryType = GeometryType.forName((String)this.typeName);
            this.geometryAsText = analyzer.database.getGeometryEncoding(this) == GeometryEncoding.WKT;
            InfoStatements spatialInformation = analyzer.spatialInformation;
            if (spatialInformation != null) {
                spatialInformation.completeIntrospection(analyzer, null, Map.of());
                this.defaultCRS = spatialInformation.guessCRS(this.name);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    final Column rename(String property) {
        if (property.equals(this.propertyName)) {
            return this;
        }
        Column c = this.clone();
        c.propertyName = property;
        return c;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    final void setPropertyName(AttributeTypeBuilder<?> attribute) {
        this.propertyName = attribute.getName().toString();
    }

    public final Optional<GeometryType> getGeometryType() {
        return Optional.ofNullable(this.geometryType);
    }

    public final GeometryEncoding getGeometryEncoding() {
        return this.geometryAsText ? GeometryEncoding.WKT : GeometryEncoding.WKB;
    }

    public final Optional<CoordinateReferenceSystem> getDefaultCRS() {
        return Optional.ofNullable(this.defaultCRS);
    }

    final AttributeTypeBuilder<?> createAttribute(FeatureTypeBuilder feature) {
        Class valueType = this.valueGetter.valueType;
        boolean isArray = this.valueGetter instanceof ValueGetter.AsArray;
        if (isArray) {
            valueType = ((ValueGetter.AsArray)this.valueGetter).cmget.valueType;
        }
        AttributeTypeBuilder attribute = feature.addAttribute(valueType).setName((CharSequence)this.propertyName);
        if (this.precision > 0 && this.precision != Integer.MAX_VALUE && CharSequence.class.isAssignableFrom(valueType)) {
            attribute.setMaximalLength(Integer.valueOf(this.precision));
        }
        if (isArray) {
            attribute.setMinimumOccurs(0);
            attribute.setMaximumOccurs(Integer.MAX_VALUE);
        } else if (this.isNullable) {
            attribute.setMinimumOccurs(0);
        }
        if (this.geometryType != null || this.defaultCRS != null) {
            attribute.setCRS(this.defaultCRS);
        }
        return attribute;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"name", this.name, "propertyName", this.propertyName, "type", this.type, "typeName", this.typeName, "geometryType", this.geometryType, "precision", this.precision, "isNullable", this.isNullable});
    }

    protected final Column clone() {
        try {
            return (Column)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

