/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.measure.ElevationAngle;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.AxisName;
import org.apache.sis.referencing.cs.Codes;
import org.apache.sis.referencing.cs.DefaultCompoundCS;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.operation.Matrix;

public final class CoordinateSystems {
    private CoordinateSystems() {
    }

    public static boolean isGeodetic(CoordinateSystem cs) {
        return cs instanceof EllipsoidalCS || cs instanceof CartesianCS || cs instanceof SphericalCS;
    }

    public static AxisDirection parseAxisDirection(String name) throws IllegalArgumentException {
        ArgumentChecks.ensureNonEmpty((String)"name", (CharSequence)name);
        name = name.strip();
        AxisDirection candidate = AxisDirections.valueOf(name);
        if (candidate != null) {
            return candidate;
        }
        DirectionAlongMeridian meridian = DirectionAlongMeridian.parse(name);
        if (meridian != null) {
            candidate = meridian.getDirection();
            assert (candidate == AxisDirections.valueOf(meridian.toString()));
            return candidate;
        }
        throw new IllegalArgumentException(Resources.format((short)67, name));
    }

    public static AxisDirection directionAlongMeridian(AxisDirection baseDirection, double meridian) {
        return new DirectionAlongMeridian(baseDirection, meridian).getDirection();
    }

    public static boolean isAlongMeridian(AxisDirection direction) {
        return AxisDirections.isUserDefined(direction) && DirectionAlongMeridian.matches(direction.name());
    }

    public static org.apache.sis.measure.Angle angle(AxisDirection source, AxisDirection target) {
        DirectionAlongMeridian tgtMeridian;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"target", (Object)target);
        int c = AxisDirections.angleForCompass(source, target);
        if (c != Integer.MIN_VALUE) {
            return new org.apache.sis.measure.Angle((double)c * 22.5);
        }
        c = AxisDirections.angleForGeocentric(source, target);
        if (c != Integer.MIN_VALUE) {
            return new org.apache.sis.measure.Angle((double)(c * 90));
        }
        c = AxisDirections.angleForVehicle(source, target);
        if (c != Integer.MIN_VALUE) {
            return new org.apache.sis.measure.Angle((double)(c * 90));
        }
        c = AxisDirections.angleForDisplay(source, target);
        if (c != Integer.MIN_VALUE) {
            return new org.apache.sis.measure.Angle((double)(c * 90));
        }
        DirectionAlongMeridian srcMeridian = AxisDirections.isUserDefined(source) ? DirectionAlongMeridian.parse(source) : null;
        DirectionAlongMeridian directionAlongMeridian = tgtMeridian = AxisDirections.isUserDefined(target) ? DirectionAlongMeridian.parse(target) : null;
        if (srcMeridian != null && tgtMeridian != null) {
            return new org.apache.sis.measure.Angle(srcMeridian.angle(tgtMeridian));
        }
        boolean srcVrt = AxisDirections.isVertical(source);
        boolean tgtVrt = AxisDirections.isVertical(target);
        if (tgtVrt) {
            if (srcVrt) {
                return new org.apache.sis.measure.Angle(source.equals((Object)target) ? 0.0 : (target.equals((Object)AxisDirection.UP) ? 180.0 : -180.0));
            }
            if (AxisDirections.isCompass(source) || srcMeridian != null) {
                return target.equals((Object)AxisDirection.UP) ? ElevationAngle.ZENITH : ElevationAngle.NADIR;
            }
        } else if (srcVrt && (AxisDirections.isCompass(target) || tgtMeridian != null)) {
            return source.equals((Object)AxisDirection.UP) ? ElevationAngle.NADIR : ElevationAngle.ZENITH;
        }
        return null;
    }

    static boolean hasAllTargetTypes(CoordinateSystem sourceCS, CoordinateSystem targetCS) {
        List<CoordinateSystem> sources = CoordinateSystems.getSingleComponents(sourceCS);
        List<CoordinateSystem> targets = CoordinateSystems.getSingleComponents(targetCS);
        block0: for (CoordinateSystem cs : targets) {
            for (int i = 0; i < sources.size(); ++i) {
                if (!Classes.implementSameInterfaces((Class)sources.get(i).getClass(), (Class)cs.getClass(), CoordinateSystem.class)) continue;
                sources.remove(i);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static Matrix swapAndScaleAxes(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws IllegalArgumentException, IncommensurableException {
        if (sourceCS == targetCS) {
            return Matrices.createIdentity(sourceCS.getDimension() + 1);
        }
        if (!Classes.implementSameInterfaces((Class)sourceCS.getClass(), (Class)targetCS.getClass(), CoordinateSystem.class) && !CoordinateSystems.hasAllTargetTypes(sourceCS, targetCS)) {
            throw new IllegalArgumentException(Resources.format((short)27));
        }
        Object[] srcAxes = CoordinateSystems.getAxisDirections(sourceCS);
        Object[] dstAxes = CoordinateSystems.getAxisDirections(targetCS);
        MatrixSIS matrix = Matrices.createTransform((AxisDirection[])srcAxes, (AxisDirection[])dstAxes);
        assert (Arrays.equals(srcAxes, dstAxes) == matrix.isIdentity()) : matrix;
        int sourceDim = matrix.getNumCol() - 1;
        int targetDim = matrix.getNumRow() - 1;
        for (int j = 0; j < targetDim; ++j) {
            Unit targetUnit = targetCS.getAxis(j).getUnit();
            for (int i = 0; i < sourceDim; ++i) {
                Unit sourceUnit;
                if (matrix.getElement(j, i) == 0.0 || Objects.equals(sourceUnit = sourceCS.getAxis(i).getUnit(), targetUnit)) continue;
                Number scale = 1;
                Number offset = 0;
                Number[] coefficients = Units.coefficients((UnitConverter)sourceUnit.getConverterToAny(targetUnit));
                switch (coefficients != null ? coefficients.length : -1) {
                    case 2: {
                        scale = coefficients[1];
                    }
                    case 1: {
                        offset = coefficients[0];
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new IncommensurableException(Resources.format((short)54, sourceUnit, targetUnit));
                    }
                }
                boolean decimal = true;
                DoubleDouble shift = DoubleDouble.of((Number)matrix.getNumber(j, sourceDim), (boolean)true);
                DoubleDouble factor = DoubleDouble.of((Number)matrix.getNumber(j, i), (boolean)true);
                matrix.setNumber(j, i, (Number)factor.multiply(scale, true));
                matrix.setNumber(j, sourceDim, (Number)factor.multiply(offset, true).add(shift));
            }
        }
        return matrix;
    }

    public static CoordinateSystem replaceAxes(CoordinateSystem cs, AxisFilter filter) {
        ArgumentChecks.ensureNonNull((String)"filter", (Object)filter);
        if (cs != null) {
            AbstractCS newCS;
            if (filter instanceof AxesConvention) {
                if (cs instanceof AbstractCS) {
                    return ((AbstractCS)cs).forConvention((AxesConvention)filter);
                }
                newCS = Normalizer.forConvention(cs, (AxesConvention)filter);
            } else {
                newCS = Normalizer.normalize(cs, filter, false);
            }
            if (newCS != null) {
                return newCS;
            }
        }
        return cs;
    }

    public static CoordinateSystem replaceLinearUnit(CoordinateSystem cs, final Unit<Length> newUnit) {
        ArgumentChecks.ensureNonNull((String)"newUnit", newUnit);
        return CoordinateSystems.replaceAxes(cs, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
                return Units.isLinear(unit) ? newUnit : unit;
            }
        });
    }

    public static CoordinateSystem replaceAngularUnit(CoordinateSystem cs, final Unit<Angle> newUnit) {
        ArgumentChecks.ensureNonNull((String)"newUnit", newUnit);
        return CoordinateSystems.replaceAxes(cs, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
                return Units.isAngular(unit) ? newUnit : unit;
            }
        });
    }

    public static List<CoordinateSystem> getSingleComponents(CoordinateSystem cs) {
        ArrayList<CoordinateSystem> addTo = new ArrayList<CoordinateSystem>(3);
        CoordinateSystems.getSingleComponents(cs, addTo);
        return addTo;
    }

    private static void getSingleComponents(CoordinateSystem cs, List<CoordinateSystem> addTo) {
        if (cs != null) {
            if (cs instanceof DefaultCompoundCS) {
                for (CoordinateSystem c : ((DefaultCompoundCS)cs).getComponents()) {
                    CoordinateSystems.getSingleComponents(c, addTo);
                }
            } else {
                addTo.add(cs);
            }
        }
    }

    public static AxisDirection[] getAxisDirections(CoordinateSystem cs) {
        AxisDirection[] directions = new AxisDirection[cs.getDimension()];
        for (int i = 0; i < directions.length; ++i) {
            CoordinateSystemAxis axis = cs.getAxis(i);
            ArgumentChecks.ensureNonNullElement((String)"cs", (int)i, (Object)cs);
            directions[i] = axis.getDirection();
            ArgumentChecks.ensureNonNullElement((String)"cs[#].direction", (int)i, (Object)directions[i]);
        }
        return directions;
    }

    public static AxisDirection[] getSimpleAxisDirections(CoordinateSystem cs) {
        AxisDirection[] directions = CoordinateSystems.getAxisDirections(cs);
        for (int i = 0; i < directions.length; ++i) {
            AxisDirection r;
            String abbreviation;
            if (!CoordinateSystems.isAlongMeridian(directions[i]) || (abbreviation = cs.getAxis(i).getAbbreviation()) == null || abbreviation.length() != 1 || (r = AxisDirections.fromAbbreviation(abbreviation.charAt(0))) == null) continue;
            directions[i] = r;
        }
        return directions;
    }

    public static String getShortName(CoordinateSystemAxis axis, Locale locale) {
        return AxisName.find(Objects.requireNonNull(axis), locale);
    }

    public static Integer getEpsgCode(Class<? extends CoordinateSystem> type, CoordinateSystemAxis ... axes) {
        ArgumentChecks.ensureNonNull((String)"type", type);
        block1 : switch (axes.length) {
            case 3: {
                if (!Units.METRE.equals((Object)axes[2].getUnit())) break;
            }
            case 2: {
                boolean isAngular;
                Unit unit = axes[0].getUnit();
                if (unit == null || !unit.equals((Object)axes[1].getUnit()) || (!(isAngular = Units.isAngular((Unit)unit)) || !type.isAssignableFrom(EllipsoidalCS.class)) && (!Units.isLinear((Unit)unit) || !type.isAssignableFrom(CartesianCS.class))) break;
                AxisDirection[] directions = new AxisDirection[axes.length];
                for (int i = 0; i < directions.length; ++i) {
                    CoordinateSystemAxis axis = axes[i];
                    ArgumentChecks.ensureNonNullElement((String)"axes", (int)i, (Object)axis);
                    directions[i] = axis.getDirection();
                    if (!isAngular || axis.getRangeMeaning() != RangeMeaning.WRAPAROUND) continue;
                    try {
                        UnitConverter uc = unit.getConverterToAny(Units.DEGREE);
                        double min = uc.convert(axis.getMinimumValue());
                        double max = uc.convert(axis.getMaximumValue());
                        if (min > Double.NEGATIVE_INFINITY && Math.abs(min - -180.0) > 8.999280057595393E-8) break block1;
                        if (!(max < Double.POSITIVE_INFINITY) || !(Math.abs(max - 180.0) > 8.999280057595393E-8)) continue;
                    }
                    catch (IncommensurableException e) {
                        Logging.unexpectedException((Logger)AbstractCS.LOGGER, CoordinateSystems.class, (String)"getEpsgCode", (Throwable)e);
                    }
                    break block1;
                }
                return CoordinateSystems.getEpsgCode(unit, directions);
            }
        }
        return null;
    }

    public static Integer getEpsgCode(Unit<?> unit, AxisDirection ... directions) {
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        ArgumentChecks.ensureNonNull((String)"directions", (Object)directions);
        short code = Codes.lookup(unit, directions);
        return code != 0 ? Integer.valueOf(code) : null;
    }
}

