/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.testing.mock.jcr.MockUserManager;
import org.apache.sling.testing.mock.jcr.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MockAuthorizable
implements Authorizable {
    protected Set<String> notAuthorizablePropNames = new HashSet<String>(Arrays.asList("jcr:primaryType", "rep:authorizableId", "rep:principalName"));
    protected String id;
    protected Principal principal;
    protected MockUserManager mockUserMgr;
    protected Node homeNode;

    MockAuthorizable(@Nullable String id, @Nullable Principal principal, @NotNull Node homeNode, @NotNull MockUserManager mockUserMgr) {
        this.principal = principal;
        this.id = id == null && principal != null ? principal.getName() : id;
        if (principal == null) {
            this.principal = () -> this.id;
        }
        this.homeNode = homeNode;
        this.mockUserMgr = mockUserMgr;
    }

    @NotNull
    public String getID() throws RepositoryException {
        return this.id;
    }

    public boolean isGroup() {
        return this instanceof Group;
    }

    @NotNull
    public Principal getPrincipal() throws RepositoryException {
        return this.principal;
    }

    @NotNull
    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        HashSet<Group> declaredMemberOf = new HashSet<Group>();
        Set<Authorizable> all = this.mockUserMgr.all(2);
        for (Authorizable authorizable : all) {
            Group group = (Group)authorizable;
            if (!group.isDeclaredMember((Authorizable)this)) continue;
            declaredMemberOf.add(group);
        }
        return declaredMemberOf.iterator();
    }

    @NotNull
    public Iterator<Group> memberOf() throws RepositoryException {
        HashSet<Group> memberOf = new HashSet<Group>();
        this.calcMemberOf(memberOf, this, new HashSet<Authorizable>());
        return memberOf.iterator();
    }

    private void calcMemberOf(Set<Group> memberOf, Authorizable authorizable, Set<Authorizable> processedAuthorizables) throws RepositoryException {
        if (!processedAuthorizables.contains(authorizable)) {
            processedAuthorizables.add(authorizable);
            @NotNull Iterator declaredIt = authorizable.declaredMemberOf();
            while (declaredIt.hasNext()) {
                Group group = (Group)declaredIt.next();
                memberOf.add(group);
                this.calcMemberOf(memberOf, (Authorizable)group, processedAuthorizables);
            }
        }
    }

    public void remove() throws RepositoryException {
        this.mockUserMgr.removeAuthorizable(this);
    }

    @NotNull
    public Iterator<String> getPropertyNames() throws RepositoryException {
        HashSet<String> propNames = new HashSet<String>();
        PropertyIterator properties = this.homeNode.getProperties();
        while (properties.hasNext()) {
            Property nextProperty = properties.nextProperty();
            if (this.notAuthorizablePropNames.contains(nextProperty.getName())) continue;
            propNames.add(nextProperty.getName());
        }
        return propNames.iterator();
    }

    @NotNull
    public Iterator<String> getPropertyNames(@NotNull String relPath) throws RepositoryException {
        HashSet<String> propNames = new HashSet<String>();
        if (this.homeNode.hasNode(relPath)) {
            PropertyIterator properties = this.homeNode.getNode(relPath).getProperties();
            while (properties.hasNext()) {
                Property nextProperty = properties.nextProperty();
                if (this.notAuthorizablePropNames.contains(nextProperty.getName())) continue;
                propNames.add(nextProperty.getName());
            }
        }
        return propNames.iterator();
    }

    public boolean hasProperty(@NotNull String relPath) throws RepositoryException {
        return this.homeNode.hasProperty(relPath);
    }

    protected Node createIntermediateNodes(@NotNull String relPath) throws RepositoryException {
        String[] segments = relPath.split("/");
        Node node = this.homeNode;
        for (int i = 0; i < segments.length - 1; ++i) {
            String segment = segments[i];
            node = node.hasNode(segment) ? node.getNode(segment) : node.addNode(segment, "rep:AuthorizableFolder");
        }
        return node;
    }

    public void setProperty(@NotNull String relPath, @Nullable Value value) throws RepositoryException {
        Node node = this.createIntermediateNodes(relPath);
        String propName = ResourceUtil.getName(relPath);
        node.setProperty(propName, value);
    }

    public void setProperty(@NotNull String relPath, @Nullable Value[] value) throws RepositoryException {
        Node node = this.createIntermediateNodes(relPath);
        String propName = ResourceUtil.getName(relPath);
        node.setProperty(propName, value);
    }

    @Nullable
    public Value[] getProperty(@NotNull String relPath) throws RepositoryException {
        if (this.homeNode.hasProperty(relPath)) {
            Property property = this.homeNode.getProperty(relPath);
            if (property.isMultiple()) {
                return property.getValues();
            }
            return new Value[]{property.getValue()};
        }
        return null;
    }

    public boolean removeProperty(@NotNull String relPath) throws RepositoryException {
        boolean removed = false;
        if (this.homeNode.hasProperty(relPath)) {
            this.homeNode.getProperty(relPath).remove();
            removed = true;
        }
        return removed;
    }

    @NotNull
    public String getPath() throws RepositoryException {
        return this.homeNode.getPath();
    }
}

