/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.Logger;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class ReplaceContentRule
extends Rule {
    private Pattern pattern;
    private String replacement;
    private Pattern contentType;
    private Pattern path;

    public ReplaceContentRule(String id, Pattern pattern, String replacement, Pattern contentType, Pattern path) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.path = path;
        this.contentType = contentType;
        this.setId(id);
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        String uri = request.getRequestURI();
        if (this.path != null && !this.path.matcher(uri).matches()) {
            return new DoNothingAction();
        }
        if (this.contentType != null && response.getContentType() != null && !this.contentType.matcher(response.getContentType()).matches()) {
            return new DoNothingAction();
        }
        byte[] bytes = null;
        try {
            bytes = response.getInterceptingServletOutputStream().getResponseBytes();
        }
        catch (IOException ioe) {
            this.log(request, "Error matching pattern '" + this.pattern.pattern() + "', IOException encountered (possibly too large?): " + ioe.getMessage() + " (in response to URL: '" + request.getRequestURL() + "')");
            return new DoNothingAction();
        }
        try {
            String s = new String(bytes, response.getCharacterEncoding());
            Matcher m = this.pattern.matcher(s);
            String canary = m.replaceAll(this.replacement);
            try {
                if (!s.equals(canary)) {
                    response.getInterceptingServletOutputStream().setResponseBytes(canary.getBytes(response.getCharacterEncoding()));
                    logger.debug(Logger.SECURITY_SUCCESS, "Successfully replaced pattern '" + this.pattern.pattern() + "' on response to URL '" + request.getRequestURL() + "'");
                }
            }
            catch (IOException ioe) {
                logger.error(Logger.SECURITY_FAILURE, "Failed to replace pattern '" + this.pattern.pattern() + "' on response to URL '" + request.getRequestURL() + "' due to [" + ioe.getMessage() + "]");
            }
        }
        catch (UnsupportedEncodingException uee) {
            logger.error(Logger.SECURITY_FAILURE, "Failed to replace pattern '" + this.pattern.pattern() + "' on response to URL '" + request.getRequestURL() + "' due to [" + uee.getMessage() + "]");
        }
        return new DoNothingAction();
    }
}

