/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.schema.AttributeElement;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.DocType;
import com.google.gxp.compiler.schema.ElementValidator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

class ElementBuilder {
    private final String name;
    private final Set<ElementValidator.Flag> flags;
    private final String contentType;
    private final Set<DocType> docTypes;
    private final Map<String, AttributeElement> attrs = Maps.newHashMap();

    public String getName() {
        return this.name;
    }

    ElementBuilder(String name, Set<ElementValidator.Flag> flags, String contentType, Set<DocType> docTypes) {
        this.name = name;
        this.flags = ImmutableSet.copyOf(flags);
        this.contentType = contentType;
        this.docTypes = ImmutableSet.copyOf(docTypes);
    }

    public void add(AttributeElement attribute) {
        if (this.attrs.get(attribute.getName()) != null) {
            throw new IllegalStateException("Duplicate attributes called " + attribute.getName() + " in <" + this.getName() + ">");
        }
        this.attrs.put(attribute.getName(), attribute);
    }

    ElementValidator build() {
        ArrayList<AttributeValidator> attrValidators = Lists.newArrayList();
        for (AttributeElement attr : this.attrs.values()) {
            attrValidators.add(attr.getAttributeValidator());
        }
        return new ElementValidator(this.name, this.flags, this.contentType, this.docTypes, attrValidators);
    }
}

