/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.autotag.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tiles.autotag.model.TemplateParameter;

public class TemplateMethod {
    private String name;
    private String documentation;
    private Map<String, TemplateParameter> parameters;

    public TemplateMethod(String name, Iterable<? extends TemplateParameter> parameters) {
        this.name = name;
        this.parameters = new LinkedHashMap<String, TemplateParameter>();
        for (TemplateParameter templateParameter : parameters) {
            this.parameters.put(templateParameter.getName(), templateParameter);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Collection<TemplateParameter> getParameters() {
        return this.parameters.values();
    }

    public TemplateParameter getParameterByName(String name) {
        return this.parameters.get(name);
    }

    public boolean hasBody() {
        if (this.parameters.size() >= 2) {
            for (TemplateParameter param : this.parameters.values()) {
                if (!param.isBody()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "TemplateMethod [name=" + this.name + ", documentation=" + this.documentation + ", parameters=" + this.parameters + "]";
    }
}

