/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.FileReader;
import org.apache.avro.mapred.Pair;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class SequenceFileReader<K, V>
implements FileReader<Pair<K, V>> {
    private SequenceFile.Reader reader;
    private Schema schema;
    private boolean ready = false;
    private boolean done = false;
    private Writable key;
    private Writable spareKey;
    private Writable value;
    private Converter<K> keyConverter = new Converter<K>(){

        @Override
        public K convert(Writable o) {
            return o;
        }
    };
    private Converter<V> valConverter = new Converter<V>(){

        @Override
        public V convert(Writable o) {
            return o;
        }
    };
    private static final Map<Type, Schema> WRITABLE_SCHEMAS = new HashMap<Type, Schema>();
    private static final Map<Type, Converter> WRITABLE_CONVERTERS;

    public SequenceFileReader(File file) throws IOException {
        this(file.toURI(), new Configuration());
    }

    public SequenceFileReader(URI uri, Configuration c) throws IOException {
        this(new SequenceFile.Reader(FileSystem.get((URI)uri, (Configuration)c), new Path(uri.toString()), c), c);
    }

    public SequenceFileReader(SequenceFile.Reader reader, Configuration conf) {
        this.reader = reader;
        this.schema = Pair.getPairSchema(WritableData.get().getSchema(reader.getKeyClass()), WritableData.get().getSchema(reader.getValueClass()));
        this.key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
        this.spareKey = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
        this.value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
        if (WRITABLE_CONVERTERS.containsKey(reader.getKeyClass())) {
            this.keyConverter = WRITABLE_CONVERTERS.get(reader.getKeyClass());
        }
        if (WRITABLE_CONVERTERS.containsKey(reader.getValueClass())) {
            this.valConverter = WRITABLE_CONVERTERS.get(reader.getValueClass());
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterator<Pair<K, V>> iterator() {
        return this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    private void prepare() throws IOException {
        if (this.ready) {
            return;
        }
        this.done = !this.reader.next(this.key);
        this.ready = true;
    }

    public boolean hasNext() {
        try {
            this.prepare();
            return !this.done;
        }
        catch (IOException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    public Pair<K, V> next() {
        try {
            return this.next(null);
        }
        catch (IOException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    public Pair<K, V> next(Pair<K, V> reuse) throws IOException {
        this.prepare();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<K, V> result = reuse;
        if (result == null) {
            result = new Pair(this.schema);
        }
        result.key(this.keyConverter.convert(this.key));
        this.reader.getCurrentValue(this.value);
        result.value(this.valConverter.convert(this.value));
        Writable k = this.key;
        this.key = this.spareKey;
        this.spareKey = k;
        this.ready = false;
        return result;
    }

    public void sync(long position) throws IOException {
        if (position > this.reader.getPosition()) {
            this.reader.sync(position);
        }
        this.ready = false;
    }

    public boolean pastSync(long position) throws IOException {
        return this.reader.getPosition() >= position && this.reader.syncSeen();
    }

    public long tell() throws IOException {
        return this.reader.getPosition();
    }

    static {
        WRITABLE_SCHEMAS.put((Type)((Object)NullWritable.class), Schema.create((Schema.Type)Schema.Type.NULL));
        WRITABLE_SCHEMAS.put((Type)((Object)BooleanWritable.class), Schema.create((Schema.Type)Schema.Type.BOOLEAN));
        WRITABLE_SCHEMAS.put((Type)((Object)IntWritable.class), Schema.create((Schema.Type)Schema.Type.INT));
        WRITABLE_SCHEMAS.put((Type)((Object)LongWritable.class), Schema.create((Schema.Type)Schema.Type.LONG));
        WRITABLE_SCHEMAS.put((Type)((Object)FloatWritable.class), Schema.create((Schema.Type)Schema.Type.FLOAT));
        WRITABLE_SCHEMAS.put((Type)((Object)DoubleWritable.class), Schema.create((Schema.Type)Schema.Type.DOUBLE));
        WRITABLE_SCHEMAS.put((Type)((Object)BytesWritable.class), Schema.create((Schema.Type)Schema.Type.BYTES));
        WRITABLE_SCHEMAS.put((Type)((Object)Text.class), Schema.create((Schema.Type)Schema.Type.STRING));
        WRITABLE_CONVERTERS = new HashMap<Type, Converter>();
        WRITABLE_CONVERTERS.put((Type)((Object)NullWritable.class), new Converter<Void>(){

            @Override
            public Void convert(Writable o) {
                return null;
            }
        });
        WRITABLE_CONVERTERS.put((Type)((Object)BooleanWritable.class), new Converter<Boolean>(){

            @Override
            public Boolean convert(Writable o) {
                return ((BooleanWritable)o).get();
            }
        });
        WRITABLE_CONVERTERS.put((Type)((Object)IntWritable.class), new Converter<Integer>(){

            @Override
            public Integer convert(Writable o) {
                return ((IntWritable)o).get();
            }
        });
        WRITABLE_CONVERTERS.put((Type)((Object)LongWritable.class), new Converter<Long>(){

            @Override
            public Long convert(Writable o) {
                return ((LongWritable)o).get();
            }
        });
        WRITABLE_CONVERTERS.put((Type)((Object)FloatWritable.class), new Converter<Float>(){

            @Override
            public Float convert(Writable o) {
                return Float.valueOf(((FloatWritable)o).get());
            }
        });
        WRITABLE_CONVERTERS.put((Type)((Object)DoubleWritable.class), new Converter<Double>(){

            @Override
            public Double convert(Writable o) {
                return ((DoubleWritable)o).get();
            }
        });
        WRITABLE_CONVERTERS.put((Type)((Object)BytesWritable.class), new Converter<ByteBuffer>(){

            @Override
            public ByteBuffer convert(Writable o) {
                BytesWritable b = (BytesWritable)o;
                return ByteBuffer.wrap(b.getBytes(), 0, b.getLength());
            }
        });
        WRITABLE_CONVERTERS.put((Type)((Object)Text.class), new Converter<String>(){

            @Override
            public String convert(Writable o) {
                return o.toString();
            }
        });
    }

    private static interface Converter<T> {
        public T convert(Writable var1);
    }

    private static class WritableData
    extends ReflectData {
        private static final WritableData INSTANCE = new WritableData();

        protected WritableData() {
        }

        public static WritableData get() {
            return INSTANCE;
        }

        public Schema getSchema(Type type) {
            if (WRITABLE_SCHEMAS.containsKey(type)) {
                return (Schema)WRITABLE_SCHEMAS.get(type);
            }
            return super.getSchema(type);
        }
    }
}

