/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.cost.FederatedCost;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.lops.CSVReBlock;
import org.apache.sysds.lops.Checkpoint;
import org.apache.sysds.lops.Compression;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.DeCompression;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.lops.ReBlock;
import org.apache.sysds.lops.UnaryCP;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.runtime.compress.SingletonLookupHashMap;
import org.apache.sysds.runtime.compress.workload.AWTreeNode;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class Hop
implements ParseInfo {
    private static final Log LOG = LogFactory.getLog((String)Hop.class.getName());
    public static final long CPThreshold = 2000L;
    private static IDSequence _seqHopID = new IDSequence();
    protected final long _ID;
    protected String _name;
    protected Types.DataType _dataType;
    protected Types.ValueType _valueType;
    protected boolean _visited = false;
    protected DataCharacteristics _dc = new MatrixCharacteristics();
    protected PrivacyConstraint _privacyConstraint = null;
    protected MatrixObject.UpdateType _updateType = MatrixObject.UpdateType.COPY;
    protected ArrayList<Hop> _parent = new ArrayList();
    protected ArrayList<Hop> _input = new ArrayList();
    protected Types.ExecType _etype = null;
    protected Types.ExecType _etypeForced = null;
    protected FEDInstruction.FederatedOutput _federatedOutput = FEDInstruction.FederatedOutput.NONE;
    protected FederatedCost _federatedCost = new FederatedCost();
    protected double _outputMemEstimate = -1.0;
    protected double _memEstimate = -1.0;
    protected double _processingMemEstimate = 0.0;
    protected double _spBroadcastMemEstimate = 0.0;
    protected boolean _requiresRecompile = false;
    protected boolean _requiresReblock = false;
    protected boolean _requiresCompression = false;
    protected boolean _compressedOutput = false;
    protected long _compressedSize = 0L;
    protected AWTreeNode _compressedWorkloadTree = null;
    protected boolean _requiresDeCompression = false;
    protected boolean _requiresCheckpoint = false;
    protected boolean _outputEmptyBlocks = true;
    protected boolean _requiresLineageCaching = true;
    private Lop _lops = null;
    public int _beginLine;
    public int _beginColumn;
    public int _endLine;
    public int _endColumn;
    public String _filename;
    public String _text;

    protected Hop() {
        this._ID = Hop.getNextHopID();
    }

    public Hop(String l, Types.DataType dt, Types.ValueType vt) {
        this();
        this.setName(l);
        this.setDataType(dt);
        this.setValueType(vt);
    }

    private static long getNextHopID() {
        return _seqHopID.getNextID();
    }

    public long getHopID() {
        return this._ID;
    }

    public abstract void checkArity();

    public Types.ExecType getExecType() {
        return this._etype;
    }

    public void setExecType(Types.ExecType execType) {
        this._etype = execType;
    }

    public void setFederatedOutput(FEDInstruction.FederatedOutput federatedOutput) {
        this._federatedOutput = federatedOutput;
    }

    public void resetExecType() {
        this._etype = null;
    }

    public Types.ExecType getForcedExecType() {
        return this._etypeForced;
    }

    public void setForcedExecType(Types.ExecType etype) {
        this._etypeForced = etype;
    }

    public abstract boolean allowsAllExecTypes();

    public boolean isTransposeSafe() {
        return false;
    }

    public void checkAndSetForcedPlatform() {
        if (DMLScript.USE_ACCELERATOR && DMLScript.FORCE_ACCELERATOR && this.isGPUEnabled()) {
            this._etypeForced = Types.ExecType.GPU;
        } else if (DMLScript.getGlobalExecMode() == Types.ExecMode.SINGLE_NODE) {
            if (OptimizerUtils.isMemoryBasedOptLevel() && DMLScript.USE_ACCELERATOR && this.isGPUEnabled()) {
                this._etypeForced = this.findExecTypeByMemEstimate();
                if (this._etypeForced != Types.ExecType.CP && this._etypeForced != Types.ExecType.GPU) {
                    this._etypeForced = Types.ExecType.CP;
                }
            } else {
                this._etypeForced = Types.ExecType.CP;
            }
        } else if (DMLScript.getGlobalExecMode() == Types.ExecMode.SPARK) {
            this._etypeForced = Types.ExecType.SPARK;
        }
    }

    public void checkAndSetInvalidCPDimsAndSize() {
        if (this._etype == Types.ExecType.CP || this._etype == Types.ExecType.GPU) {
            boolean invalid;
            boolean bl = invalid = !this.hasValidCPDimsAndSize();
            if (invalid && DMLScript.getGlobalExecMode() == Types.ExecMode.HYBRID) {
                this._etype = Types.ExecType.SPARK;
            }
        }
    }

    public boolean hasValidCPDimsAndSize() {
        boolean invalid = !OptimizerUtils.isValidCPDimensions(this._dc.getRows(), this._dc.getCols());
        for (Hop in : this.getInput()) {
            invalid |= !OptimizerUtils.isValidCPDimensions(in._dc.getRows(), in._dc.getCols());
        }
        return !invalid;
    }

    public boolean hasMatrixInputWithDifferentBlocksizes() {
        for (Hop c : this.getInput()) {
            if (c.getDataType() != Types.DataType.MATRIX || this.getBlocksize() == c.getBlocksize()) continue;
            return true;
        }
        return false;
    }

    public void setRequiresReblock(boolean flag) {
        this._requiresReblock = flag;
    }

    public boolean requiresReblock() {
        return this._requiresReblock;
    }

    public void setRequiresCheckpoint(boolean flag) {
        this._requiresCheckpoint = flag;
    }

    public boolean requiresCheckpoint() {
        return this._requiresCheckpoint;
    }

    public void setRequiresCompression() {
        this._requiresCompression = true;
    }

    public void setRequiresCompression(AWTreeNode node) {
        this._requiresCompression = true;
        this._compressedWorkloadTree = node;
    }

    public void setRequiresDeCompression() {
        this._requiresDeCompression = true;
    }

    public boolean isRequiredDecompression() {
        return this._requiresDeCompression;
    }

    public boolean requiresCompression() {
        return this._requiresCompression;
    }

    public void setCompressedOutput(boolean value) {
        this._compressedOutput = value;
    }

    public void setCompressedSize(long size) {
        this._compressedSize = size;
    }

    public long getCompressedSize() {
        return this._compressedSize;
    }

    public boolean isCompressedOutput() {
        return this._compressedOutput;
    }

    public boolean hasCompressedInput() {
        for (Hop h : this.getInput()) {
            if (!h.isCompressedOutput()) continue;
            return true;
        }
        return false;
    }

    public long compressedSize() {
        return this._compressedSize;
    }

    public void setRequiresLineageCaching(boolean flag) {
        this._requiresLineageCaching = flag;
    }

    public boolean requiresLineageCaching() {
        return this._requiresLineageCaching;
    }

    public void constructAndSetLopsDataFlowProperties() {
        if (this.isFederated()) {
            this.getLops().setFederatedOutput(this._federatedOutput);
        }
        this.constructAndSetReblockLopIfRequired();
        this.constructAndSetCompressionLopIfRequired();
        this.constructAndSetCheckpointLopIfRequired();
    }

    private void constructAndSetReblockLopIfRequired() {
        Types.ExecType et = Types.ExecType.CP;
        if (DMLScript.getGlobalExecMode() != Types.ExecMode.SINGLE_NODE && this.getDataType() != Types.DataType.SCALAR) {
            et = Types.ExecType.SPARK;
        }
        if (this._requiresReblock && et != Types.ExecType.CP) {
            Lop input = this.getLops();
            Lop reblock = null;
            try {
                reblock = this instanceof DataOp && ((DataOp)this).getOp() == Types.OpOpData.PERSISTENTREAD && ((DataOp)this).getFileFormat() == Types.FileFormat.CSV ? new CSVReBlock(input, this.getBlocksize(), this.getDataType(), this.getValueType(), et) : new ReBlock(input, this.getBlocksize(), this.getDataType(), this.getValueType(), this._outputEmptyBlocks, et);
            }
            catch (LopsException ex) {
                throw new HopsException(ex);
            }
            this.setOutputDimensions(reblock);
            this.setLineNumbers(reblock);
            this.setPrivacy(reblock);
            this.setLops(reblock);
        }
    }

    private void constructAndSetCheckpointLopIfRequired() {
        Types.ExecType et = Types.ExecType.CP;
        if (OptimizerUtils.isSparkExecutionMode() && this.getDataType() != Types.DataType.SCALAR) {
            Types.ExecType execType = et = Recompiler.checkCPCheckpoint(this.getDataCharacteristics()) || this._etypeForced == Types.ExecType.CP ? Types.ExecType.CP : Types.ExecType.SPARK;
        }
        if (this._requiresCheckpoint && et != Types.ExecType.CP) {
            try {
                boolean serializedStorage = false;
                if (this.getDataType() == Types.DataType.MATRIX && this.dimsKnown(true)) {
                    double matrixPSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(this._dc);
                    double dataCache = SparkExecutionContext.getDataMemoryBudget(true, true);
                    serializedStorage = MatrixBlock.evalSparseFormatInMemory(this._dc) && matrixPSize > dataCache && OptimizerUtils.getSparsity(this._dc) < 4.0E-5;
                } else if (!this.dimsKnown(true)) {
                    this.setRequiresRecompile();
                }
                Lop input = this.getLops();
                Checkpoint chkpoint = new Checkpoint(input, this.getDataType(), this.getValueType(), serializedStorage ? Checkpoint.getSerializeStorageLevelString() : Checkpoint.getDefaultStorageLevelString());
                this.setOutputDimensions(chkpoint);
                this.setLineNumbers(chkpoint);
                this.setLops(chkpoint);
            }
            catch (LopsException ex) {
                throw new HopsException(ex);
            }
        }
    }

    private void constructAndSetCompressionLopIfRequired() {
        if ((this.requiresCompression() && !this.hasCompressedInput()) ^ this._requiresDeCompression) {
            Lop compressionInstruction;
            block7: {
                Types.ExecType et = this.getExecutionModeForCompression();
                compressionInstruction = null;
                try {
                    if (this.requiresCompression()) {
                        if (this._compressedWorkloadTree != null) {
                            SingletonLookupHashMap m = SingletonLookupHashMap.getMap();
                            int singletonID = m.put(this._compressedWorkloadTree);
                            compressionInstruction = new Compression(this.getLops(), this.getDataType(), this.getValueType(), et, singletonID);
                        } else {
                            compressionInstruction = new Compression(this.getLops(), this.getDataType(), this.getValueType(), et, 0);
                        }
                        break block7;
                    }
                    if (this._requiresDeCompression && et != Types.ExecType.SPARK) {
                        compressionInstruction = new DeCompression(this.getLops(), this.getDataType(), this.getValueType(), et);
                        break block7;
                    }
                    return;
                }
                catch (LopsException ex) {
                    throw new HopsException(ex);
                }
            }
            this.setOutputDimensions(compressionInstruction);
            this.setLineNumbers(compressionInstruction);
            this.setLops(compressionInstruction);
        }
    }

    private Types.ExecType getExecutionModeForCompression() {
        Types.ExecType et = Types.ExecType.CP;
        if (OptimizerUtils.isSparkExecutionMode() && this.getDataType() != Types.DataType.SCALAR) {
            et = OptimizerUtils.isHybridExecutionMode() && 2.0 * this._outputMemEstimate < OptimizerUtils.getLocalMemBudget() || this._etypeForced == Types.ExecType.CP ? Types.ExecType.CP : Types.ExecType.SPARK;
        }
        return et;
    }

    public static Lop createOffsetLop(Hop hop, boolean repCols) {
        Lop offset = null;
        offset = ConfigurationManager.isDynamicRecompilation() && hop.dimsKnown() ? Data.createLiteralLop(Types.ValueType.INT64, String.valueOf(repCols ? hop.getDim2() : hop.getDim1())) : new UnaryCP(hop.constructLops(), repCols ? Types.OpOp1.NCOL : Types.OpOp1.NROW, Types.DataType.SCALAR, Types.ValueType.INT64);
        offset.getOutputParameters().setDimensions(0L, 0L, 0L, -1L);
        offset.setAllPositions(hop.getFilename(), hop.getBeginLine(), hop.getBeginColumn(), hop.getEndLine(), hop.getEndColumn());
        return offset;
    }

    public void setOutputEmptyBlocks(boolean flag) {
        this._outputEmptyBlocks = flag;
    }

    public boolean isOutputEmptyBlocks() {
        return this._outputEmptyBlocks;
    }

    protected double getInputOutputSize() {
        return this._outputMemEstimate + this._processingMemEstimate + this.getInputSize();
    }

    public double getInputOutputSize(Collection<String> exclVars) {
        return this._outputMemEstimate + this._processingMemEstimate + this.getInputSize(exclVars);
    }

    protected double getOutputSize() {
        return this._outputMemEstimate;
    }

    protected double getInputSize() {
        return this.getInputSize(null);
    }

    protected double getInputSize(Collection<String> exclVars, double injectedDefault) {
        double sum = 0.0;
        int len = this._input.size();
        for (int i = 0; i < len; ++i) {
            Hop hi = this._input.get(i);
            if (exclVars != null && exclVars.contains(hi.getName())) continue;
            double hmout = hi.getOutputMemEstimate(injectedDefault);
            if (hmout < 0.0) {
                hmout = injectedDefault * (double)(Math.max(hi.getDim1(), 1L) * Math.max(hi.getDim2(), 1L));
            }
            if (hmout > 1048576.0) {
                boolean flag = false;
                for (int j = 0; j < i; ++j) {
                    flag |= hi == this._input.get(j);
                }
                hmout = flag ? 0.0 : hmout;
            }
            sum += hmout;
        }
        return sum;
    }

    protected double getInputSize(Collection<String> exclVars) {
        return this.getInputSize(exclVars, -1.0);
    }

    protected double getInputSize(int pos) {
        double ret = 0.0;
        if (this._input.size() > pos) {
            ret = this._input.get((int)pos)._outputMemEstimate;
        }
        return ret;
    }

    protected double getIntermediateSize() {
        return this._processingMemEstimate;
    }

    public double getMemEstimate() {
        if (OptimizerUtils.isMemoryBasedOptLevel()) {
            if (!this.isMemEstimated()) {
                this.computeMemEstimate(new MemoTable());
            }
            return this._memEstimate;
        }
        return -1.0;
    }

    public void setMemEstimate(double mem) {
        this._memEstimate = mem;
    }

    public void clearMemEstimate() {
        this._memEstimate = -1.0;
    }

    public boolean isMemEstimated() {
        return this._memEstimate != -1.0;
    }

    public double getInputMemEstimate() {
        return this.getInputSize();
    }

    public double getInputMemEstimate(double injectedDefault) {
        return this.getInputSize(null, injectedDefault);
    }

    public double getOutputMemEstimate() {
        return this.getOutputSize();
    }

    public double getOutputMemEstimate(double injectedDefault) {
        return Math.max(this.getOutputMemEstimate(), injectedDefault * (double)(Math.max(this.getDim1(), 1L) * Math.max(this.getDim2(), 1L)));
    }

    public double getIntermediateMemEstimate() {
        return this.getIntermediateSize();
    }

    public double getSpBroadcastSize() {
        return this._spBroadcastMemEstimate;
    }

    public void computeMemEstimate(MemoTable memo) {
        long lnnz;
        DataCharacteristics wdc = null;
        switch (this.getDataType()) {
            case SCALAR: {
                if (this.getValueType() == Types.ValueType.FP64) {
                    this._outputMemEstimate = 8.0;
                    break;
                }
                this._outputMemEstimate = this.computeOutputMemEstimate(this.getDim1(), this.getDim2(), this.getNnz());
                break;
            }
            case FRAME: 
            case MATRIX: 
            case TENSOR: 
            case LIST: {
                if (this.isCompressedOutput() && this._compressedSize >= 0L) {
                    this._outputMemEstimate = this._compressedSize;
                    break;
                }
                if (this.dimsKnown(true)) {
                    this._outputMemEstimate = this.computeOutputMemEstimate(this.getDim1(), this.getDim2(), this.getNnz());
                    break;
                }
                if (memo.hasInputStatistics(this)) {
                    wdc = this.inferOutputCharacteristics(memo);
                    if (wdc != null && wdc.dimsKnown()) {
                        lnnz = wdc.nnzKnown() ? wdc.getNonZeros() : wdc.getLength();
                        this._outputMemEstimate = this.computeOutputMemEstimate(wdc.getRows(), wdc.getCols(), lnnz);
                        memo.memoizeStatistics(this.getHopID(), wdc);
                        break;
                    }
                    if (this.dimsKnown()) {
                        lnnz = this.getLength();
                        this._outputMemEstimate = this.computeOutputMemEstimate(this.getDim1(), this.getDim2(), lnnz);
                        break;
                    }
                    this._outputMemEstimate = OptimizerUtils.DEFAULT_SIZE;
                    break;
                }
                if (this.dimsKnown()) {
                    lnnz = this.getLength();
                    this._outputMemEstimate = this.computeOutputMemEstimate(this.getDim1(), this.getDim2(), lnnz);
                    break;
                }
                this._outputMemEstimate = OptimizerUtils.DEFAULT_SIZE;
                break;
            }
            case UNKNOWN: {
                this._outputMemEstimate = OptimizerUtils.DEFAULT_SIZE;
            }
        }
        if (this.dimsKnown(true)) {
            this._processingMemEstimate = this.computeIntermediateMemEstimate(this.getDim1(), this.getDim2(), this.getNnz());
        } else if (wdc != null) {
            lnnz = wdc.nnzKnown() ? wdc.getNonZeros() : wdc.getLength();
            this._processingMemEstimate = this.computeIntermediateMemEstimate(wdc.getRows(), wdc.getCols(), lnnz);
        } else if (this.dimsKnown()) {
            lnnz = this.getLength();
            this._processingMemEstimate = this.computeIntermediateMemEstimate(this.getDim1(), this.getDim2(), lnnz);
        }
        this._memEstimate = this.getInputOutputSize();
    }

    protected abstract DataCharacteristics inferOutputCharacteristics(MemoTable var1);

    public void refreshMemEstimates(MemoTable memo) {
        if (this.isVisited()) {
            return;
        }
        for (Hop h : this.getInput()) {
            h.refreshMemEstimates(memo);
        }
        this.computeMemEstimate(memo);
        this.setVisited();
    }

    protected Types.ExecType findExecTypeByMemEstimate() {
        Types.ExecType et = null;
        char c = ' ';
        double memEst = this.getMemEstimate();
        if (memEst < OptimizerUtils.getLocalMemBudget()) {
            et = DMLScript.USE_ACCELERATOR && this.isGPUEnabled() && memEst < (double)GPUContextPool.initialGPUMemBudget() ? Types.ExecType.GPU : Types.ExecType.CP;
        } else {
            if (DMLScript.getGlobalExecMode() == Types.ExecMode.HYBRID) {
                et = Types.ExecType.SPARK;
            }
            c = '*';
        }
        if (LOG.isDebugEnabled()) {
            String s = String.format("  %c %-5s %-8s (%s,%s)  %s", new Object[]{Character.valueOf(c), this.getHopID(), this.getOpString(), OptimizerUtils.toMB(this._outputMemEstimate), OptimizerUtils.toMB(this._memEstimate), et});
            LOG.debug((Object)s);
        }
        return et;
    }

    protected void updateETFed() {
        if (this.someInputFederated() || this.isFederatedDataOp()) {
            this._etype = Types.ExecType.FED;
        }
    }

    public boolean isFederated() {
        return this.getExecType() == Types.ExecType.FED;
    }

    public boolean someInputFederated() {
        return this.getInput().stream().anyMatch(Hop::hasFederatedOutput);
    }

    public boolean isFederatedDataOp() {
        return false;
    }

    public ArrayList<Hop> getParent() {
        return this._parent;
    }

    public ArrayList<Hop> getInput() {
        return this._input;
    }

    public Hop getInput(int ix) {
        return this._input.get(ix);
    }

    public void addInput(Hop h) {
        this._input.add(h);
        h._parent.add(this);
    }

    public void addAllInputs(ArrayList<Hop> list) {
        for (Hop h : list) {
            this.addInput(h);
        }
    }

    public int getBlocksize() {
        return this._dc.getBlocksize();
    }

    public void setBlocksize(int blen) {
        this._dc.setBlocksize(blen);
    }

    public void setNnz(long nnz) {
        this._dc.setNonZeros(nnz);
    }

    public long getNnz() {
        return this._dc.getNonZeros();
    }

    public void setPrivacy(PrivacyConstraint privacy) {
        this._privacyConstraint = privacy;
    }

    public PrivacyConstraint getPrivacy() {
        return this._privacyConstraint;
    }

    public boolean hasFederatedOutput() {
        return this._federatedOutput == FEDInstruction.FederatedOutput.FOUT;
    }

    public boolean hasLocalOutput() {
        return this._federatedOutput == FEDInstruction.FederatedOutput.LOUT;
    }

    public boolean federatedCostInitialized() {
        return this._federatedCost.getTotal() > 0.0;
    }

    public FederatedCost getFederatedCost() {
        return this._federatedCost;
    }

    public void setFederatedCost(FederatedCost cost) {
        this._federatedCost = cost;
    }

    public void setUpdateType(MatrixObject.UpdateType update) {
        this._updateType = update;
    }

    public MatrixObject.UpdateType getUpdateType() {
        return this._updateType;
    }

    public abstract Lop constructLops();

    protected final Types.ExecType optFindExecType() {
        return this.optFindExecType(OptimizerUtils.ALLOW_TRANSITIVE_SPARK_EXEC_TYPE);
    }

    protected abstract Types.ExecType optFindExecType(boolean var1);

    public abstract String getOpString();

    public String toString() {
        return super.getClass().getSimpleName() + "  " + this.getOpString();
    }

    public abstract boolean isGPUEnabled();

    protected abstract double computeOutputMemEstimate(long var1, long var3, long var5);

    protected abstract double computeIntermediateMemEstimate(long var1, long var3, long var5);

    protected boolean isVector() {
        return this.dimsKnown() && (this._dc.getRows() == 1L || this._dc.getCols() == 1L);
    }

    protected boolean areDimsBelowThreshold() {
        return this.dimsKnown() && this._dc.getRows() <= 2000L && this._dc.getCols() <= 2000L;
    }

    public boolean dimsKnown() {
        return this._dataType == Types.DataType.SCALAR || (this._dataType == Types.DataType.MATRIX || this._dataType == Types.DataType.FRAME || this._dataType == Types.DataType.LIST) && this._dc.rowsKnown() && this._dc.colsKnown();
    }

    public boolean dimsKnown(boolean includeNnz) {
        return this.rowsKnown() && this.colsKnown() && (this._dataType.isScalar() || !includeNnz || this._dc.nnzKnown());
    }

    public boolean dimsKnownAny() {
        return this.rowsKnown() || this.colsKnown();
    }

    public boolean rowsKnown() {
        return this._dataType.isScalar() || this._dc.rowsKnown();
    }

    public boolean colsKnown() {
        return this._dataType.isScalar() || this._dc.colsKnown();
    }

    public static void resetVisitStatus(ArrayList<Hop> hops) {
        if (hops != null) {
            for (Hop hopRoot : hops) {
                hopRoot.resetVisitStatus();
            }
        }
    }

    public static void resetVisitStatus(ArrayList<Hop> hops, boolean force) {
        if (!force) {
            Hop.resetVisitStatus(hops);
        } else {
            HashSet<Long> memo = new HashSet<Long>();
            if (hops != null) {
                for (Hop hopRoot : hops) {
                    hopRoot.resetVisitStatusForced(memo);
                }
            }
        }
    }

    public Hop resetVisitStatus() {
        if (!this.isVisited()) {
            return this;
        }
        for (Hop h : this.getInput()) {
            h.resetVisitStatus();
        }
        this.setVisited(false);
        return this;
    }

    public void resetVisitStatusForced(HashSet<Long> memo) {
        if (memo.contains(this.getHopID())) {
            return;
        }
        for (Hop h : this.getInput()) {
            h.resetVisitStatusForced(memo);
        }
        this.setVisited(false);
        memo.add(this.getHopID());
    }

    public static void resetRecompilationFlag(ArrayList<Hop> hops, Types.ExecType et, Recompiler.ResetType reset) {
        Hop.resetVisitStatus(hops);
        for (Hop hopRoot : hops) {
            hopRoot.resetRecompilationFlag(et, reset);
        }
    }

    public static void resetRecompilationFlag(Hop hops, Types.ExecType et, Recompiler.ResetType reset) {
        hops.resetVisitStatus();
        hops.resetRecompilationFlag(et, reset);
    }

    private void resetRecompilationFlag(Types.ExecType et, Recompiler.ResetType reset) {
        if (this.isVisited()) {
            return;
        }
        for (Hop h : this.getInput()) {
            h.resetRecompilationFlag(et, reset);
        }
        if (!(et != null && this.getExecType() != et && this.getExecType() != null || reset != Recompiler.ResetType.RESET && (reset != Recompiler.ResetType.RESET_KNOWN_DIMS || !this.dimsKnown()) || this._requiresCheckpoint && this.getLops() instanceof Checkpoint && !this.dimsKnown(true))) {
            this._requiresRecompile = false;
        }
        this.setVisited();
    }

    public long getDim1() {
        return this._dc.getRows();
    }

    public void setDim1(long dim1) {
        this._dc.setRows(dim1);
    }

    public long getDim2() {
        return this._dc.getCols();
    }

    public void setDim2(long dim2) {
        this._dc.setCols(dim2);
    }

    public long getDim(int i) {
        return this._dc.getDim(i);
    }

    public void setDim(int i, long dim) {
        this._dc.setDim(i, dim);
    }

    public long getLength() {
        return this._dc.getLength();
    }

    public double getSparsity() {
        return OptimizerUtils.getSparsity(this._dc);
    }

    public DataCharacteristics getDataCharacteristics() {
        return this._dc;
    }

    protected void setOutputDimensions(Lop lop) {
        lop.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), (long)this.getBlocksize(), this.getNnz(), this.getUpdateType());
    }

    protected void setOutputDimensionsIncludeCompressedSize(Lop lop) {
        lop.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getBlocksize(), this.getNnz(), this.getUpdateType(), this.getCompressedSize());
    }

    public Lop getLops() {
        return this._lops;
    }

    public void setLops(Lop lops) {
        this._lops = lops;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public Types.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(Types.DataType dt) {
        this._dataType = dt;
    }

    public boolean isScalar() {
        return this._dataType.isScalar();
    }

    public boolean isMatrix() {
        return this._dataType.isMatrix();
    }

    public void setVisited() {
        this.setVisited(true);
    }

    public void setVisited(boolean flag) {
        this._visited = flag;
    }

    public void setName(String _name) {
        this._name = _name;
    }

    public String getName() {
        return this._name;
    }

    public Types.ValueType getValueType() {
        return this._valueType;
    }

    public void setValueType(Types.ValueType vt) {
        this._valueType = vt;
    }

    public boolean requiresRecompile() {
        return this._requiresRecompile;
    }

    public void setRequiresRecompile() {
        this._requiresRecompile = true;
    }

    protected void setRequiresRecompileIfNecessary() {
        boolean caseCodegen;
        boolean caseRemote = !this.dimsKnown(true) && this._etype == Types.ExecType.SPARK;
        boolean caseLocal = !this.dimsKnown() && this._etypeForced == Types.ExecType.CP;
        boolean bl = caseCodegen = !this.dimsKnown() && ConfigurationManager.isCodegenEnabled();
        if (ConfigurationManager.isDynamicRecompilation() && (caseRemote || caseLocal || caseCodegen)) {
            this.setRequiresRecompile();
        }
    }

    public abstract void refreshSizeInformation();

    protected void refreshRowsParameterInformation(Hop input) {
        long size = Hop.computeSizeInformation(input);
        this.setDim1(size);
    }

    protected void refreshColsParameterInformation(Hop input) {
        long size = Hop.computeSizeInformation(input);
        this.setDim2(size);
    }

    public static long computeSizeInformation(Hop input) {
        long ret = -1L;
        try {
            long tmp = OptimizerUtils.rEvalSimpleLongExpression(input, new HashMap<Long, Long>());
            if (tmp != Long.MAX_VALUE) {
                ret = tmp;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to compute size information.", (Throwable)ex);
            ret = -1L;
        }
        return ret;
    }

    public void refreshRowsParameterInformation(Hop input, LocalVariableMap vars) {
        this.setDim1(this.computeSizeInformation(input, vars));
    }

    public void refreshRowsParameterInformation(Hop input, LocalVariableMap vars, HashMap<Long, Long> memo) {
        this.setDim1(this.computeSizeInformation(input, vars, memo));
    }

    public void refreshColsParameterInformation(Hop input, LocalVariableMap vars) {
        this.setDim2(this.computeSizeInformation(input, vars));
    }

    public void refreshColsParameterInformation(Hop input, LocalVariableMap vars, HashMap<Long, Long> memo) {
        this.setDim2(this.computeSizeInformation(input, vars, memo));
    }

    public long computeSizeInformation(Hop input, LocalVariableMap vars) {
        return this.computeSizeInformation(input, vars, new HashMap<Long, Long>());
    }

    public long computeSizeInformation(Hop input, LocalVariableMap vars, HashMap<Long, Long> memo) {
        long ret = -1L;
        try {
            long tmp = OptimizerUtils.rEvalSimpleLongExpression(input, memo, vars);
            if (tmp != Long.MAX_VALUE) {
                ret = tmp;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to compute size information.", (Throwable)ex);
            ret = -1L;
        }
        return ret;
    }

    public double computeBoundsInformation(Hop input) {
        double ret = Double.MAX_VALUE;
        try {
            ret = OptimizerUtils.rEvalSimpleDoubleExpression(input, new HashMap<Long, Double>());
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to compute bounds information.", (Throwable)ex);
            ret = Double.MAX_VALUE;
        }
        return ret;
    }

    public static double computeBoundsInformation(Hop input, LocalVariableMap vars) {
        return Hop.computeBoundsInformation(input, vars, new HashMap<Long, Double>());
    }

    public static double computeBoundsInformation(Hop input, LocalVariableMap vars, HashMap<Long, Double> memo) {
        double ret = Double.MAX_VALUE;
        try {
            ret = OptimizerUtils.rEvalSimpleDoubleExpression(input, memo, vars);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to compute bounds information.", (Throwable)ex);
            ret = Double.MAX_VALUE;
        }
        return ret;
    }

    protected long computeDimParameterInformation(Hop input, MemoTable memo) {
        long dim;
        long ret = -1L;
        if (input instanceof UnaryOp) {
            DataCharacteristics mc;
            if (((UnaryOp)input).getOp() == Types.OpOp1.NROW) {
                DataCharacteristics mc2 = memo.getAllInputStats(input.getInput().get(0));
                if (mc2.rowsKnown()) {
                    ret = mc2.getRows();
                }
            } else if (((UnaryOp)input).getOp() == Types.OpOp1.NCOL && (mc = memo.getAllInputStats(input.getInput().get(0))).colsKnown()) {
                ret = mc.getCols();
            }
        } else if (input instanceof LiteralOp) {
            ret = UtilFunctions.parseToLong(input.getName());
        } else if (input instanceof BinaryOp && (dim = this.rEvalSimpleBinaryLongExpression(input, new HashMap<Long, Long>(), memo)) != Long.MAX_VALUE) {
            ret = dim;
        }
        return ret;
    }

    protected long rEvalSimpleBinaryLongExpression(Hop root, HashMap<Long, Long> valMemo, MemoTable memo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        long ret = Long.MAX_VALUE;
        if (root instanceof LiteralOp) {
            long dim = UtilFunctions.parseToLong(root.getName());
            if (dim != -1L) {
                ret = dim;
            }
        } else if (root instanceof UnaryOp) {
            UnaryOp uroot = (UnaryOp)root;
            long dim = -1L;
            if (uroot.getOp() == Types.OpOp1.NROW) {
                DataCharacteristics mc = memo.getAllInputStats(uroot.getInput().get(0));
                dim = mc.getRows();
            } else if (uroot.getOp() == Types.OpOp1.NCOL) {
                DataCharacteristics mc = memo.getAllInputStats(uroot.getInput().get(0));
                dim = mc.getCols();
            }
            if (dim != -1L) {
                ret = dim;
            }
        } else if (root instanceof BinaryOp && OptimizerUtils.ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION) {
            BinaryOp broot = (BinaryOp)root;
            long lret = this.rEvalSimpleBinaryLongExpression(broot.getInput().get(0), valMemo, memo);
            long rret = this.rEvalSimpleBinaryLongExpression(broot.getInput().get(1), valMemo, memo);
            if (lret != Long.MAX_VALUE && rret != Long.MAX_VALUE) {
                switch (broot.getOp()) {
                    case PLUS: {
                        ret = lret + rret;
                        break;
                    }
                    case MULT: {
                        ret = lret * rret;
                        break;
                    }
                    case MIN: {
                        ret = Math.min(lret, rret);
                        break;
                    }
                    case MAX: {
                        ret = Math.max(lret, rret);
                        break;
                    }
                    default: {
                        ret = Long.MAX_VALUE;
                        break;
                    }
                }
            } else if (broot.getOp() == Types.OpOp2.MIN && ((double)lret != Double.MAX_VALUE || (double)rret != Double.MAX_VALUE)) {
                ret = Math.min(lret, rret);
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected void clone(Hop that, boolean withRefs) throws CloneNotSupportedException {
        if (withRefs) {
            throw new CloneNotSupportedException("Hops deep copy w/ lops/inputs/parents not supported.");
        }
        this._name = that._name;
        this._dataType = that._dataType;
        this._valueType = that._valueType;
        this._visited = that._visited;
        this._dc.set(that._dc);
        this._updateType = that._updateType;
        this._parent = new ArrayList(this._parent.size());
        this._input = new ArrayList(this._input.size());
        this._lops = null;
        this._etype = that._etype;
        this._etypeForced = that._etypeForced;
        this._outputMemEstimate = that._outputMemEstimate;
        this._memEstimate = that._memEstimate;
        this._processingMemEstimate = that._processingMemEstimate;
        this._requiresRecompile = that._requiresRecompile;
        this._requiresReblock = that._requiresReblock;
        this._requiresCheckpoint = that._requiresCheckpoint;
        this._requiresCompression = that._requiresCompression;
        this._requiresDeCompression = that._requiresDeCompression;
        this._requiresLineageCaching = that._requiresLineageCaching;
        this._compressedWorkloadTree = that._compressedWorkloadTree;
        this._outputEmptyBlocks = that._outputEmptyBlocks;
        this._beginLine = that._beginLine;
        this._beginColumn = that._beginColumn;
        this._endLine = that._endLine;
        this._endColumn = that._endColumn;
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public abstract boolean compare(Hop var1);

    @Override
    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    @Override
    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    @Override
    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    @Override
    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    @Override
    public void setFilename(String passed) {
        this._filename = passed;
    }

    @Override
    public void setText(String text) {
        this._text = text;
    }

    @Override
    public int getBeginLine() {
        return this._beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this._beginColumn;
    }

    @Override
    public int getEndLine() {
        return this._endLine;
    }

    @Override
    public int getEndColumn() {
        return this._endColumn;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public String getText() {
        return this._text;
    }

    public String printErrorLocation() {
        if (this._filename != null) {
            return "ERROR: " + this._filename + " line " + this._beginLine + ", column " + this._beginColumn + " -- ";
        }
        return "ERROR: line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    protected void setLineNumbers(Lop lop) {
        lop.setAllPositions(this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
    }

    protected void setPrivacy(Lop lop) {
        lop.setPrivacyConstraint(this.getPrivacy());
    }

    public void setParseInfo(ParseInfo parseInfo) {
        this._beginLine = parseInfo.getBeginLine();
        this._beginColumn = parseInfo.getBeginColumn();
        this._endLine = parseInfo.getEndLine();
        this._endColumn = parseInfo.getEndColumn();
        this._text = parseInfo.getText();
        this._filename = parseInfo.getFilename();
    }
}

