/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.model;

import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.time.Duration;
import java.util.Optional;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.util.internal.ValidationUtils;

public final class ClientConfig {
    private final SSLFactory sslFactory;
    private final Proxy proxy;
    private final PasswordAuthentication passwordAuthentication;
    private final Duration timeout;

    public ClientConfig(SSLFactory sslFactory, Proxy proxy, PasswordAuthentication passwordAuthentication, Duration timeout) {
        this.sslFactory = ValidationUtils.requireNotNull(sslFactory, (String)ValidationUtils.GENERIC_EXCEPTION_MESSAGE.apply("SSLFactory"));
        this.proxy = proxy;
        this.passwordAuthentication = passwordAuthentication;
        this.timeout = timeout;
    }

    public SSLFactory getSslFactory() {
        return this.sslFactory;
    }

    public Optional<Proxy> getProxy() {
        return Optional.ofNullable(this.proxy);
    }

    public Optional<PasswordAuthentication> getPasswordAuthentication() {
        return Optional.ofNullable(this.passwordAuthentication);
    }

    public Optional<Duration> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }
}

