/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.AbstractTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslatorException;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class GoTranslateVisitor
extends AbstractTranslateVisitor {
    private static final String GO_PACKAGE_NAME = "gremlingo.";
    private static final List<String> STRATEGY_WITH_MAP_OPTS = Collections.unmodifiableList(Arrays.asList("OptionsStrategy", "ReferenceElementStrategy", "ComputerFinalizationStrategy", "ProfileStrategy", "ComputerVerificationStrategy", "StandardVerificationStrategy", "VertexProgramRestrictionStrategy"));
    private static final List<String> STRATEGY_WITH_STRING_SLICE = Collections.unmodifiableList(Arrays.asList("ReservedKeysVerificationStrategy", "ProductiveByStrategy"));

    public GoTranslateVisitor() {
        super("g");
    }

    public GoTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        String dtString = ctx.getChild(2).getText();
        OffsetDateTime dt = DatetimeHelper.parse(GoTranslateVisitor.removeFirstAndLastCharacters(dtString));
        String zoneInfo = dt.getOffset().getId().equals("Z") ? "UTC+00:00" : "UTC" + dt.getOffset().getId();
        this.sb.append("time.Date(").append(dt.getYear()).append(", ").append(dt.getMonthValue()).append(", ").append(dt.getDayOfMonth()).append(", ").append(dt.getHour()).append(", ").append(dt.getMinute()).append(", ").append(dt.getSecond()).append(", ").append(dt.getNano()).append(", time.FixedZone(\"").append(zoneInfo).append("\", ").append(dt.getOffset().getTotalSeconds()).append(")").append(")");
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral() != null && ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("math.Inf(-1)");
        } else {
            this.sb.append("math.Inf(1)");
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        int lastCharIndex;
        String integerLiteral = ctx.getText().toLowerCase();
        char lastChar = integerLiteral.charAt(lastCharIndex = integerLiteral.length() - 1);
        if (Character.isAlphabetic(lastChar)) {
            switch (lastChar) {
                case 'b': {
                    this.sb.append("int8(");
                    break;
                }
                case 's': {
                    this.sb.append("int16(");
                    break;
                }
                case 'i': {
                    this.sb.append("int32(");
                    break;
                }
                case 'l': {
                    this.sb.append("int64(");
                    break;
                }
                case 'n': {
                    this.sb.append("gremlingo.ParseBigInt(\"");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized integer suffix: " + integerLiteral);
                }
            }
            this.sb.append(integerLiteral, 0, lastCharIndex);
            if (lastChar == 'n') {
                this.sb.append("\"");
            }
            this.sb.append(")");
        } else {
            this.sb.append(integerLiteral);
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        block8: {
            String floatLiteral;
            block7: {
                int lastCharIndex;
                if (ctx.infLiteral() != null) {
                    return (Void)this.visit((ParseTree)ctx.infLiteral());
                }
                if (ctx.nanLiteral() != null) {
                    return (Void)this.visit((ParseTree)ctx.nanLiteral());
                }
                floatLiteral = ctx.getText().toLowerCase();
                char lastChar = floatLiteral.charAt(lastCharIndex = floatLiteral.length() - 1);
                if (!Character.isAlphabetic(lastChar)) break block7;
                switch (lastChar) {
                    case 'f': {
                        this.sb.append("float32(");
                        this.sb.append(floatLiteral, 0, lastCharIndex);
                        this.sb.append(")");
                        break block8;
                    }
                    case 'd': {
                        this.sb.append(floatLiteral, 0, lastCharIndex);
                        break block8;
                    }
                    case 'm': {
                        this.sb.append("gremlingo.ParseBigDecimal(\"");
                        this.sb.append(floatLiteral, 0, lastCharIndex);
                        this.sb.append("\")");
                        break block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized float suffix: " + floatLiteral);
                    }
                }
            }
            this.sb.append(floatLiteral);
        }
        return null;
    }

    public Void visitGenericRangeLiteral(GremlinParser.GenericRangeLiteralContext ctx) {
        throw new TranslatorException("Go does not support range literals");
    }

    public Void visitGenericSetLiteral(GremlinParser.GenericSetLiteralContext ctx) {
        this.sb.append(GO_PACKAGE_NAME);
        this.sb.append("NewSimpleSet(");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append(")");
        return null;
    }

    public Void visitGenericCollectionLiteral(GremlinParser.GenericCollectionLiteralContext ctx) {
        this.sb.append("[]interface{}{");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("}");
        return null;
    }

    public Void visitGenericMapLiteral(GremlinParser.GenericMapLiteralContext ctx) {
        this.sb.append("map[interface{}]interface{}{");
        for (int i = 0; i < ctx.mapEntry().size(); ++i) {
            GremlinParser.MapEntryContext mapEntryContext = ctx.mapEntry(i);
            this.visit((ParseTree)mapEntryContext);
            if (i >= ctx.mapEntry().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append(" }");
        return null;
    }

    public Void visitMapEntry(GremlinParser.MapEntryContext ctx) {
        this.visit((ParseTree)ctx.mapKey());
        this.sb.append(": ");
        this.visit((ParseTree)ctx.genericLiteral());
        return null;
    }

    public Void visitMapKey(GremlinParser.MapKeyContext ctx) {
        int keyIndex = ctx.LPAREN() != null && ctx.RPAREN() != null ? 1 : 0;
        this.visit(ctx.getChild(keyIndex));
        return null;
    }

    @Override
    public Void visitStringNullableLiteral(GremlinParser.StringNullableLiteralContext ctx) {
        if (ctx.getText().equals("null")) {
            this.sb.append("nil");
        } else {
            String text = GoTranslateVisitor.removeFirstAndLastCharacters(ctx.getText());
            this.handleStringLiteralText(text);
        }
        return null;
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append("math.NaN()");
        return null;
    }

    @Override
    public Void visitNullLiteral(GremlinParser.NullLiteralContext ctx) {
        this.sb.append("nil");
        return null;
    }

    @Override
    public Void visitTraversalGType(GremlinParser.TraversalGTypeContext ctx) {
        String[] split = ctx.getText().split("\\.");
        this.sb.append(GO_PACKAGE_NAME);
        this.sb.append(this.processGremlinSymbol(split[0])).append(".");
        this.sb.append(this.processGremlinSymbol(split[1].toLowerCase()));
        return null;
    }

    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.sb.append(GO_PACKAGE_NAME).append(ctx.getText()).append("()");
        } else {
            String strategyName = ctx.getChild(0).getText().equals("new") ? ctx.getChild(1).getText() : ctx.getChild(0).getText();
            this.sb.append(GO_PACKAGE_NAME).append(strategyName).append("(");
            if (!STRATEGY_WITH_MAP_OPTS.contains(strategyName)) {
                this.sb.append(GO_PACKAGE_NAME).append(strategyName).append("Config{");
            }
            List configs = ctx.children.stream().filter(c -> c instanceof GremlinParser.ConfigurationContext).collect(Collectors.toList());
            for (int ix = 0; ix < configs.size(); ++ix) {
                this.visit((ParseTree)configs.get(ix));
                if (ix >= configs.size() - 1) continue;
                this.sb.append(", ");
            }
            if (!Objects.equals(strategyName, "OptionsStrategy")) {
                this.sb.append("}");
            }
            this.sb.append(")");
        }
        return null;
    }

    public Void visitConfiguration(GremlinParser.ConfigurationContext ctx) {
        int ix;
        String parentName;
        String parent = ctx.getParent().getText();
        String string = parentName = parent.startsWith("new") ? parent.substring(3, parent.indexOf(40)) : parent.substring(0, parent.indexOf(40));
        if (STRATEGY_WITH_MAP_OPTS.contains(parentName)) {
            this.sb.append("map[string]interface{}{\"");
            this.sb.append(ctx.getChild(0).getText());
            this.sb.append("\": ");
            this.visit(ctx.getChild(2));
            this.sb.append("}");
        } else {
            this.sb.append(SymbolHelper.toGo(ctx.getChild(0).getText()));
            this.sb.append(": ");
            this.visit(ctx.getChild(2));
            if (STRATEGY_WITH_STRING_SLICE.contains(parentName) && (ix = this.sb.lastIndexOf("[]interface{}")) > 0) {
                this.sb.replace(ix, ix + "[]interface{}".length(), "[]string");
            }
        }
        if (ctx.getChild(0).getText().equals("readPartitions") && (ix = this.sb.lastIndexOf("ReadPartitions: [")) > 0) {
            int endIx = this.sb.indexOf("\"}", ix);
            this.sb.replace(endIx, endIx + 2, "\")");
            this.sb.replace(ix, ix + "ReadPartitions: []interface{}{".length(), "ReadPartitions: gremlingo.NewSimpleSet(");
        }
        return null;
    }

    public Void visitTraversalSourceSelfMethod_withoutStrategies(GremlinParser.TraversalSourceSelfMethod_withoutStrategiesContext ctx) {
        this.sb.append("WithoutStrategies(");
        this.sb.append(GO_PACKAGE_NAME).append(ctx.classType().getText()).append("()");
        if (ctx.classTypeList() != null && ctx.classTypeList().classTypeExpr() != null) {
            for (GremlinParser.ClassTypeContext classTypeContext : ctx.classTypeList().classTypeExpr().classType()) {
                this.sb.append(", ").append(GO_PACKAGE_NAME).append(classTypeContext.getText()).append("()");
            }
        }
        this.sb.append(")");
        return null;
    }

    @Override
    public Void visitUuidLiteral(GremlinParser.UuidLiteralContext ctx) {
        if (ctx.stringLiteral() == null) {
            this.sb.append("uuid.New()");
            return null;
        }
        this.sb.append("uuid.MustParse(");
        this.visitStringLiteral(ctx.stringLiteral());
        this.sb.append(")");
        return null;
    }

    @Override
    protected String getCardinalityFunctionClass() {
        return "CardinalityValue";
    }

    @Override
    protected void visitP(ParserRuleContext ctx, Class<?> clazzOfP, String methodName) {
        this.sb.append(GO_PACKAGE_NAME);
        super.visitP(ctx, clazzOfP, methodName);
    }

    @Override
    protected String processGremlinSymbol(String step) {
        return SymbolHelper.toGo(step);
    }

    @Override
    protected void appendExplicitNaming(String txt, String prefix) {
        this.sb.append(GO_PACKAGE_NAME);
        super.appendExplicitNaming(txt, prefix);
    }

    @Override
    protected void appendAnonymousSpawn() {
        this.sb.append(GO_PACKAGE_NAME).append("T__.");
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_GO_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_GO_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toGo(String symbol) {
            return TO_GO_MAP.getOrDefault(symbol, StringUtils.capitalize((String)symbol));
        }

        public static String toJava(String symbol) {
            return FROM_GO_MAP.getOrDefault(symbol, StringUtils.uncapitalize((String)symbol));
        }

        static {
            TO_GO_MAP.put("OUT", "Out");
            TO_GO_MAP.put("IN", "In");
            TO_GO_MAP.put("BOTH", "Both");
            TO_GO_MAP.put("bigdecimal", "BigDecimal");
            TO_GO_MAP.put("bigint", "BigInt");
            TO_GO_MAP.put("datetime", "DateTime");
            TO_GO_MAP.put("uuid", "UUID");
            TO_GO_MAP.put("vproperty", "VProperty");
            TO_GO_MAP.put("WithOptions", "gremlingo.WithOptions");
            TO_GO_MAP.put("IO", "gremlingo.IO");
            TO_GO_MAP.put("__", "gremlingo.T__");
            TO_GO_MAP.forEach((k, v) -> FROM_GO_MAP.put((String)v, (String)k));
        }
    }
}

