/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.util.InvalidXMLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class RutaCheckerUtils {
    public static Set<String> importScript(String path, int type, IScriptProject project) throws InvalidXMLException, IOException, CoreException {
        return RutaCheckerUtils.importScript(path, type, project, false);
    }

    public static Set<String> importScript(String path, int type, IScriptProject project, boolean appendPath) throws InvalidXMLException, IOException, ModelException, CoreException {
        Stack<String> namespaceStack = new Stack<String>();
        HashSet<String> imports = new HashSet<String>();
        List scriptFolders = null;
        scriptFolders = RutaProjectUtils.getAllScriptFolders((IScriptProject)project);
        String fileNameWithoutExtension = path.substring(path.lastIndexOf(46) + 1);
        String fileNameWithExtension = fileNameWithoutExtension + ".ruta";
        ISourceModule sourceModule = null;
        boolean found = false;
        block4: for (IFolder eachFolder : scriptFolders) {
            IScriptFolder[] scriptFolders2;
            if (found) break;
            IScriptProject sp = DLTKCore.create((IProject)eachFolder.getProject());
            for (IScriptFolder iScriptFolder : scriptFolders2 = sp.getScriptFolders()) {
                sourceModule = iScriptFolder.getSourceModule(fileNameWithExtension);
                if (sourceModule.exists() && sourceModule.getResource() != null && sourceModule.getResource().exists()) {
                    found = true;
                    continue block4;
                }
                if (found) continue block4;
            }
        }
        IModelElement[] elements = null;
        namespaceStack.push(fileNameWithoutExtension);
        if (sourceModule == null) {
            return imports;
        }
        try {
            elements = sourceModule.getChildren();
            for (int i = 0; i < elements.length; ++i) {
                IModelElement modelElement = elements[i];
                int elementType = modelElement.getElementType();
                if (elementType == type) {
                    if (elementType == 9) {
                        imports.add((String)namespaceStack.peek() + "." + modelElement.getElementName());
                    } else if (appendPath) {
                        imports.add(path + "." + modelElement.getElementName());
                    } else {
                        imports.add(modelElement.getElementName());
                    }
                }
                if (elementType != 9) continue;
                String nSpace = namespaceStack.empty() ? modelElement.getElementName() : (String)namespaceStack.peek() + "." + modelElement.getElementName();
                namespaceStack.push(nSpace);
                imports.addAll(RutaCheckerUtils.collectElements((IMethod)modelElement, type, namespaceStack));
                namespaceStack.pop();
            }
        }
        catch (ModelException e) {
            // empty catch block
        }
        return imports;
    }

    private static Set<String> collectElements(IMethod element, int type, Stack stack) throws ModelException {
        HashSet<String> fieldsCollection = new HashSet<String>();
        IModelElement[] elements = element.getChildren();
        if (elements == null) {
            return fieldsCollection;
        }
        for (int i = 0; i < elements.length; ++i) {
            IModelElement modelElement = elements[i];
            int elementType = modelElement.getElementType();
            if (elementType == type) {
                if (elementType == 8) {
                    fieldsCollection.add(modelElement.getElementName());
                }
                fieldsCollection.add(stack.peek() + "." + modelElement.getElementName());
            }
            if (elementType != 9) continue;
            stack.push(stack.peek() + "." + modelElement.getElementName());
            fieldsCollection.addAll(RutaCheckerUtils.collectElements((IMethod)modelElement, type, stack));
            stack.pop();
        }
        return fieldsCollection;
    }

    public static IFile getFile(IFolder folder, String filePath) {
        int lastDot = filePath.lastIndexOf(46);
        int sndLastDot = filePath.lastIndexOf(46, lastDot - 1);
        String fName = filePath;
        if (sndLastDot >= 0) {
            String subFolder = filePath.substring(0, sndLastDot);
            folder = folder.getFolder(subFolder);
            fName = filePath.substring(sndLastDot + 1);
        }
        return folder.getFile(fName);
    }

    public static boolean checkEngineImport(String xmlFilePath, IScriptProject project) {
        List allDescriptorFolders;
        boolean result = false;
        try {
            allDescriptorFolders = RutaProjectUtils.getAllDescriptorFolders((IProject)project.getProject());
        }
        catch (Exception e) {
            return false;
        }
        for (IFolder folder : allDescriptorFolders) {
            String fileExtended = xmlFilePath.replaceAll("[.]", "/") + ".xml";
            IFile file = RutaCheckerUtils.getFile(folder, fileExtended);
            result |= file.exists();
        }
        return result;
    }

    public static boolean checkEngineOnClasspath(String clazz, IScriptProject project, ClassLoader classloader) {
        if (classloader == null) {
            classloader = RutaEngine.class.getClassLoader();
        }
        try {
            Class<?> loadClass = classloader.loadClass(clazz);
            Class<?> loadClass2 = classloader.loadClass(AnalysisComponent.class.getName());
            if (loadClass != null && loadClass2.isAssignableFrom(loadClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    public static IFile checkScriptImport(String xmlFilePath, IScriptProject project) {
        List allDescriptorFolders;
        try {
            allDescriptorFolders = RutaProjectUtils.getAllScriptFolders((IScriptProject)project);
        }
        catch (CoreException e) {
            return null;
        }
        for (IFolder folder : allDescriptorFolders) {
            String fileExtended;
            IFile file = RutaCheckerUtils.getFile(folder, fileExtended = xmlFilePath.replaceAll("[.]", "/") + ".ruta");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static IFile checkTypeSystemImport(String localPath, IScriptProject project) {
        List allDescriptorFolders;
        try {
            allDescriptorFolders = RutaProjectUtils.getAllDescriptorFolders((IProject)project.getProject());
        }
        catch (Exception e) {
            return null;
        }
        for (IFolder folder : allDescriptorFolders) {
            String fileExtended;
            IFile file = RutaCheckerUtils.getFile(folder, fileExtended = localPath.replaceAll("[.]", "/") + ".xml");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static URL checkImportExistence(String candidate, String extension, ClassLoader classloader) throws IOException {
        String p = candidate.replaceAll("[.]", "/");
        p = p + "." + extension;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classloader);
        String prefix = "classpath*:";
        String pattern = prefix + p;
        Resource[] resources = resolver.getResources(pattern);
        if (resources == null || resources.length == 0) {
            return null;
        }
        Resource resource = resources[0];
        URL url = resource.getURL();
        return url;
    }
}

