/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.codeassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.ruta.ide.core.parser.RutaParseUtils;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;

public class RutaResolver {
    private IResolveElementParent resolver;
    private ModuleDeclaration moduleDeclaration;
    private ISourceModule sourceModule;

    public RutaResolver(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration, IResolveElementParent resolver) {
        this(sourceModule, moduleDeclaration);
        this.resolver = resolver;
    }

    public RutaResolver(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration) {
        this.sourceModule = sourceModule;
        this.moduleDeclaration = moduleDeclaration;
    }

    public IModelElement findModelElementFrom(ASTNode node) {
        List statements = this.moduleDeclaration.getStatements();
        ArrayList elements = new ArrayList();
        this.searchAddElementsTo(statements, node, (IParent)this.sourceModule, elements);
        if (elements.size() == 1) {
            return (IModelElement)elements.get(0);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchAddElementsTo(List statements, ASTNode node, IParent element, List selectionElements) {
        ASTNode nde;
        if (statements == null) return;
        if (element == null) {
            return;
        }
        Iterator i = statements.iterator();
        do {
            int k;
            String nodeName;
            block21: {
                String pName;
                block22: {
                    String oName;
                    if (!i.hasNext()) return;
                    nde = (ASTNode)i.next();
                    if (!nde.equals((Object)node)) continue;
                    if (!(node instanceof MethodDeclaration) || (oName = ((MethodDeclaration)node).getName()).indexOf("::") == -1) break block21;
                    pName = oName.substring(0, oName.lastIndexOf("::"));
                    if (!(pName = pName.replaceAll("::", "\\$")).startsWith("$")) break block22;
                    if (pName.equals("$")) {
                        element = this.sourceModule;
                        break block21;
                    } else {
                        try {
                            element = RutaResolver.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                        }
                        catch (ModelException e) {
                            if (DLTKCore.DEBUG) {
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                }
                pName = "$" + pName;
                try {
                    element = RutaResolver.findTypeFrom(element.getChildren(), "", pName, '$');
                    if (element == null) {
                        return;
                    }
                }
                catch (ModelException e) {
                    e.printStackTrace();
                    return;
                }
            }
            if ((nodeName = RutaResolver.getNodeChildName(node)) == null) return;
            IModelElement e = null;
            if (nodeName.startsWith("::")) {
                nodeName = nodeName.substring(2);
                e = RutaResolver.findChildrenByName(nodeName, (IParent)this.sourceModule);
            } else {
                e = RutaResolver.findChildrenByName(nodeName, element);
            }
            if (e == null && this.resolver != null) {
                e = this.resolver.findElementParent(node, nodeName, element);
            }
            if (e == null) return;
            ArrayList<IModelElement> toRemove = new ArrayList<IModelElement>();
            for (k = 0; k < selectionElements.size(); ++k) {
                IModelElement ke = (IModelElement)selectionElements.get(k);
                String keName = ke.getElementName();
                if (!keName.equals(nodeName)) continue;
                toRemove.add(ke);
            }
            k = 0;
            while (true) {
                if (k >= toRemove.size()) {
                    selectionElements.add(e);
                    return;
                }
                selectionElements.remove(toRemove.get(k));
                ++k;
            }
        } while (nde.sourceStart() > node.sourceStart() || node.sourceEnd() > nde.sourceEnd());
        if (!(element instanceof IParent)) return;
        if (nde instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)nde;
            String typeName = RutaResolver.getNodeChildName((ASTNode)type);
            IModelElement e = RutaResolver.findChildrenByName(typeName, element);
            if (e == null && type.getName().startsWith("::")) {
                try {
                    e = (IModelElement)RutaResolver.findTypeFrom(this.sourceModule.getChildren(), "", type.getName().replaceAll("::", "\\$"), '$');
                }
                catch (ModelException e1) {
                    e1.printStackTrace();
                }
            }
            if (!(e instanceof IParent)) return;
            List stats = ((TypeDeclaration)nde).getStatements();
            this.searchAddElementsTo(stats, node, (IParent)e, selectionElements);
            return;
        }
        if (nde instanceof MethodDeclaration) {
            this.searchInMethod(node, element, nde, selectionElements);
            return;
        }
        IParent e = element;
        List statements2 = RutaResolver.findExtractBlocks(nde);
        if (statements2.size() <= 0) return;
        this.searchAddElementsTo(statements2, node, e, selectionElements);
    }

    public static IModelElement findChildrenByName(String childName, IParent element) {
        block8: {
            try {
                IModelElement[] children;
                if (element == null) {
                    return null;
                }
                String nextName = null;
                int pos = childName.indexOf("::");
                if (pos != -1) {
                    nextName = childName.substring(pos + 2);
                    childName = childName.split("::")[0];
                }
                if ((children = element.getChildren()) != null) {
                    for (int i = 0; i < children.length; ++i) {
                        String name = children[i].getElementName();
                        if (children[i] instanceof IField && name.indexOf(40) != -1) {
                            name = name.substring(0, name.indexOf(40));
                        }
                        if (!name.equals(childName)) continue;
                        if (nextName == null) {
                            return children[i];
                        }
                        if (!(children[i] instanceof IParent)) continue;
                        return RutaResolver.findChildrenByName(nextName, (IParent)children[i]);
                    }
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IParent findTypeFrom(IModelElement[] childs, String name, String parentName, char delimiter) {
        block4: {
            try {
                for (int i = 0; i < childs.length; ++i) {
                    if (!(childs[i] instanceof IType) || (((IType)childs[i]).getFlags() & 0x800) == 0) continue;
                    IType type = (IType)childs[i];
                    String qname = name + delimiter + type.getElementName();
                    if (qname.equals(parentName)) {
                        return type;
                    }
                    IParent val = RutaResolver.findTypeFrom(type.getChildren(), qname, parentName, delimiter);
                    if (val == null) continue;
                    return val;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getNodeChildName(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)node;
            String name = method.getName();
            if (name.indexOf("::") != -1) {
                return name.substring(name.lastIndexOf("::") + 2);
            }
            return name;
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)node;
            String name = type.getName();
            return name;
        }
        if (node instanceof Statement) {
            String[] var = RutaParseUtils.returnVariable((Statement)node);
            if (var != null) {
                return var[0];
            }
        } else if (node instanceof FieldDeclaration) {
            return ((FieldDeclaration)node).getName();
        }
        return null;
    }

    public void searchInMethod(ASTNode node, IParent element, ASTNode nde, List selectionElements) {
        IModelElement e;
        MethodDeclaration method = (MethodDeclaration)nde;
        String methodName = method.getName();
        if (methodName.indexOf("::") != -1) {
            String pName = methodName.substring(0, methodName.lastIndexOf("::"));
            if ((pName = pName.replaceAll("::", "\\$")).equals("$")) {
                element = this.sourceModule;
            } else {
                try {
                    element = RutaResolver.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                    if (element == null) {
                        return;
                    }
                }
                catch (ModelException e2) {
                    e2.printStackTrace();
                    return;
                }
            }
            methodName = RutaResolver.getNodeChildName(nde);
        }
        if ((e = RutaResolver.findChildrenByName(methodName, element)) != null && e instanceof IParent) {
            List stats = ((MethodDeclaration)nde).getStatements();
            this.searchAddElementsTo(stats, node, (IParent)e, selectionElements);
        }
    }

    public static List findExtractBlocks(ASTNode node) {
        ArrayList statements2;
        block2: {
            statements2 = new ArrayList();
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visit(Expression s) throws Exception {
                    if (s instanceof Block) {
                        statements2.addAll(((Block)s).getStatements());
                    }
                    return super.visit(s);
                }
            };
            try {
                node.traverse(visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return statements2;
    }

    public static interface IResolveElementParent {
        public IModelElement findElementParent(ASTNode var1, String var2, IParent var3);
    }
}

