#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.21
visibility:           public
id:                   hledger-iadd-1.3.21-6XsHKBottCh9KUbfAEswc7
key:                  hledger-iadd-1.3.21-6XsHKBottCh9KUbfAEswc7
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  f2f9ac2752b2531f25a7cc7c0a2ddc2f
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.21
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.21
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.21-6XsHKBottCh9KUbfAEswc7
depends:
    base-4.18.2.1 brick-2.4-CJdVR8WN5fAIbBs4viau0I containers-0.6.7
    directory-1.3.8.5 free-5.2-C0wMFPaeM7d2Gj3dQuebRq
    hledger-lib-1.43.1-66VWsviUDji4vWSGW5vGQe
    megaparsec-9.7.0-9mft2rSPe2E2MODG5XVe3i
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-mtl-0.2.1.0-Ewo8HmKpWhTASatFX3KZGS
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw
    optparse-applicative-0.18.1.0-5nnJ4FeW1ct8RzxtI8AAka text-2.0.2
    text-zipper-0.13-mOMkF0nbvEMYyaRiwQqP time-1.12.2
    transformers-0.6.1.0
    unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    vector-0.13.2.0-3Co1wNPhccp6XnsJEn8cXR
    vty-6.2-GJSVM62QIvN9hRMOjtPpjh
    xdg-basedir-0.2.2-DLaKUfv1JJAFBfkP0BUklH

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

