# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from typing_extensions import Literal, Annotated, TypeAlias

from ..._utils import PropertyInfo
from ..._models import BaseModel
from .response_local_environment import ResponseLocalEnvironment
from .response_container_reference import ResponseContainerReference

__all__ = ["ResponseFunctionShellToolCall", "Action", "Environment"]


class Action(BaseModel):
    """The shell commands and limits that describe how to run the tool call."""

    commands: List[str]

    max_output_length: Optional[int] = None
    """Optional maximum number of characters to return from each command."""

    timeout_ms: Optional[int] = None
    """Optional timeout in milliseconds for the commands."""


Environment: TypeAlias = Annotated[
    Union[ResponseLocalEnvironment, ResponseContainerReference, None], PropertyInfo(discriminator="type")
]


class ResponseFunctionShellToolCall(BaseModel):
    """A tool call that executes one or more shell commands in a managed environment."""

    id: str
    """The unique ID of the shell tool call.

    Populated when this item is returned via API.
    """

    action: Action
    """The shell commands and limits that describe how to run the tool call."""

    call_id: str
    """The unique ID of the shell tool call generated by the model."""

    environment: Optional[Environment] = None
    """Represents the use of a local environment to perform shell actions."""

    status: Literal["in_progress", "completed", "incomplete"]
    """The status of the shell call.

    One of `in_progress`, `completed`, or `incomplete`.
    """

    type: Literal["shell_call"]
    """The type of the item. Always `shell_call`."""

    created_by: Optional[str] = None
    """The ID of the entity that created this tool call."""
