/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.Identity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.AbstractSessionController;
import org.jkiss.dbeaver.model.net.ssh.DBeaverAuthAgent;
import org.jkiss.dbeaver.model.net.ssh.KnownHostsVerifier;
import org.jkiss.dbeaver.model.net.ssh.SSHJSession;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class SSHJSessionController
extends AbstractSessionController<SSHJSession> {
    private static final Log log = Log.getLog(SSHJSessionController.class);

    @NotNull
    protected SSHJSession createSession() {
        return new SSHJSession(this);
    }

    @NotNull
    protected SSHClient createNewSession(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration host) throws DBException {
        SSHAuthConfiguration.Password password;
        int connectTimeout = configuration.getIntProperty("sshConnectTimeout", 10000);
        int keepAliveInterval = configuration.getIntProperty("aliveInterval") / 1000;
        SSHAuthConfiguration auth = host.auth();
        SSHClient client = new SSHClient();
        client.setConnectTimeout(connectTimeout);
        client.getConnection().getKeepAlive().setKeepAliveInterval(keepAliveInterval);
        client.getTransport().getConfig().setLoggerFactory((LoggerFactory)new FilterLoggerFactory());
        try {
            SSHJSessionController.setupHostKeyVerification(client, configuration, host);
        }
        catch (IOException e) {
            log.debug((Object)("Error loading known hosts: " + e.getMessage()));
        }
        monitor.subTask(String.format("Instantiate tunnel to %s:%d", host.hostname(), host.port()));
        try {
            client.connect(host.hostname(), host.port());
        }
        catch (Exception e) {
            throw new DBException("Error establishing SSHJ tunnel", (Throwable)e);
        }
        if (auth instanceof SSHAuthConfiguration.Password && (password = (SSHAuthConfiguration.Password)auth).password() != null) {
            try {
                client.authPassword(host.username(), password.password());
            }
            catch (Throwable e) {
                throw new DBException("SSH password authentication failed", e);
            }
        }
        if (auth instanceof SSHAuthConfiguration.KeyFile) {
            SSHAuthConfiguration.KeyFile key = (SSHAuthConfiguration.KeyFile)auth;
            if (CommonUtils.isEmpty((String)key.password())) {
                try {
                    client.authPublickey(host.username(), new String[]{key.path()});
                }
                catch (Throwable e) {
                    throw new DBException("SSH public key authentication failed", e);
                }
            } else {
                try {
                    client.authPublickey(host.username(), new KeyProvider[]{client.loadKeys(key.path(), key.password().toCharArray())});
                }
                catch (Throwable e) {
                    throw new DBException("SSH public key (encrypted) authentication failed", e);
                }
            }
        } else {
            if (auth instanceof SSHAuthConfiguration.KeyData) {
                SSHAuthConfiguration.KeyData key = (SSHAuthConfiguration.KeyData)auth;
                PasswordFinder finder = CommonUtils.isEmpty((String)key.password()) ? null : PasswordUtils.createOneOff((char[])key.password().toCharArray());
                try {
                    client.authPublickey(host.username(), new KeyProvider[]{client.loadKeys(key.data(), null, finder)});
                }
                catch (Throwable e) {
                    throw new DBException("SSH public key authentication failed", e);
                }
            }
            if (auth instanceof SSHAuthConfiguration.Agent) {
                ArrayList<DBeaverAuthAgent> methods = new ArrayList<DBeaverAuthAgent>();
                try {
                    for (Object identity : this.createAgentIdentityRepository().getIdentities()) {
                        methods.add(new DBeaverAuthAgent((Identity)identity));
                    }
                    client.auth(host.username(), methods);
                }
                catch (Throwable e) {
                    throw new DBException("SSH agent authentication failed", e);
                }
            }
        }
        return client;
    }

    private static void setupHostKeyVerification(@NotNull SSHClient client, @NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration actualHostConfiguration) throws IOException {
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode() || configuration.getBooleanProperty("bypassHostVerification")) {
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            client.getTransport().getConfig().setVerifyHostKeyCertificates(false);
        } else {
            client.addHostKeyVerifier((HostKeyVerifier)new KnownHostsVerifier(SSHUtils.getKnownSshHostsFileOrDefault(), actualHostConfiguration));
        }
        client.loadKnownHosts();
    }

    private static class FilterLoggerFactory
    implements LoggerFactory {
        private static final Set<String> FILTERED_OUT_CLASSES = Set.of("net.schmizz.sshj.common.StreamCopier");

        private FilterLoggerFactory() {
        }

        public Logger getLogger(String s) {
            if (FILTERED_OUT_CLASSES.contains(s)) {
                return NOPLogger.NOP_LOGGER;
            }
            return org.slf4j.LoggerFactory.getLogger((String)s);
        }

        public Logger getLogger(Class<?> cls) {
            return this.getLogger(cls.getName());
        }
    }
}

