/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.OutputStream;
import java.util.Hashtable;
import javajs.api.GenericColor;
import javajs.export.PDFCreator;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPdfWriter;
import jspecview.common.JSVersion;
import jspecview.common.PrintLayout;
import org.jmol.api.GenericGraphics;
import org.jmol.util.Font;

public class PDFWriter
implements GenericGraphics,
JSVPdfWriter {
    private GenericGraphics g2d;
    private String date;
    private PDFCreator pdf;
    private boolean inPath;
    private float[] rgb = new float[3];

    public PDFWriter() {
        this.pdf = new PDFCreator();
    }

    @Override
    public void createPdfDocument(JSVPanel panel, PrintLayout pl, OutputStream os) {
        boolean isLandscape = pl.layout.equals("landscape");
        this.date = pl.date;
        this.pdf.setOutputStream(os);
        this.g2d = panel.getPanelData().g2d;
        try {
            this.pdf.newDocument(pl.paperWidth, pl.paperHeight, isLandscape);
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("Producer", JSVersion.VERSION);
            ht.put("Creator", "JSpecView " + JSVersion.VERSION);
            ht.put("Author", "JSpecView");
            if (this.date != null) {
                ht.put("CreationDate", this.date);
            }
            this.pdf.addInfo(ht);
            panel.getPanelData().printPdf(this, pl);
            this.pdf.closeDocument();
        }
        catch (Exception e) {
            panel.showMessage(e.toString(), "PDF Creation Error");
        }
    }

    @Override
    public boolean canDoLineTo() {
        return true;
    }

    @Override
    public void doStroke(Object g, boolean isBegin) {
        this.inPath = isBegin;
        if (!this.inPath) {
            this.pdf.stroke();
        }
    }

    @Override
    public void drawCircle(Object g, int x, int y, int diameter) {
        this.pdf.doCircle(x, y, (int)((double)diameter / 2.0), false);
    }

    @Override
    public void drawLine(Object g, int x0, int y0, int x1, int y1) {
        this.pdf.moveto(x0, y0);
        this.pdf.lineto(x1, y1);
        if (!this.inPath) {
            this.pdf.stroke();
        }
    }

    @Override
    public void drawPolygon(Object g, int[] axPoints, int[] ayPoints, int nPoints) {
        this.pdf.doPolygon(axPoints, ayPoints, nPoints, false);
    }

    @Override
    public void drawRect(Object g, int x, int y, int width, int height) {
        this.pdf.doRect(x, y, width, height, false);
    }

    @Override
    public void drawString(Object g, String s, int x, int y) {
        this.pdf.drawStringRotated(s, x, y, 0);
    }

    @Override
    public void drawStringRotated(Object g, String s, int x, int y, double angle) {
        this.pdf.drawStringRotated(s, x, y, (int)angle);
    }

    @Override
    public void fillBackground(Object g, GenericColor bgcolor) {
    }

    @Override
    public void fillCircle(Object g, int x, int y, int diameter) {
        this.pdf.doCircle(x, y, (int)((double)diameter / 2.0), true);
    }

    @Override
    public void fillPolygon(Object g, int[] ayPoints, int[] axPoints, int nPoints) {
        this.pdf.doPolygon(axPoints, ayPoints, nPoints, true);
    }

    @Override
    public void fillRect(Object g, int x, int y, int width, int height) {
        this.pdf.doRect(x, y, width, height, true);
    }

    @Override
    public void lineTo(Object g, int x, int y) {
        this.pdf.lineto(x, y);
    }

    @Override
    public void setGraphicsColor(Object g, GenericColor c) {
        int p = c.getRGB();
        this.rgb[0] = (float)(p >> 16 & 0xFF) / 255.0f;
        this.rgb[1] = (float)(p >> 8 & 0xFF) / 255.0f;
        this.rgb[2] = (float)(p & 0xFF) / 255.0f;
        this.pdf.setColor(this.rgb, true);
        this.pdf.setColor(this.rgb, false);
    }

    @Override
    public Font setFont(Object g, Font font) {
        String fname = "/Helvetica";
        switch (font.idFontStyle) {
            case 1: {
                fname = fname + "-Bold";
                break;
            }
            case 3: {
                fname = fname + "-BoldOblique";
                break;
            }
            case 2: {
                fname = fname + "-Oblique";
            }
        }
        this.pdf.setFont(fname, font.fontSizeNominal);
        return font;
    }

    @Override
    public void setStrokeBold(Object g, boolean tf) {
        this.pdf.setLineWidth(tf ? 2.0f : 1.0f);
    }

    @Override
    public void translateScale(Object g, double x, double y, double scale) {
        this.pdf.translateScale((float)x, (float)y, (float)scale);
    }

    @Override
    public Object newGrayScaleImage(Object g, Object image, int width, int height, int[] buffer) {
        this.pdf.addImageResource(image, width, height, buffer, false);
        return image;
    }

    @Override
    public void drawGrayScaleImage(Object g, Object image, int destX0, int destY0, int destX1, int destY1, int srcX0, int srcY0, int srcX1, int srcY1) {
        this.pdf.drawImage(image, destX0, destY0, destX1, destY1, srcX0, srcY0, srcX1, srcY1);
    }

    @Override
    public void setWindowParameters(int width, int height) {
    }

    @Override
    public GenericColor getColor1(int argb) {
        return this.g2d.getColor1(argb);
    }

    @Override
    public GenericColor getColor3(int red, int green, int blue) {
        return this.g2d.getColor3(red, green, blue);
    }

    @Override
    public GenericColor getColor4(int r, int g, int b, int a) {
        return this.g2d.getColor4(r, g, b, a);
    }
}

