/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.sql.SQLException;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class SQLExceptionChainBuilder {
    private @Nullable SQLException root;

    public SQLExceptionChainBuilder append(SQLException sqle) {
        if (this.root == null) {
            this.root = sqle;
        } else {
            this.root.setNextException(sqle);
        }
        return this;
    }

    public SQLExceptionChainBuilder addFirst(SQLException sqle) {
        SQLException originalRoot = this.root;
        if (originalRoot != null) {
            sqle.setNextException(originalRoot);
        }
        this.root = sqle;
        return this;
    }

    public boolean hasException() {
        return this.root != null;
    }

    public @Nullable SQLException getException() {
        return this.root;
    }

    public @NonNull Optional<SQLException> optException() {
        return Optional.ofNullable(this.root);
    }

    public void throwIfPresent() throws SQLException {
        SQLException root = this.root;
        if (root != null) {
            throw root;
        }
    }
}

