/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.util.FirebirdSupportInfo;

public final class TypeMetadata {
    static final String FIELD_TYPE = "FIELD_TYPE";
    static final String FIELD_SUB_TYPE = "FIELD_SUB_TYPE";
    static final String FIELD_PRECISION = "FIELD_PRECISION";
    static final String FIELD_SCALE = "FIELD_SCALE";
    static final String FIELD_LENGTH = "FIELD_LENGTH";
    static final String CHAR_LEN = "CHAR_LEN";
    static final String CHARSET_ID = "CHARSET_ID";
    private final int type;
    private final int subType;
    private final Integer precision;
    private final Integer scale;
    private final Integer jdbcType;
    private final Integer fieldLength;
    private final Integer characterLength;
    private final Set<TypeBehaviour> typeBehaviours;

    private TypeMetadata(int type, Integer subType, Integer precision, Integer scale, Integer characterSetId, Integer fieldLength, Integer characterLength, Set<TypeBehaviour> typeBehaviours) {
        this.type = type;
        this.subType = TypeMetadata.coalesce(subType, 0);
        this.precision = precision;
        this.scale = scale;
        this.jdbcType = TypeMetadata.getDataType(type, this.subType, TypeMetadata.coalesce(scale, 0), TypeMetadata.coalesce(characterSetId, 0));
        this.fieldLength = fieldLength;
        this.characterLength = TypeMetadata.isDefault(characterLength) && !TypeMetadata.isDefault(fieldLength) && TypeMetadata.isCharacterType(type) ? fieldLength : characterLength;
        this.typeBehaviours = typeBehaviours.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(typeBehaviours));
    }

    int getType() {
        return this.type;
    }

    int getJdbcType() {
        return this.jdbcType;
    }

    String getSqlTypeName() {
        return TypeMetadata.getDataTypeName(this.type, this.subType, TypeMetadata.coalesce(this.scale, 0));
    }

    Integer getColumnSize() {
        return switch (this.jdbcType) {
            case 6 -> this.isFloatBinaryPrecision() ? 24 : 7;
            case 8 -> this.isFloatBinaryPrecision() ? 53 : 15;
            case -3, -2, 1, 12 -> this.characterLength;
            case -5 -> 19;
            case 4 -> 10;
            case 5 -> 5;
            case 16 -> 1;
            case 2, 3 -> {
                switch (this.type) {
                    case 11: 
                    case 16: 
                    case 27: {
                        yield TypeMetadata.coalesce(this.precision, 18);
                    }
                    case 8: {
                        yield TypeMetadata.coalesce(this.precision, 9);
                    }
                    case 7: {
                        yield TypeMetadata.coalesce(this.precision, 4);
                    }
                    case 26: {
                        if (this.precision == 0) {
                            yield 38;
                        }
                        yield TypeMetadata.coalesce(this.precision, 38);
                    }
                }
                throw new IllegalStateException(String.format("Incorrect derivation of NUMERIC/DECIMAL precision for jdbcType %d, type %d, subType %d, scale %d", this.jdbcType, this.type, this.subType, this.scale));
            }
            case 91 -> 10;
            case 92 -> 13;
            case 93 -> 24;
            case 2013 -> 19;
            case 2014 -> 30;
            case -6001 -> {
                switch (this.type) {
                    case 24: {
                        yield 16;
                    }
                    case 25: {
                        yield 34;
                    }
                }
                throw new IllegalStateException(String.format("Incorrect derivation of DECFLOAT precision for jdbcType %d, type %d, subType %d, scale %d", this.jdbcType, this.type, this.subType, this.scale));
            }
            default -> TypeMetadata.coalesce(this.precision, 0) != 0 ? this.precision : null;
        };
    }

    Integer getLength() {
        return this.fieldLength;
    }

    Integer getScale() {
        return switch (this.jdbcType) {
            case -5, 4, 5 -> 0;
            case 2, 3 -> -1 * TypeMetadata.coalesce(this.scale, 0);
            default -> TypeMetadata.coalesce(this.scale, 0) != 0 ? this.scale : null;
        };
    }

    int getRadix() {
        return switch (this.jdbcType) {
            case 6, 8 -> {
                if (this.isFloatBinaryPrecision()) {
                    yield 2;
                }
                yield 10;
            }
            case 16 -> 2;
            default -> 10;
        };
    }

    Integer getCharOctetLength() {
        if (TypeMetadata.isCharacterType(this.type)) {
            return this.getLength();
        }
        return null;
    }

    static Builder builder(FirebirdSupportInfo supportInfo) {
        return new Builder(supportInfo);
    }

    public static int getDataType(int sqlType, int sqlSubType, int sqlScale, int characterSetId) {
        if (sqlType == 261 && sqlSubType > 1) {
            return 1111;
        }
        int jdbcType = JdbcTypeConverter.fromMetaDataToJdbcType(sqlType, sqlSubType, sqlScale);
        if (characterSetId == 1) {
            if (jdbcType == 1) {
                return -2;
            }
            if (jdbcType == 12) {
                return -3;
            }
        }
        return jdbcType;
    }

    public static String getDataTypeName(int sqlType, int sqlSubType, int sqlScale) {
        int firebirdType = JdbcTypeConverter.fromMetaDataToFirebirdType(sqlType);
        int jdbcType = JdbcTypeConverter.fromFirebirdToJdbcType(firebirdType, sqlSubType, sqlScale);
        return JdbcTypeConverter.getTypeName(jdbcType, firebirdType, sqlSubType, sqlScale);
    }

    private boolean isFloatBinaryPrecision() {
        return this.typeBehaviours.contains((Object)TypeBehaviour.FLOAT_BINARY_PRECISION);
    }

    private static int coalesce(Integer value, int replacement) {
        return value != null ? value : replacement;
    }

    private static boolean isDefault(Integer value) {
        return value == null;
    }

    private static boolean isCharacterType(int sqlType) {
        return sqlType == 14 || sqlType == 37 || sqlType == 40;
    }

    static final class Builder {
        private int type;
        private Integer subType;
        private Integer precision;
        private Integer scale;
        private Integer characterSetId;
        private Integer fieldLength;
        private Integer characterLength;
        private final Set<TypeBehaviour> typeBehaviours = EnumSet.noneOf(TypeBehaviour.class);

        Builder(FirebirdSupportInfo supportInfo) {
            this.typeBehaviours.add(supportInfo.supportsFloatBinaryPrecision() ? TypeBehaviour.FLOAT_BINARY_PRECISION : TypeBehaviour.FLOAT_DECIMAL_PRECISION);
        }

        TypeMetadata build() {
            if (this.type == 0) {
                throw new IllegalStateException("type must be set");
            }
            return new TypeMetadata(this.type, this.subType, this.precision, this.scale, this.characterSetId, this.fieldLength, this.characterLength, this.typeBehaviours);
        }

        Builder withType(int type) {
            this.type = type;
            return this;
        }

        Builder withSubType(Integer subType) {
            this.subType = subType;
            return this;
        }

        Builder withPrecision(Integer precision) {
            this.precision = precision;
            return this;
        }

        Builder withScale(Integer scale) {
            this.scale = scale;
            return this;
        }

        Builder withCharacterSetId(Integer characterSetId) {
            this.characterSetId = characterSetId;
            return this;
        }

        Builder withFieldLength(Integer fieldLength) {
            this.fieldLength = fieldLength;
            return this;
        }

        Builder withCharacterLength(Integer characterLength) {
            this.characterLength = characterLength;
            return this;
        }

        Builder fromCurrentRow(ResultSet resultSet) throws SQLException {
            return this.withType(resultSet.getObject(TypeMetadata.FIELD_TYPE, Integer.class)).withSubType(resultSet.getObject(TypeMetadata.FIELD_SUB_TYPE, Integer.class)).withPrecision(resultSet.getObject(TypeMetadata.FIELD_PRECISION, Integer.class)).withScale(resultSet.getObject(TypeMetadata.FIELD_SCALE, Integer.class)).withFieldLength(resultSet.getObject(TypeMetadata.FIELD_LENGTH, Integer.class)).withCharacterLength(resultSet.getObject(TypeMetadata.CHAR_LEN, Integer.class)).withCharacterSetId(resultSet.getObject(TypeMetadata.CHARSET_ID, Integer.class));
        }
    }

    static enum TypeBehaviour {
        FLOAT_DECIMAL_PRECISION,
        FLOAT_BINARY_PRECISION;

    }
}

