/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.data.handlers;

import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapRowHandler
implements RowHandler<Map<String, Object>> {
    @Override
    public Map<String, Object> handle(ResultSet resultSet, Map<String, Object> map) throws SQLException {
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
        }
        this.update(resultSet, map);
        return map;
    }

    public void updateMap(ResultSet resultSet, Map<String, Object> map, String[] stringArray) throws SQLException {
        if (stringArray == null) {
            this.update(resultSet, map);
        } else {
            this.updateMapUsingColumnNamesArray(resultSet, map, stringArray);
        }
    }

    private void update(ResultSet resultSet, Map<String, Object> map) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (int i10 = 1; i10 <= n2; ++i10) {
            if ("TIMESTAMP WITH TIME ZONE".equals(resultSetMetaData.getColumnTypeName(i10))) {
                map.put(resultSetMetaData.getColumnLabel(i10).toLowerCase(), StatementUtilities.getDBTimestamp(resultSet, i10));
                continue;
            }
            map.put(resultSetMetaData.getColumnLabel(i10).toLowerCase(), resultSet.getObject(i10));
        }
    }

    private void updateMapUsingColumnNamesArray(ResultSet resultSet, Map<String, Object> map, String[] stringArray) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            int n2 = resultSet.findColumn(stringArray[i10].toLowerCase());
            if ("TIMESTAMP WITH TIME ZONE".equals(resultSetMetaData.getColumnTypeName(n2))) {
                map.put(stringArray[i10].toLowerCase(), StatementUtilities.getDBTimestamp(resultSet, n2));
                continue;
            }
            map.put(stringArray[i10].toLowerCase(), resultSet.getObject(n2));
        }
    }
}

