/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CLongAccessor
extends LongAccessor {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    T2CLongAccessor(OracleStatement stmt, int column_pos, int max_len, short form, int external_type) throws SQLException {
        super(stmt, column_pos, max_len, form, external_type);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$7, null, stmt, column_pos, max_len, form, external_type);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    T2CLongAccessor(OracleStatement stmt, int column_pos, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, column_pos, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$8, null, stmt, column_pos, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    byte[] getBytesInternal(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$0, this, n2);
            }
            if (this.statement.isFetchStreams) {
                if (!$assertionsDisabled && this.isNull((int)currentRow)) {
                    AssertionError assertionError = new AssertionError();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$0, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                int len = this.getLength((int)currentRow);
                long off = this.getOffset((int)currentRow);
                byte[] byArray = this.rowData.get(off, len);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$0, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$0, this, null);
                }
                return byArray;
            }
            byte[] byArray = super.getBytesInternal((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$0, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$0, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, n2);
            }
            if (this.statement.isFetchStreams) {
                InputStream inputStream;
                if (this.isNull((int)currentRow)) {
                    InputStream inputStream2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, inputStream2);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, null);
                    }
                    return null;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(this.rowData.get(this.getOffset((int)currentRow), this.getLength((int)currentRow)));
                try {
                    inputStream = this.statement.connection.conversion.ConvertStream(is, 0);
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, throwable2);
                    }
                    throw throwable2;
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                InputStream inputStream3 = inputStream;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, inputStream3);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, null);
                }
                return inputStream3;
            }
            InputStream inputStream = super.getAsciiStream((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    InputStream getUnicodeStream(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.statement.isFetchStreams) {
                InputStream inputStream;
                if (this.isNull((int)currentRow)) {
                    InputStream inputStream2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, inputStream2);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, null);
                    }
                    return null;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(this.rowData.get(this.getOffset((int)currentRow), this.getLength((int)currentRow)));
                try {
                    inputStream = this.statement.connection.conversion.ConvertStream(is, 1);
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, throwable2);
                    }
                    throw throwable2;
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                InputStream inputStream3 = inputStream;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, inputStream3);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, null);
                }
                return inputStream3;
            }
            InputStream inputStream = super.getUnicodeStream((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$2, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, n2);
            }
            if (this.statement.isFetchStreams) {
                Reader reader;
                if (this.isNull((int)currentRow)) {
                    Reader reader2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, reader2);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, null);
                    }
                    return null;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(this.rowData.get(this.getOffset((int)currentRow), this.getLength((int)currentRow)));
                try {
                    reader = this.statement.connection.conversion.ConvertCharacterStream(is, 9, this.formOfUse);
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, throwable2);
                    }
                    throw throwable2;
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Reader reader3 = reader;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, reader3);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, null);
                }
                return reader3;
            }
            Reader reader = super.getCharacterStream((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, reader);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$3, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, n2);
            }
            if (this.statement.isFetchStreams) {
                InputStream inputStream;
                if (this.isNull((int)currentRow)) {
                    InputStream inputStream2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, inputStream2);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, null);
                    }
                    return null;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(this.rowData.get(this.getOffset((int)currentRow), this.getLength((int)currentRow)));
                try {
                    inputStream = this.statement.connection.conversion.ConvertStream(is, 6);
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, throwable2);
                    }
                    throw throwable2;
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                InputStream inputStream3 = inputStream;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, inputStream3);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, null);
                }
                return inputStream3;
            }
            InputStream inputStream = super.getBinaryStream((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$4, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void copyStreamDataIntoDBA(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$5, this, n2);
            }
            if (this.stream.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$5, this, sQLException);
                }
                throw sQLException;
            }
            ByteArrayOutputStream outs = null;
            byte[] b2 = null;
            try {
                outs = new ByteArrayOutputStream(1024);
                byte[] buffer = this.statement.connection.getByteBuffer(32768);
                try {
                    int length;
                    while ((length = this.stream.read(buffer, 0, 32768)) != -1) {
                        outs.write(buffer, 0, length);
                    }
                    this.statement.connection.cacheBuffer(buffer);
                }
                catch (IOException e2) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$5, this, sQLException);
                    }
                    throw sQLException;
                }
                b2 = outs.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    if (outs != null) {
                        outs.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$5, this, throwable2);
                }
                throw throwable2;
            }
            try {
                if (outs != null) {
                    outs.close();
                }
            }
            catch (IOException iOException) {}
            if (b2 == null || b2.length == 0) {
                this.setLengthAndNull((int)currentRow, 0);
            } else {
                this.setOffset((int)currentRow);
                this.setLengthAndNull((int)currentRow, b2.length);
                this.rowData.put(b2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$5, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Accessor copyForDefine(OracleStatement oracleStatement) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dest;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$6, this, oracleStatement);
            }
            LongAccessor a2 = (LongAccessor)super.copyForDefine((OracleStatement)dest);
            try {
                a2.stream = dest.connection.driverExtension.createInputStream((OracleStatement)dest, this.columnPosition, a2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            LongAccessor longAccessor = a2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$6, this, longAccessor);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$6, this, null);
            }
            return longAccessor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T2CLongAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$8 = T2CLongAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T2CLongAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T2CLongAccessor.class.getDeclaredMethod("copyForDefine", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T2CLongAccessor.class.getDeclaredMethod("copyStreamDataIntoDBA", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T2CLongAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T2CLongAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T2CLongAccessor.class.getDeclaredMethod("getUnicodeStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CLongAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CLongAccessor.class.getDeclaredMethod("getBytesInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

