/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.memoryview;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.BufferFlags;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.PyMemoryViewWrapper;
import com.oracle.graal.python.builtins.objects.memoryview.BufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.BufferReference;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;

@ExportLibrary.Repeat(value={@ExportLibrary(value=PythonBufferAcquireLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class)})
public final class PMemoryView
extends PythonBuiltinObject {
    public static final int MAX_DIM = 64;
    public static final int FLAG_RELEASED = 1;
    public static final int FLAG_C = 2;
    public static final int FLAG_FORTRAN = 4;
    public static final int FLAG_SCALAR = 8;
    public static final int FLAG_PIL = 16;
    private Object owner;
    private Object buffer;
    private boolean shouldReleaseImmediately;
    private final int len;
    private final boolean readonly;
    private final int itemsize;
    private final TruffleString formatString;
    private final BufferFormat format;
    private final int ndim;
    private final Object bufPointer;
    private final int offset;
    private final int[] shape;
    private final int[] strides;
    private final int[] suboffsets;
    private final AtomicLong exports = new AtomicLong();
    private BufferReference reference;
    private int flags;
    private int cachedHash = -1;

    public PMemoryView(Object cls, Shape instanceShape, PythonContext context, BufferLifecycleManager bufferLifecycleManager, Object buffer, Object owner, int len, boolean readonly, int itemsize, BufferFormat format, TruffleString formatString, int ndim, Object bufPointer, int offset, int[] shape, int[] strides, int[] suboffsets, int flags) {
        super(cls, instanceShape);
        PythonBufferAccessLibrary.assertIsBuffer(buffer);
        this.buffer = buffer;
        this.owner = owner;
        this.len = len;
        this.readonly = readonly;
        this.itemsize = itemsize;
        this.format = format;
        this.formatString = formatString;
        this.ndim = ndim;
        this.bufPointer = bufPointer;
        this.offset = offset;
        this.shape = shape;
        this.strides = strides;
        this.suboffsets = suboffsets;
        this.flags = flags;
        if (bufferLifecycleManager != null) {
            this.reference = BufferReference.createBufferReference(this, bufferLifecycleManager, context);
        }
        this.setNativeWrapper(new PyMemoryViewWrapper(this));
    }

    public static int[] initStridesFromShape(int ndim, int itemsize, int[] shape) {
        int[] strides = new int[ndim];
        strides[ndim - 1] = itemsize;
        for (int i = ndim - 2; i >= 0; --i) {
            strides[i] = strides[i + 1] * shape[i + 1];
        }
        return strides;
    }

    public BufferLifecycleManager getLifecycleManager() {
        return this.reference != null ? this.reference.getLifecycleManager() : null;
    }

    public Object getBuffer() {
        return this.buffer;
    }

    @ExportMessage.Ignore
    public Object getOwner() {
        return this.owner;
    }

    public int getLength() {
        return this.len;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    @ExportMessage
    public int getItemSize() {
        return this.itemsize;
    }

    @ExportMessage
    public TruffleString getFormatString() {
        return this.formatString;
    }

    public BufferFormat getFormat() {
        return this.format;
    }

    public int getDimensions() {
        return this.ndim;
    }

    public Object getBufferPointer() {
        return this.bufPointer;
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getBufferShape() {
        return this.shape;
    }

    public int[] getBufferStrides() {
        return this.strides;
    }

    public int[] getBufferSuboffsets() {
        return this.suboffsets;
    }

    public boolean isReleased() {
        return (this.flags & 1) != 0;
    }

    public boolean isCContiguous() {
        return (this.flags & 0xA) != 0;
    }

    public boolean isFortranContiguous() {
        return (this.flags & 0xC) != 0;
    }

    public boolean isAnyContiguous() {
        return this.isCContiguous() || this.isFortranContiguous();
    }

    public int getFlags() {
        return this.flags;
    }

    public AtomicLong getExports() {
        return this.exports;
    }

    public BufferReference getReference() {
        return this.reference;
    }

    public int getCachedHash() {
        return this.cachedHash;
    }

    public void setCachedHash(int cachedHash) {
        this.cachedHash = cachedHash;
    }

    public void setReleased() {
        this.flags |= 1;
        if (this.reference != null) {
            this.reference.markReleased();
            this.reference = null;
        }
        this.buffer = null;
        this.owner = null;
    }

    public void setShouldReleaseImmediately(boolean shouldReleaseImmediately) {
        this.shouldReleaseImmediately = shouldReleaseImmediately;
    }

    public void checkReleased(Node inliningTarget, PRaiseNode raiseNode) {
        if (this.isReleased()) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MEMORYVIEW_FORBIDDEN_RELEASED);
        }
    }

    boolean checkShouldReleaseBuffer() {
        if (this.getReference() != null) {
            return this.getReference().getLifecycleManager().decrementExports() == 0;
        }
        return false;
    }

    void checkExports(Node inliningTarget, PRaiseNode node) {
        long exportsValue = this.getExports().get();
        if (exportsValue > 0L) {
            throw node.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.MEMORYVIEW_HAS_D_EXPORTED_BUFFERS, exportsValue);
        }
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    boolean hasBuffer() {
        return true;
    }

    @ExportMessage
    int getBufferLength() {
        return this.getLength();
    }

    @ExportMessage
    Object acquire(int requestedFlags, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
        this.checkReleased(inliningTarget, raiseNode);
        if (BufferFlags.requestsWritable(requestedFlags) && this.readonly) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.MV_UNDERLYING_BUF_ISNT_WRITABLE);
        }
        if (BufferFlags.requestsCContiguous(requestedFlags) && !this.isCContiguous()) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.MV_UNDERLYING_BUF_ISNT_C_CONTIGUOUS);
        }
        if (BufferFlags.requestsFContiguous(requestedFlags) && !this.isFortranContiguous()) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.MV_UNDERLYING_BUF_ISNT_FORTRAN_CONTIGUOUS);
        }
        if (BufferFlags.requestsAnyContiguous(requestedFlags) && !this.isAnyContiguous()) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.MV_UNDERLYING_BUF_ISNT_CONTIGUOUS);
        }
        if (!BufferFlags.requestsIndirect(requestedFlags) && (this.flags & 0x10) != 0) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.MV_UNDERLYING_BUF_REQUIRES_SUBOFFSETS);
        }
        if (!BufferFlags.requestsStrides(requestedFlags) && !this.isCContiguous()) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.MV_UNDERLYING_BUF_ISNT_C_CONTIGUOUS);
        }
        if (!BufferFlags.requestsShape(requestedFlags) && BufferFlags.requestsFormat(requestedFlags)) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.MV_CANNOT_CAST_UNSIGNED_BYTES_IF_FMT_FLAG);
        }
        this.exports.incrementAndGet();
        return this;
    }

    @ExportMessage
    void release(@Bind Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached MemoryViewNodes.ReleaseBufferNode releaseNode) {
        if (this.shouldReleaseImmediately) {
            this.checkExports(inliningTarget, raiseNode);
            if (this.checkShouldReleaseBuffer()) {
                releaseNode.execute(inliningTarget, this.getLifecycleManager());
            }
            this.setReleased();
        } else {
            long l = this.exports.decrementAndGet();
            assert (l >= 0L);
        }
    }

    @ExportMessage
    boolean isReadonly() {
        return this.readonly;
    }

    @ExportMessage
    boolean hasInternalByteArray(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        return this.offset == 0 && bufferLib.hasInternalByteArray(this.buffer);
    }

    @ExportMessage
    byte[] getInternalByteArray(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.hasInternalByteArray(bufferLib));
        return bufferLib.getInternalByteArray(this.buffer);
    }

    @ExportMessage
    void readIntoByteArray(int srcOffset, byte[] dest, int destOffset, int length, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        bufferLib.readIntoByteArray(this.buffer, this.offset + srcOffset, dest, destOffset, length);
    }

    @ExportMessage
    void writeFromByteArray(int destOffset, byte[] src, int srcOffset, int length, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        bufferLib.writeFromByteArray(this.buffer, this.offset + destOffset, src, srcOffset, length);
    }

    @ExportMessage
    void readIntoBuffer(int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        bufferLib.readIntoBuffer(this.buffer, this.offset + srcOffset, dest, destOffset, length, otherLib);
    }

    @ExportMessage
    byte readByte(int byteOffset, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        return bufferLib.readByte(this.buffer, this.offset + byteOffset);
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        assert (!this.readonly);
        bufferLib.writeByte(this.buffer, this.offset + byteOffset, value);
    }

    @ExportMessage
    short readShortByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        return bufferLib.readShortByteOrder(this.buffer, this.offset + byteOffset, byteOrder);
    }

    @ExportMessage
    void writeShortByteOrder(int byteOffset, short value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        assert (!this.readonly);
        bufferLib.writeShortByteOrder(this.buffer, this.offset + byteOffset, value, byteOrder);
    }

    @ExportMessage
    int readIntByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        return bufferLib.readIntByteOrder(this.buffer, this.offset + byteOffset, byteOrder);
    }

    @ExportMessage
    void writeIntByteOrder(int byteOffset, int value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        assert (!this.readonly);
        bufferLib.writeIntByteOrder(this.buffer, this.offset + byteOffset, value, byteOrder);
    }

    @ExportMessage
    long readLongByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        return bufferLib.readLongByteOrder(this.buffer, this.offset + byteOffset, byteOrder);
    }

    @ExportMessage
    void writeLongByteOrder(int byteOffset, long value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        assert (!this.readonly);
        bufferLib.writeLongByteOrder(this.buffer, this.offset + byteOffset, value, byteOrder);
    }

    @ExportMessage
    float readFloatByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        return bufferLib.readFloatByteOrder(this.buffer, this.offset + byteOffset, byteOrder);
    }

    @ExportMessage
    void writeFloatByteOrder(int byteOffset, float value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (!this.readonly);
        bufferLib.writeFloatByteOrder(this.buffer, this.offset + byteOffset, value, byteOrder);
    }

    @ExportMessage
    double readDoubleByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        return bufferLib.readDoubleByteOrder(this.buffer, this.offset + byteOffset, byteOrder);
    }

    @ExportMessage
    void writeDoubleByteOrder(int byteOffset, double value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        assert (this.isAnyContiguous() && !this.isReleased());
        assert (!this.readonly);
        bufferLib.writeDoubleByteOrder(this.buffer, this.offset + byteOffset, value, byteOrder);
    }

    @ExportMessage
    boolean isNative(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        if (this.getBufferPointer() != null) {
            return true;
        }
        return bufferLib.isNative(this.buffer);
    }

    @ExportMessage
    Object getNativePointer(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        if (this.getBufferPointer() != null) {
            return this.getBufferPointer();
        }
        return bufferLib.getNativePointer(this.buffer);
    }
}

