/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.ObjectNameWrapper;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionMXBean;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;

public class PoolableConnection
extends DelegatingConnection<Connection>
implements PoolableConnectionMXBean {
    private static MBeanServer MBEAN_SERVER;
    private final ObjectPool<PoolableConnection> pool;
    private final ObjectNameWrapper jmxObjectName;
    private PreparedStatement validationPreparedStatement;
    private String lastValidationSql;
    private final AtomicBoolean fatalSqlExceptionThrown = new AtomicBoolean();
    private final Collection<String> disconnectionSqlCodes;
    private final Collection<String> disconnectionIgnoreSqlCodes;
    private final boolean fastFailValidation;
    private final Lock lock = new ReentrantLock();

    public PoolableConnection(Connection connection, ObjectPool<PoolableConnection> objectPool, ObjectName objectName) {
        this(connection, objectPool, objectName, null, true);
    }

    public PoolableConnection(Connection connection, ObjectPool<PoolableConnection> objectPool, ObjectName objectName, Collection<String> collection, boolean bl) {
        this(connection, objectPool, objectName, collection, null, bl);
    }

    public PoolableConnection(Connection connection, ObjectPool<PoolableConnection> objectPool, ObjectName objectName, Collection<String> collection, Collection<String> collection2, boolean bl) {
        super(connection);
        this.pool = objectPool;
        this.jmxObjectName = ObjectNameWrapper.wrap(objectName);
        this.disconnectionSqlCodes = collection;
        this.disconnectionIgnoreSqlCodes = collection2;
        this.fastFailValidation = bl;
        if (objectName != null) {
            try {
                MBEAN_SERVER.registerMBean(this, objectName);
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException jMException) {
                // empty catch block
            }
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.jmxObjectName != null) {
            this.jmxObjectName.unregisterMBean();
        }
        super.abort(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block19: {
            this.lock.lock();
            try {
                boolean bl;
                if (this.isClosedInternal()) {
                    return;
                }
                try {
                    bl = this.getDelegateInternal().isClosed();
                }
                catch (SQLException sQLException) {
                    try {
                        this.pool.invalidateObject(this);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.passivate();
                        this.getInnermostDelegate().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new SQLException("Cannot close connection (isClosed check failed)", sQLException);
                }
                if (bl) {
                    try {
                        this.pool.invalidateObject(this);
                        break block19;
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.passivate();
                        this.getInnermostDelegate().close();
                        break block19;
                    }
                    catch (Exception exception) {
                        throw new SQLException("Cannot close connection (invalidating pooled object failed)", exception);
                    }
                }
                try {
                    this.pool.returnObject(this);
                }
                catch (IllegalStateException illegalStateException) {
                    this.passivate();
                    this.getInnermostDelegate().close();
                }
                catch (RuntimeException | SQLException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    throw new SQLException("Cannot close connection (return to pool failed)", exception);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public Collection<String> getDisconnectionSqlCodes() {
        return this.disconnectionSqlCodes;
    }

    @Override
    public String getToString() {
        return this.toString();
    }

    @Override
    protected void handleException(SQLException sQLException) throws SQLException {
        this.fatalSqlExceptionThrown.compareAndSet(false, this.isFatalException(sQLException));
        super.handleException(sQLException);
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isClosedInternal()) {
            return true;
        }
        if (this.getDelegateInternal().isClosed()) {
            this.close();
            return true;
        }
        return false;
    }

    boolean isDisconnectionSqlException(SQLException sQLException) {
        boolean bl = false;
        String string = sQLException.getSQLState();
        if (string != null) {
            if (this.disconnectionIgnoreSqlCodes != null && this.disconnectionIgnoreSqlCodes.contains(string)) {
                return false;
            }
            bl = this.disconnectionSqlCodes == null ? string.startsWith("08") || Utils.isDisconnectionSqlCode(string) : this.disconnectionSqlCodes.contains(string);
        }
        return bl;
    }

    public boolean isFastFailValidation() {
        return this.fastFailValidation;
    }

    boolean isFatalException(SQLException sQLException) {
        boolean bl = this.isDisconnectionSqlException(sQLException);
        if (!bl) {
            SQLException sQLException2 = sQLException;
            SQLException sQLException3 = sQLException.getNextException();
            while (sQLException3 != null && sQLException3 != sQLException2 && !bl) {
                bl = this.isDisconnectionSqlException(sQLException3);
                sQLException2 = sQLException3;
                sQLException3 = sQLException2.getNextException();
            }
        }
        return bl;
    }

    @Override
    protected void passivate() throws SQLException {
        super.passivate();
        this.setClosedInternal(true);
        if (this.getDelegateInternal() instanceof PoolingConnection) {
            ((PoolingConnection)this.getDelegateInternal()).connectionReturnedToPool();
        }
    }

    @Override
    public void reallyClose() throws SQLException {
        if (this.jmxObjectName != null) {
            this.jmxObjectName.unregisterMBean();
        }
        if (this.validationPreparedStatement != null) {
            Utils.closeQuietly((AutoCloseable)this.validationPreparedStatement);
        }
        super.closeInternal();
    }

    @Override
    public void setLastUsed() {
        GenericObjectPool genericObjectPool;
        super.setLastUsed();
        if (this.pool instanceof GenericObjectPool && (genericObjectPool = (GenericObjectPool)this.pool).isAbandonedConfig()) {
            genericObjectPool.use(this);
        }
    }

    public void validate(String string, Duration duration) throws SQLException {
        if (this.fastFailValidation && this.fatalSqlExceptionThrown.get()) {
            throw new SQLException(Utils.getMessage("poolableConnection.validate.fastFail"));
        }
        if (string == null || string.isEmpty()) {
            if (duration.isNegative()) {
                duration = Duration.ZERO;
            }
            if (!this.isValid(duration)) {
                throw new SQLException("isValid() returned false");
            }
            return;
        }
        if (!string.equals(this.lastValidationSql)) {
            this.lastValidationSql = string;
            this.validationPreparedStatement = this.getInnermostDelegateInternal().prepareStatement(string);
        }
        if (duration.compareTo(Duration.ZERO) > 0) {
            this.validationPreparedStatement.setQueryTimeout((int)duration.getSeconds());
        }
        try (ResultSet resultSet = this.validationPreparedStatement.executeQuery();){
            if (!resultSet.next()) {
                throw new SQLException("validationQuery didn't return a row");
            }
        }
    }

    @Deprecated
    public void validate(String string, int n) throws SQLException {
        this.validate(string, Duration.ofSeconds(n));
    }

    static {
        try {
            MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }
}

