/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import java.util.Enumeration;
import org.graalvm.visualvm.lib.jfluid.ProfilerEngineSettings;
import org.graalvm.visualvm.lib.jfluid.classfile.BaseClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassRepository;
import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.instrumentation.InstrumentationFactory;
import org.graalvm.visualvm.lib.jfluid.instrumentation.MemoryProfMethodInstrumentor;
import org.graalvm.visualvm.lib.jfluid.instrumentation.SingleMethodScaner;

public class ObjLivenessMethodInstrumentor
extends MemoryProfMethodInstrumentor {
    protected static final int STANDARD_INSTRUMENTATION = 1;
    protected static final int SELECTIVE_INSTR_REMOVAL = 2;
    protected boolean[] allUnprofiledClassStatusArray;
    protected int operationCode;
    private final ProfilerEngineSettings engineSettings;
    private final InstrumentationFilter instrFilter;
    private final boolean instrObjectInit;
    private final boolean instrArr;

    public ObjLivenessMethodInstrumentor(ClassRepository repo, ProfilingSessionStatus status, ProfilerEngineSettings engineSettings, boolean isLiveness) {
        super(repo, status, isLiveness ? 10 : 9);
        this.engineSettings = engineSettings;
        this.instrFilter = engineSettings.getInstrumentationFilter();
        this.operationCode = 1;
        this.instrObjectInit = engineSettings.isInstrumentObjectInit();
        this.instrArr = engineSettings.isInstrumentArrayAllocation();
    }

    public Object[] getMethodsToInstrumentUponClassUnprofiling(boolean[] unprofiledClassStatusArray) {
        this.operationCode = 2;
        this.initInstrumentationPackData();
        MethodScanerForBannedInstantiations msbi = new MethodScanerForBannedInstantiations();
        msbi.setUnprofiledClassStatusArray(unprofiledClassStatusArray);
        this.setAllUnprofiledClassStatusArray(unprofiledClassStatusArray);
        Enumeration e = this.getClassEnumerationWithAllVersions();
        while (e.hasMoreElements()) {
            DynamicClassInfo clazz;
            Object ci = e.nextElement();
            if (!(ci instanceof DynamicClassInfo) || !(clazz = (DynamicClassInfo)ci).isLoaded() || !clazz.hasInstrumentedMethods()) continue;
            String[] methodNames = clazz.getMethodNames();
            boolean found = false;
            for (int i = 0; i < methodNames.length; ++i) {
                if (!clazz.isMethodInstrumented(i)) continue;
                msbi.setClassAndMethod(clazz, i);
                if (!msbi.hasNewOpcodes(!this.instrObjectInit, this.instrArr)) continue;
                found = true;
                clazz.setMethodSpecial(i);
                ++this.nInstrMethods;
            }
            if (!found) continue;
            ++this.nInstrClasses;
            this.instrClasses.add(clazz);
        }
        Object[] res = this.createInstrumentedMethodPack();
        this.operationCode = 1;
        return res;
    }

    protected void setAllUnprofiledClassStatusArray(boolean[] currentUnprofiledClassStatusArray) {
        int len = currentUnprofiledClassStatusArray.length;
        if (this.allUnprofiledClassStatusArray == null || this.allUnprofiledClassStatusArray.length < len) {
            boolean[] old = this.allUnprofiledClassStatusArray;
            this.allUnprofiledClassStatusArray = new boolean[len];
            if (old != null) {
                System.arraycopy(old, 0, this.allUnprofiledClassStatusArray, 0, old.length);
            }
        }
        for (int i = 0; i < len; ++i) {
            if (!currentUnprofiledClassStatusArray[i]) continue;
            this.allUnprofiledClassStatusArray[i] = true;
        }
    }

    @Override
    protected byte[] instrumentMethod(DynamicClassInfo clazz, int methodIdx) {
        return InstrumentationFactory.instrumentForMemoryProfiling(this, clazz, methodIdx, this.allUnprofiledClassStatusArray, this.injType, this.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), clazz, methodIdx), this.instrFilter, !this.instrObjectInit, this.instrArr);
    }

    @Override
    protected boolean classNeedsInstrumentation(ClassInfo clazz) {
        if (clazz == null) {
            return false;
        }
        if (!this.instrObjectInit || this.instrArr) {
            return true;
        }
        return this.instrObjectInit && "java/lang/Object".equals(clazz.getName()) && clazz.getLoaderId() <= 0;
    }

    @Override
    protected boolean methodNeedsInstrumentation(ClassInfo clazz, int methodIdx) {
        boolean ni = this.hasNewOpcodes(clazz, methodIdx, !this.instrObjectInit, this.instrArr, this.instrFilter);
        boolean pp = this.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), clazz, methodIdx).length > 0;
        boolean oi = this.instrObjectInit && ObjLivenessMethodInstrumentor.isObjectConstructor(clazz, methodIdx);
        return ni || pp || oi;
    }

    @Override
    protected boolean methodNeedsRewriting(DynamicClassInfo clazz, int methodIdx) {
        if (this.operationCode == 1) {
            return clazz.isMethodInstrumented(methodIdx);
        }
        boolean res = clazz.isMethodSpecial(methodIdx);
        clazz.unsetMethodSpecial(methodIdx);
        return res;
    }

    static boolean isObjectConstructor(ClassInfo clazz, int methodIdx) {
        return "java/lang/Object".equals(clazz.getName()) && clazz.getLoaderId() <= 0 && "<init>".equals(clazz.getMethodName(methodIdx));
    }

    class MethodScanerForBannedInstantiations
    extends SingleMethodScaner {
        protected boolean[] unprofiledClassStatusArray;

        MethodScanerForBannedInstantiations() {
        }

        void setUnprofiledClassStatusArray(boolean[] v) {
            this.unprofiledClassStatusArray = v;
        }

        boolean hasNewOpcodes(boolean checkForOpcNew, boolean checkForOpcNewArray) {
            if (!checkForOpcNew && !checkForOpcNewArray) {
                return false;
            }
            int loaderId = this.clazz.getLoaderId();
            for (int bci = 0; bci < this.bytecodesLength; bci += this.opcodeLength(bci)) {
                int arrayClassId;
                BaseClassInfo refClazz;
                int classId;
                int bc = this.bytecodes[bci] & 0xFF;
                if (bc == 187 && checkForOpcNew || bc == 189 || bc == 197 && checkForOpcNewArray) {
                    int classCPIdx = this.getU2(bci + 1);
                    String refClassName = this.clazz.getRefClassName(classCPIdx);
                    BaseClassInfo refClazz2 = bc == 187 ? ObjLivenessMethodInstrumentor.this.javaClassOrPlaceholderForName(refClassName, loaderId) : (bc == 189 ? ObjLivenessMethodInstrumentor.this.javaClassForObjectArrayType(refClassName) : ObjLivenessMethodInstrumentor.this.lookupSpecialClass(refClassName));
                    int classId2 = refClazz2.getInstrClassId();
                    if (classId2 == -1 || this.unprofiledClassStatusArray.length <= classId2 || !this.unprofiledClassStatusArray[classId2]) continue;
                    return true;
                }
                if (bc != 188 || !checkForOpcNewArray || (classId = (refClazz = ObjLivenessMethodInstrumentor.this.javaClassForPrimitiveArrayType(arrayClassId = this.getByte(bci + 1))).getInstrClassId()) == -1 || !this.unprofiledClassStatusArray[classId]) continue;
                return true;
            }
            return false;
        }
    }
}

