# This file has been autogenerated by the pywayland scanner

# Copyright 2019 Sebastian Wick
# Copyright 2019 Erwin Burema
# Copyright 2020 AMD
# Copyright 2020-2024 Collabora, Ltd.
# Copyright 2024 Xaver Hugl
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wp_image_description_v1 import WpImageDescriptionV1


class WpColorManagementSurfaceV1(Interface):
    """Color management extension to a surface

    A :class:`WpColorManagementSurfaceV1` allows the client to set the color
    space and HDR properties of a surface.

    If the :class:`~pywayland.protocol.wayland.WlSurface` associated with the
    :class:`WpColorManagementSurfaceV1` is destroyed, the
    :class:`WpColorManagementSurfaceV1` object becomes inert.
    """

    name = "wp_color_management_surface_v1"
    version = 2

    class error(enum.IntEnum):
        render_intent = 0
        image_description = 1
        inert = 2


class WpColorManagementSurfaceV1Proxy(Proxy[WpColorManagementSurfaceV1]):
    interface = WpColorManagementSurfaceV1

    @WpColorManagementSurfaceV1.request()
    def destroy(self) -> None:
        """Destroy the color management interface for a surface

        Destroy the :class:`WpColorManagementSurfaceV1` object and do the same
        as unset_image_description.
        """
        self._marshal(0)
        self._destroy()

    @WpColorManagementSurfaceV1.request(
        Argument(ArgumentType.Object, interface=WpImageDescriptionV1),
        Argument(ArgumentType.Uint),
    )
    def set_image_description(self, image_description: WpImageDescriptionV1, render_intent: int) -> None:
        """Set the surface image description

        If this protocol object is inert, the protocol error inert is raised.

        Set the image description of the underlying surface. The image
        description and rendering intent are double-buffered state, see
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.

        It is the client's responsibility to understand the image description
        it sets on a surface, and to provide content that matches that image
        description. Compositors might convert images to match their own or any
        other image descriptions.

        Image descriptions which are not ready (see
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`)
        are forbidden in this request, and in such case the protocol error
        image_description is raised.

        All image descriptions which are ready (see
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`)
        are allowed and must always be accepted by the compositor.

        When an image description is set on a surface, it establishes an
        explicit link between surface pixel values and surface colorimetry.
        This link may be undefined for some pixel values, see the image
        description creator interfaces for the conditions. Non-finite floating-
        point values (NaN, Inf) always have an undefined colorimetry.

        A rendering intent provides the client's preference on how surface
        colorimetry should be mapped to each output. The render_intent value
        must be one advertised by the compositor with
        :func:`WpColorManagerV1.render_intent()
        <pywayland.protocol.color_management_v1.WpColorManagerV1.render_intent>`
        event, otherwise the protocol error render_intent is raised.

        By default, a surface does not have an associated image description nor
        a rendering intent. The handling of color on such surfaces is
        compositor implementation defined. Compositors should handle such
        surfaces as sRGB, but may handle them differently if they have specific
        requirements.

        Setting the image description has copy semantics; after this request,
        the image description can be immediately destroyed without affecting
        the pending state of the surface.

        :param image_description:
        :type image_description:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        :param render_intent:
            rendering intent
        :type render_intent:
            `ArgumentType.Uint`
        """
        self._marshal(1, image_description, render_intent)

    @WpColorManagementSurfaceV1.request()
    def unset_image_description(self) -> None:
        """Remove the surface image description

        If this protocol object is inert, the protocol error inert is raised.

        This request removes any image description from the surface. See
        set_image_description for how a compositor handles a surface without an
        image description. This is double-buffered state, see
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.
        """
        self._marshal(2)


class WpColorManagementSurfaceV1Resource(Resource):
    interface = WpColorManagementSurfaceV1


class WpColorManagementSurfaceV1Global(Global):
    interface = WpColorManagementSurfaceV1


WpColorManagementSurfaceV1._gen_c()
WpColorManagementSurfaceV1.proxy_class = WpColorManagementSurfaceV1Proxy
WpColorManagementSurfaceV1.resource_class = WpColorManagementSurfaceV1Resource
WpColorManagementSurfaceV1.global_class = WpColorManagementSurfaceV1Global
