/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import h.ST_Agedgeinfo_t;
import h.ST_bezier;
import h.ST_pointf;
import h.ST_splines;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.jsondiagram.Arrow;
import net.sourceforge.plantuml.jsondiagram.Mirror;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class GitCurve {
    private final List<XPoint2D> points = new ArrayList<XPoint2D>();
    private final Mirror xMirror;
    private final XPoint2D sp;
    private final XPoint2D ep;

    public GitCurve(ST_Agedgeinfo_t data, Mirror xMirror) {
        this.xMirror = xMirror;
        ST_splines splines = data.spl;
        if (splines.size != 1) {
            throw new IllegalStateException();
        }
        ST_bezier beziers = splines.list.get__(0);
        for (int i = 0; i < beziers.size; ++i) {
            XPoint2D pt = this.getPoint(splines, i);
            this.points.add(pt);
        }
        this.sp = beziers.sp.x == 0.0 && beziers.sp.y == 0.0 ? null : new XPoint2D(beziers.sp.x, beziers.sp.y);
        this.ep = beziers.ep.x == 0.0 && beziers.ep.y == 0.0 ? null : new XPoint2D(beziers.ep.x, beziers.ep.y);
    }

    private XPoint2D getPoint(ST_splines splines, int i) {
        ST_bezier beziers = splines.list.get__(0);
        ST_pointf pt = beziers.list.get__(i);
        return new XPoint2D(pt.x, pt.y);
    }

    public void drawCurve(HColor color, UGraphic ug) {
        ug = ug.apply(new UStroke(2.0, 2.0, 1.0));
        UPath path = UPath.none();
        path.moveTo(this.xMirror.invGit(this.points.get(0)));
        for (int i = 1; i < this.points.size(); i += 3) {
            XPoint2D pt2 = this.xMirror.invGit(this.points.get(i));
            XPoint2D pt3 = this.xMirror.invGit(this.points.get(i + 1));
            XPoint2D pt4 = this.xMirror.invGit(this.points.get(i + 2));
            path.cubicTo(pt2, pt3, pt4);
        }
        ug.draw(path);
        if (this.ep != null) {
            XPoint2D last = this.xMirror.invGit(this.points.get(this.points.size() - 1));
            XPoint2D trueEp = this.xMirror.invGit(this.ep);
            new Arrow(last, trueEp).drawArrow(ug.apply(color.bg()));
        }
    }
}

