/*
 * Decompiled with CFR 0.152.
 */
package reder.application.io;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import reder.application.RederMainFrame;
import reder.application.graph.EdgeBank;
import reder.application.graph.LegendBank;
import reder.application.graph.NodeBank;

public class LoadData {
    protected static ArrayList<NodeBank> NodeList;
    protected static ArrayList<EdgeBank> EdgeList;
    private static ArrayList<LegendBank> LegendList;
    protected static ArrayList<String> keyNodeArray;
    private static HashMap keyNodeHash;
    private NodeBank nodeAccount;
    private EdgeBank edgeAccount;
    private String openAddress;
    private String taskProgress;
    private float centroX;
    private float centroY;
    private Color backgroundColor;
    private double zoomInOut;
    private double edgeTarget;
    private double outEdgeTarget;
    private double nodeSpeedLimit;
    private double repulserad;
    private double stiffness;
    private double repelFactor;
    private double outRepelFactor;
    private double perimeterEffect;
    private double centralPull;
    private boolean isResource;

    public LoadData() {
        NodeList = new ArrayList();
        EdgeList = new ArrayList();
        LegendList = new ArrayList();
        keyNodeArray = new ArrayList();
        keyNodeHash = new HashMap();
        this.nodeAccount = null;
        this.openAddress = null;
        this.taskProgress = "running";
        this.backgroundColor = new Color(255, 255, 255);
        this.zoomInOut = 1.0;
        this.edgeTarget = 100.0;
        this.repulserad = 10.0;
        this.outEdgeTarget = 100.0;
        this.stiffness = 100.0;
        this.repelFactor = 100.0;
        this.perimeterEffect = 100.0;
        this.outRepelFactor = 10.0;
        this.nodeSpeedLimit = 100.0;
        this.centralPull = 10.0;
        this.isResource = false;
    }

    public ArrayList<NodeBank> getNodeBank() {
        return NodeList;
    }

    public ArrayList<EdgeBank> getEdgeBank() {
        return EdgeList;
    }

    public ArrayList<LegendBank> getLegendBank() {
        return LegendList;
    }

    public HashMap getKeyNodeHash() {
        return keyNodeHash;
    }

    public ArrayList<String> getKeyNodeArray() {
        return keyNodeArray;
    }

    public String getProgress() {
        return this.taskProgress;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public double getZoomInOut() {
        return this.zoomInOut;
    }

    public double getEdgeTarget() {
        return Math.max(this.edgeTarget, 1.0);
    }

    public double getOutedgeTarget() {
        return Math.max(this.outEdgeTarget, 1.0);
    }

    public double getStiffness() {
        return Math.max(this.stiffness, 1.0);
    }

    public double getRepelFactor() {
        return Math.max(this.repelFactor, 1.0);
    }

    public double getOutsideRepelFactor() {
        return Math.max(this.outRepelFactor, 1.0);
    }

    public double getNodeSpeedLimit() {
        return Math.max(this.nodeSpeedLimit, 1.0);
    }

    public double getPerimeterEffect() {
        return Math.max(this.perimeterEffect, 1.0);
    }

    public double getRepulseRadius() {
        return Math.max(this.repulserad, 1.0);
    }

    public double getCentralPull() {
        return Math.max(this.centralPull, 1.0);
    }

    public void inputAndGo(String openAddress, String fileType, float centroX, float centroY) {
        try {
            String[] fileTest;
            String end;
            this.openAddress = openAddress;
            this.centroX = centroX;
            this.centroY = centroY;
            NodeList.clear();
            NodeList.clear();
            keyNodeHash.clear();
            keyNodeArray.clear();
            if (fileType.equals("default") && ((end = (fileTest = openAddress.split("\\."))[fileTest.length - 1]).equals("reder") || end.equals("dyn"))) {
                this.isResource = false;
                this.loadDefault();
            }
            if (fileType.equals("sif")) {
                this.loadSif();
            }
            if (fileType.equals("nodesAndEdges")) {
                this.loadNodesAndEdges();
            }
            if (fileType.equals("nodes")) {
                this.loadNodes();
            }
            if (fileType.equals("edges")) {
                this.loadEdges();
            }
            if (fileType.equals("sample1")) {
                this.loadSample1();
            }
            if (fileType.equals("xgmml")) {
                this.isResource = false;
                this.loadXgmml();
            }
            if (fileType.equals("resource")) {
                this.isResource = true;
                this.loadXgmml();
            }
        }
        catch (IOException ignore) {
            this.taskProgress = "halt";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDefault() throws IOException {
        File tempFile = File.createTempFile("reder", ".xgmml");
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int n;
            fis = new FileInputStream(this.openAddress);
            fos = new FileOutputStream(tempFile.getPath());
            ZipInputStream zis = new ZipInputStream(fis);
            zis.getNextEntry();
            int BUFSIZ = 4096;
            byte[] inbuf = new byte[4096];
            while ((n = zis.read(inbuf, 0, 4096)) != -1) {
                fos.write(inbuf, 0, n);
            }
            zis.close();
            fis = null;
            fos.close();
            fos = null;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.openAddress = tempFile.getPath();
        this.loadXgmml();
        tempFile.deleteOnExit();
    }

    private void loadNodesAndEdges() throws FileNotFoundException, IOException {
        ArrayList<String> links = new ArrayList<String>();
        ArrayList<String> nodes = new ArrayList<String>();
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        String strLine = br.readLine();
        Pattern iniPattern = Pattern.compile("^(#node_id)([\\s;]+(x)[\\s;]+(y)[\\s;]?)?");
        Pattern endPattern = Pattern.compile("^(#node_a)[\\s;]+(node_b)");
        Matcher matcher = iniPattern.matcher(strLine);
        if (matcher.find()) {
            while (strLine != null && !(matcher = endPattern.matcher(strLine = br.readLine())).find()) {
                nodes.add(strLine);
            }
            if (nodes.size() > 0) {
                this.loadBasicNodes(nodes);
            }
        }
        if ((matcher = endPattern.matcher(strLine)).find()) {
            while (strLine != null && (strLine = br.readLine()) != null) {
                links.add(strLine);
            }
            if (links.size() > 0) {
                this.loadBasicLinks(links);
            }
        }
        br.close();
        in.close();
    }

    private void loadEdges() throws FileNotFoundException, IOException {
        ArrayList<String> links = new ArrayList<String>();
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        String strLine = br.readLine();
        while (strLine != null) {
            strLine = br.readLine();
            links.add(strLine);
        }
        this.loadBanksViaLinks(links);
        br.close();
        in.close();
    }

    private void loadNodes() throws FileNotFoundException, IOException {
        ArrayList<String> nodes = new ArrayList<String>();
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        String strLine = br.readLine();
        while (strLine != null) {
            strLine = br.readLine();
            nodes.add(strLine);
        }
        this.loadBanksViaNodes(nodes);
        br.close();
        in.close();
    }

    private void loadSif() throws FileNotFoundException, IOException {
        ArrayList<String> links = new ArrayList<String>();
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        String strLine = br.readLine();
        while (strLine != null) {
            strLine = br.readLine();
            links.add(strLine);
        }
        this.loadBanksViaSif(links);
        br.close();
        in.close();
    }

    private void loadBanksViaSif(ArrayList<String> links) {
        Pattern edgePattern = Pattern.compile("^([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([^\\s]+)[\\s;]?");
        try {
            this.nodeAccount = null;
            for (int i = 0; i < links.size(); ++i) {
                if (links.get(i) == null) continue;
                Matcher matcher = edgePattern.matcher(links.get(i));
                if (matcher.find()) {
                    NodeBank nodeAccount2;
                    int nodeB;
                    NodeBank nodeAccount1;
                    int nodeA;
                    if (NodeList.isEmpty()) {
                        NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                        nodeA = NodeList.size() - 1;
                        keyNodeHash.put(matcher.group(1), nodeA);
                        keyNodeArray.add(matcher.group(1));
                        nodeAccount1 = NodeList.get(nodeA);
                        NodeList.add(new NodeBank(matcher.group(3), NodeList.size()));
                        nodeB = NodeList.size() - 1;
                        keyNodeHash.put(matcher.group(3), nodeB);
                        keyNodeArray.add(matcher.group(3));
                        nodeAccount2 = NodeList.get(nodeB);
                    } else {
                        if (!keyNodeHash.containsKey(matcher.group(1))) {
                            NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                            nodeA = NodeList.size() - 1;
                            keyNodeHash.put(matcher.group(1), nodeA);
                            keyNodeArray.add(matcher.group(1));
                            nodeAccount1 = NodeList.get(nodeA);
                        } else {
                            nodeA = (Integer)keyNodeHash.get(matcher.group(1));
                            nodeAccount1 = NodeList.get(nodeA);
                        }
                        if (!keyNodeHash.containsKey(matcher.group(3))) {
                            NodeList.add(new NodeBank(matcher.group(3), NodeList.size()));
                            nodeB = NodeList.size() - 1;
                            keyNodeHash.put(matcher.group(3), nodeB);
                            keyNodeArray.add(matcher.group(3));
                            nodeAccount2 = NodeList.get(nodeB);
                        } else {
                            nodeB = (Integer)keyNodeHash.get(matcher.group(3));
                            nodeAccount2 = NodeList.get(nodeB);
                        }
                    }
                    boolean depositoParceiroA = nodeAccount1.addParceiro(nodeB);
                    boolean depositoParceiroB = nodeAccount2.addParceiro(nodeA);
                    if (!depositoParceiroA || !depositoParceiroB) continue;
                    EdgeList.add(new EdgeBank(nodeA, nodeB, EdgeList.size()));
                    continue;
                }
                Pattern nodePattern = Pattern.compile("^([^\\s]+)");
                matcher = nodePattern.matcher(links.get(i));
                if (!matcher.find()) continue;
                if (NodeList.isEmpty()) {
                    NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                    int node = NodeList.size() - 1;
                    keyNodeHash.put(matcher.group(1), node);
                    keyNodeArray.add(matcher.group(1));
                    continue;
                }
                if (keyNodeHash.containsKey(matcher.group(1))) continue;
                NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                int node = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(1), node);
                keyNodeArray.add(matcher.group(1));
            }
            this.taskProgress = "endload";
        }
        catch (Exception ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadXgmml() {
        SAXBuilder parser = new SAXBuilder();
        Namespace ns = Namespace.getNamespace("http://www.cs.rpi.edu/XGMML");
        try {
            Document doc;
            if (this.isResource) {
                InputStream in = this.getClass().getResourceAsStream(this.openAddress);
                doc = parser.build(in);
            } else {
                doc = parser.build(this.openAddress);
            }
            Element root = doc.getRootElement();
            List<Element> graphAtt = root.getChildren("att", ns);
            float dX = this.centroX;
            float dY = this.centroY;
            for (int i = 0; i < graphAtt.size(); ++i) {
                Element att = graphAtt.get(i);
                String name = att.getAttributeValue("name");
                String value = att.getAttributeValue("value");
                if (name.equals("backgroundColor")) {
                    try {
                        this.backgroundColor = RederMainFrame.HexToColor(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("GRAPH_VIEW_ZOOM")) {
                    try {
                        this.zoomInOut = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("GRAPH_VIEW_CENTER_X")) {
                    try {
                        dX = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("GRAPH_VIEW_CENTER_Y")) {
                    try {
                        dY = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("RELAX_EDGETARGET")) {
                    try {
                        this.edgeTarget = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("RELAX_OUTEDGETARGET")) {
                    try {
                        this.outEdgeTarget = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("RELAX_STIFFNESS")) {
                    try {
                        this.stiffness = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("RELAX_REPEL")) {
                    try {
                        this.repelFactor = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("RELAX_REPULSERAD")) {
                    try {
                        this.repulserad = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("RELAX_OUTREPEL")) {
                    try {
                        this.outRepelFactor = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("RELAX_SPEED")) {
                    try {
                        this.nodeSpeedLimit = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equals("RELAX_PERIMETEREFFECT")) {
                    try {
                        this.perimeterEffect = Float.parseFloat(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (!name.equals("RELAX_CENTRALPULL")) continue;
                try {
                    this.centralPull = Float.parseFloat(value);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            dX -= this.centroX;
            dY -= this.centroY;
            ArrayList<Float> sizevec = new ArrayList<Float>();
            ArrayList<Color> colvec = new ArrayList<Color>();
            ArrayList<String> shapevec = new ArrayList<String>();
            ArrayList<String> labvec = new ArrayList<String>();
            float size = 0.0f;
            float legbend = 85.0f;
            float interspace = 0.0f;
            int ftsize = 0;
            String labx = null;
            float labxdist = 0.0f;
            String position = null;
            float dxborder = 0.0f;
            float dyborder = 0.0f;
            boolean isVertical = false;
            float edgelen = 50.0f;
            List<Element> legs = root.getChildren("legend", ns);
            for (int i = 0; i < legs.size(); ++i) {
                String label3;
                Element member;
                Color color;
                String value;
                Element leg = legs.get(i);
                String legtype = leg.getAttributeValue("legtype");
                List<Element> legAtt = leg.getChildren("att", ns);
                for (int j = 0; j < legAtt.size(); ++j) {
                    Element att = legAtt.get(j);
                    String name = att.getAttributeValue("name");
                    value = att.getAttributeValue("value");
                    if (name.equals("size")) {
                        try {
                            size = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("bend")) {
                        try {
                            legbend = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("intersp")) {
                        try {
                            interspace = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("ftsize")) {
                        try {
                            ftsize = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("labx")) {
                        labx = value;
                        continue;
                    }
                    if (name.equals("labxdist")) {
                        try {
                            labxdist = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("position")) {
                        position = value;
                        continue;
                    }
                    if (name.equals("legdx")) {
                        try {
                            dxborder = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("legdy")) {
                        try {
                            dyborder = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("vertical")) {
                        try {
                            isVertical = Boolean.parseBoolean(value);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!name.equals("edgelen")) continue;
                    try {
                        edgelen = Float.parseFloat(value);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                sizevec.clear();
                colvec.clear();
                shapevec.clear();
                labvec.clear();
                List<Element> members = leg.getChildren("member", ns);
                if (legtype.equals("edgewidth") || legtype.equals("nodesize")) {
                    for (int j = 0; j < members.size(); ++j) {
                        color = Color.BLACK;
                        float value2 = 0.0f;
                        member = members.get(j);
                        label3 = member.getAttributeValue("label");
                        try {
                            value2 = Float.parseFloat(member.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            color = RederMainFrame.HexToColor(member.getAttributeValue("color"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        labvec.add(label3);
                        sizevec.add(Float.valueOf(value2));
                        colvec.add(color);
                    }
                    this.addLegendSize(sizevec, labvec, colvec, interspace, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype, edgelen);
                    continue;
                }
                if (legtype.equals("nodecolor") || legtype.equals("edgecolor")) {
                    for (int j = 0; j < members.size(); ++j) {
                        Color value3 = Color.BLACK;
                        Element member2 = members.get(j);
                        String label2 = member2.getAttributeValue("label");
                        try {
                            value3 = RederMainFrame.HexToColor(member2.getText());
                        }
                        catch (NumberFormatException label3) {
                            // empty catch block
                        }
                        labvec.add(label2);
                        colvec.add(value3);
                    }
                    this.addLegendColor(colvec, labvec, size, legbend, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype);
                    continue;
                }
                if (!legtype.equals("nodeshape") && !legtype.equals("edgeshape")) continue;
                for (int j = 0; j < members.size(); ++j) {
                    color = Color.BLACK;
                    member = members.get(j);
                    label3 = member.getAttributeValue("label");
                    try {
                        color = RederMainFrame.HexToColor(member.getAttributeValue("color"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    value = member.getText();
                    labvec.add(label3);
                    colvec.add(color);
                    shapevec.add(value);
                }
                this.addLegendShape(shapevec, labvec, colvec, size, interspace, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype);
            }
            HashMap<String, Integer> xmlKeyHash = new HashMap<String, Integer>();
            List<Element> xmlNodeList = root.getChildren("node", ns);
            for (int i = 0; i < xmlNodeList.size(); ++i) {
                float width;
                float y;
                float x;
                float w;
                float h;
                boolean b;
                Element graphics;
                Element node = xmlNodeList.get(i);
                String label = node.getAttributeValue("label");
                String id = node.getAttributeValue("id");
                String corLine = "";
                String corFill = "";
                String widthg = "";
                String yg = "";
                String xg = "";
                String wg = "";
                String hg = "";
                String nodeShape = "";
                try {
                    graphics = node.getChild("graphics", ns);
                }
                catch (Exception ignore) {
                    graphics = null;
                }
                if (graphics != null) {
                    nodeShape = graphics.getAttributeValue("type");
                    hg = graphics.getAttributeValue("h");
                    wg = graphics.getAttributeValue("w");
                    xg = graphics.getAttributeValue("x");
                    yg = graphics.getAttributeValue("y");
                    widthg = graphics.getAttributeValue("width");
                    corFill = graphics.getAttributeValue("fill");
                    corLine = graphics.getAttributeValue("outline");
                }
                if (!(b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", nodeShape))) {
                    nodeShape = "ELLIPSE";
                }
                Color fill = new Color(255, 102, 102);
                try {
                    fill = RederMainFrame.HexToColor(corFill);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Color outline = new Color(255, 0, 0);
                try {
                    outline = RederMainFrame.HexToColor(corLine);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    h = Float.parseFloat(hg);
                    w = Float.parseFloat(wg);
                    x = Float.parseFloat(xg);
                    y = Float.parseFloat(yg);
                    width = Float.parseFloat(widthg);
                }
                catch (NumberFormatException ignore) {
                    w = 20.0f;
                    h = 20.0f;
                    width = 1.0f;
                    x = (float)Math.random() * 600.0f;
                    y = (float)Math.random() * 400.0f;
                }
                List<Element> attributes = node.getChildren("att", ns);
                String alias = label;
                boolean nodeIsGroup = false;
                String groupComponets = "";
                int groupCompNumber = 0;
                boolean nodeIsContainer = false;
                boolean isContainerAnchored = false;
                boolean isContainerHided = false;
                boolean isContainerTransparent = false;
                String nodeLineType = "SOLID";
                boolean nodeGradient = false;
                float bend = 50.0f;
                Font font = new Font("SansSerif", 0, 12);
                double nodeWeight = 0.0;
                float fontOffsetX = 0.0f;
                float fontOffsetY = 0.0f;
                String fontPositionX = "right";
                String fontPositionY = "top";
                float nodeSize = (h + w) / 2.0f;
                Color labelColor = new Color(51, 51, 51);
                double relativeSize = 1.0;
                boolean spot = false;
                double spoteffect = 100.0;
                double spotrange = 100.0;
                int spotdirection = 1;
                boolean isAnchored = false;
                for (int j = 0; j < attributes.size(); ++j) {
                    Element att = attributes.get(j);
                    String name = att.getAttributeValue("name");
                    String value = att.getAttributeValue("value");
                    if (name.equals("group")) {
                        groupComponets = value;
                        nodeIsGroup = true;
                        continue;
                    }
                    if (name.equals("componets")) {
                        try {
                            groupCompNumber = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("container.rsize")) {
                        nodeIsContainer = true;
                        try {
                            relativeSize = Double.parseDouble(value);
                            relativeSize /= 100.0;
                            if (!(relativeSize < 0.0)) continue;
                            relativeSize = 1.0;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("container.status")) {
                        if (value.equals("TTT")) {
                            isContainerAnchored = true;
                            isContainerHided = true;
                            isContainerTransparent = true;
                            continue;
                        }
                        if (value.equals("TFT")) {
                            isContainerAnchored = true;
                            isContainerHided = false;
                            isContainerTransparent = true;
                            continue;
                        }
                        if (value.equals("FTT")) {
                            isContainerAnchored = false;
                            isContainerHided = true;
                            isContainerTransparent = true;
                            continue;
                        }
                        if (value.equals("FFT")) {
                            isContainerAnchored = false;
                            isContainerHided = false;
                            isContainerTransparent = true;
                            continue;
                        }
                        if (value.equals("TTF")) {
                            isContainerAnchored = true;
                            isContainerHided = true;
                            isContainerTransparent = false;
                            continue;
                        }
                        if (value.equals("TFF")) {
                            isContainerAnchored = true;
                            isContainerHided = false;
                            isContainerTransparent = false;
                            continue;
                        }
                        if (value.equals("FTF")) {
                            isContainerAnchored = false;
                            isContainerHided = true;
                            isContainerTransparent = false;
                            continue;
                        }
                        if (!value.equals("FFF")) continue;
                        isContainerAnchored = false;
                        isContainerHided = false;
                        isContainerTransparent = false;
                        continue;
                    }
                    if (name.equals("gradient")) {
                        if (!value.equals("true")) continue;
                        nodeGradient = true;
                        continue;
                    }
                    if (name.equals("alias")) {
                        alias = value;
                        continue;
                    }
                    if (name.equals("line.type")) {
                        b = Pattern.matches("SOLID|DASHED|LONG_DASH|DOTTED", value);
                        if (!b) continue;
                        nodeLineType = value;
                        continue;
                    }
                    if (name.equals("node.bend")) {
                        try {
                            bend = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("node.weight")) {
                        try {
                            nodeWeight = Double.parseDouble(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("node.labelColor")) {
                        try {
                            labelColor = RederMainFrame.HexToColor(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("node.font")) {
                        try {
                            String[] splitFont = value.split("-");
                            String fontName = splitFont[0];
                            int fontType = Integer.parseInt(splitFont[1]);
                            int fontSize = Integer.parseInt(splitFont[2]);
                            font = new Font(fontName, fontType, fontSize);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (name.equals("font.x.position")) {
                        try {
                            fontPositionX = value;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (name.equals("font.y.position")) {
                        try {
                            fontPositionY = value;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (name.equals("font.x.offset")) {
                        try {
                            fontOffsetX = Float.parseFloat(value);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (name.equals("font.y.offset")) {
                        try {
                            fontOffsetY = Float.parseFloat(value);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (name.equals("spot")) {
                        spot = true;
                        continue;
                    }
                    if (name.equals("spoteffect")) {
                        try {
                            spoteffect = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("spotrange")) {
                        try {
                            spotrange = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equals("spotdirection")) {
                        try {
                            spotdirection = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (!name.equals("anchored")) continue;
                    isAnchored = true;
                }
                NodeList.add(new NodeBank(label, NodeList.size()));
                keyNodeHash.put(label, i);
                keyNodeArray.add(label);
                xmlKeyHash.put(id, i);
                this.nodeAccount = NodeList.get(i);
                this.nodeAccount.setAsGroup(nodeIsGroup);
                this.nodeAccount.setGroupComponents(groupComponets);
                this.nodeAccount.setGroupCompNumber(groupCompNumber);
                this.nodeAccount.setContainer(nodeIsContainer);
                this.nodeAccount.setAnchored(isContainerAnchored || isAnchored);
                this.nodeAccount.setContainerHided(isContainerHided);
                this.nodeAccount.setContainerTransparent(isContainerTransparent);
                this.nodeAccount.setRelativeSize(relativeSize);
                this.nodeAccount.setNodeGradient(nodeGradient);
                this.nodeAccount.setNodeShape(nodeShape);
                this.nodeAccount.setNodeLineType(nodeLineType);
                this.nodeAccount.setNode(x - dX, y - dY, h, w);
                this.nodeAccount.setNodeColor(fill);
                this.nodeAccount.setNodeLineWidth(width);
                this.nodeAccount.setNodeLineColor(outline);
                this.nodeAccount.setFont(font);
                this.nodeAccount.setFontColor(labelColor);
                this.nodeAccount.setFontPositionX(fontPositionX);
                this.nodeAccount.setFontPositionY(fontPositionY);
                this.nodeAccount.setFontOffsetX(fontOffsetX);
                this.nodeAccount.setFontOffsetY(fontOffsetY);
                this.nodeAccount.setAliases(alias);
                this.nodeAccount.setNodeBend(bend);
                this.nodeAccount.setNodeSize(nodeSize);
                this.nodeAccount.setWeight(nodeWeight);
                if (!spot) continue;
                this.nodeAccount.setAsSpot();
                this.nodeAccount.setSpotEffect(spoteffect);
                this.nodeAccount.setSpotRange(spotrange);
                this.nodeAccount.setSpotDirection(spotdirection);
            }
            List<Element> xmlEdgeList = root.getChildren("edge", ns);
            int cont = 0;
            for (int i = 0; i < xmlEdgeList.size(); ++i) {
                Color fill;
                float width;
                Element graphics;
                int direction;
                Element edge = xmlEdgeList.get(i);
                String idSource = edge.getAttributeValue("source");
                String idTarget = edge.getAttributeValue("target");
                String textDirection = edge.getAttributeValue("direction");
                try {
                    direction = Integer.parseInt(textDirection);
                }
                catch (NumberFormatException ignore) {
                    direction = 0;
                }
                List<Element> attributes = edge.getChildren("att", ns);
                double edgeWeight = 0.0;
                float arrowlen = 2.0f;
                float arrowangle = 45.0f;
                boolean defaultNesting = true;
                for (int j = 0; j < attributes.size(); ++j) {
                    Element att = attributes.get(j);
                    String name = att.getAttributeValue("name");
                    String value = att.getAttributeValue("value");
                    if (name.equals("weight")) {
                        try {
                            edgeWeight = Double.parseDouble(value);
                        }
                        catch (NumberFormatException x) {
                            // empty catch block
                        }
                    }
                    if (name.equals("arrowlength")) {
                        try {
                            arrowlen = Float.parseFloat(value);
                        }
                        catch (NumberFormatException x) {
                            // empty catch block
                        }
                    }
                    if (name.equals("arrowangle")) {
                        try {
                            arrowangle = Float.parseFloat(value);
                        }
                        catch (NumberFormatException x) {
                            // empty catch block
                        }
                    }
                    if (!name.equals("defaultnesting")) continue;
                    defaultNesting = !value.equals("false");
                }
                try {
                    graphics = edge.getChild("graphics", ns);
                }
                catch (Exception ignore) {
                    graphics = null;
                }
                String texto1 = "1.0";
                String texto2 = "#9393ACFF";
                String texto3 = "SOLID";
                if (graphics != null) {
                    String tp = graphics.getAttributeValue("width");
                    if (tp != null) {
                        texto1 = tp;
                    }
                    if ((tp = graphics.getAttributeValue("fill")) != null) {
                        texto2 = tp;
                    }
                    if ((tp = graphics.getAttributeValue("edgeLineType")) != null) {
                        texto3 = tp;
                    }
                }
                try {
                    width = Float.parseFloat(texto1);
                }
                catch (NumberFormatException ignore) {
                    width = 1.0f;
                }
                try {
                    fill = RederMainFrame.HexToColor(texto2);
                }
                catch (NumberFormatException ignore) {
                    fill = new Color(255, 0, 0);
                }
                String edgeLineType = texto3;
                int intSource = (Integer)xmlKeyHash.get(idSource);
                int intTarget = (Integer)xmlKeyHash.get(idTarget);
                int n = EdgeList.size();
                boolean flagFound = false;
                for (int j = 0; j < n && !flagFound; ++j) {
                    this.edgeAccount = EdgeList.get(j);
                    if ((this.edgeAccount.getA() != intSource || this.edgeAccount.getB() != intTarget) && (this.edgeAccount.getA() != intTarget || this.edgeAccount.getB() != intSource)) continue;
                    flagFound = true;
                }
                if (flagFound) continue;
                boolean c1 = !NodeList.get(intSource).isContainer();
                boolean c2 = NodeList.get(intTarget).isContainer();
                if (c1 && c2) {
                    EdgeList.add(new EdgeBank(intSource, intTarget, EdgeList.size()));
                    EdgeList.get(cont).setDefaultEdgeAssignment(false);
                } else {
                    EdgeList.add(new EdgeBank(intSource, intTarget, EdgeList.size()));
                }
                this.edgeAccount = EdgeList.get(cont);
                this.edgeAccount.setLine(width, edgeLineType);
                this.edgeAccount.setArrowDirection(direction);
                this.edgeAccount.setEdgeColor(fill);
                this.edgeAccount.setWeight(edgeWeight);
                this.edgeAccount.setArrowLength(arrowlen);
                this.edgeAccount.setArrowAngle(arrowangle);
                this.edgeAccount.setDefaultEdgeAssignment(defaultNesting);
                this.nodeAccount = NodeList.get(intTarget);
                this.nodeAccount.addParceiro(intSource);
                this.nodeAccount = NodeList.get(intSource);
                this.nodeAccount.addParceiro(intTarget);
                ++cont;
            }
            this.taskProgress = "endload";
        }
        catch (IOException | JDOMException ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadBasicNodes(ArrayList<String> nodes) {
        Pattern nodePattern = Pattern.compile("^([^\\s]+)[\\s;]?+([^\\s]+)?[\\s;]?+([^\\s]+)?[\\s;]?");
        this.nodeAccount = null;
        for (int i = 0; i < nodes.size(); ++i) {
            int node;
            Matcher matcher;
            if (nodes.get(i) == null || !(matcher = nodePattern.matcher(nodes.get(i))).find()) continue;
            boolean flag = false;
            if (NodeList.isEmpty()) {
                NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                node = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(1), node);
                keyNodeArray.add(matcher.group(1));
                flag = true;
            } else if (!keyNodeHash.containsKey(matcher.group(1))) {
                NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                node = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(1), node);
                keyNodeArray.add(matcher.group(1));
                flag = true;
            }
            if (!flag) continue;
            node = NodeList.size() - 1;
            this.nodeAccount = NodeList.get(node);
            float x = (float)Math.random() * 600.0f;
            float y = (float)Math.random() * 400.0f;
            String sx = matcher.group(2);
            String sy = matcher.group(3);
            try {
                if (sx != null) {
                    x = Float.parseFloat(sx);
                }
                if (sy != null) {
                    y = Float.parseFloat(sy);
                }
            }
            catch (NumberFormatException ignore) {
                x = (float)Math.random() * 600.0f;
                y = (float)Math.random() * 400.0f;
            }
            this.nodeAccount.setNode(x, y);
        }
    }

    private void loadBasicLinks(ArrayList<String> links) {
        Pattern edgePattern = Pattern.compile("^([^\\s]+)[\\s;]+([^\\s]+)");
        try {
            for (int i = 0; i < links.size(); ++i) {
                Matcher matcher;
                if (links.get(i) == null || !(matcher = edgePattern.matcher(links.get(i))).find()) continue;
                try {
                    int nodeA = (Integer)keyNodeHash.get(matcher.group(1));
                    int nodeB = (Integer)keyNodeHash.get(matcher.group(2));
                    NodeBank nodeAccount1 = NodeList.get(nodeA);
                    NodeBank nodeAccount2 = NodeList.get(nodeB);
                    boolean depositoParceiroA = nodeAccount1.addParceiro(nodeB);
                    boolean depositoParceiroB = nodeAccount2.addParceiro(nodeA);
                    if (!depositoParceiroA || !depositoParceiroB) continue;
                    EdgeList.add(new EdgeBank(nodeA, nodeB, EdgeList.size()));
                    this.edgeAccount = EdgeList.get(EdgeList.size() - 1);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.taskProgress = "endload";
        }
        catch (Exception ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadBanksViaNodes(ArrayList<String> nodes) {
        Pattern nodePattern = Pattern.compile("^([^\\s]+)");
        try {
            this.nodeAccount = null;
            for (int i = 0; i < nodes.size(); ++i) {
                int intNodeID;
                Matcher matcher;
                if (nodes.get(i) == null || !(matcher = nodePattern.matcher(nodes.get(i))).find()) continue;
                if (NodeList.isEmpty()) {
                    NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                    intNodeID = NodeList.size() - 1;
                    keyNodeHash.put(matcher.group(1), intNodeID);
                    keyNodeArray.add(matcher.group(1));
                    continue;
                }
                if (keyNodeHash.containsKey(matcher.group(1))) continue;
                NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                intNodeID = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(1), intNodeID);
                keyNodeArray.add(matcher.group(1));
            }
            this.taskProgress = "endload";
        }
        catch (Exception e) {
            this.taskProgress = "halt";
        }
    }

    private void loadBanksViaLinks(ArrayList<String> links) {
        Pattern edgePattern = Pattern.compile("^([^\\s]+)[\\s;]+([^\\s]+)");
        try {
            this.nodeAccount = null;
            for (int i = 0; i < links.size(); ++i) {
                if (links.get(i) == null) continue;
                Matcher matcher = edgePattern.matcher(links.get(i));
                if (matcher.find()) {
                    NodeBank nodeAccount2;
                    int nodeB;
                    NodeBank nodeAccount1;
                    int nodeA;
                    if (NodeList.isEmpty()) {
                        NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                        nodeA = NodeList.size() - 1;
                        keyNodeHash.put(matcher.group(1), nodeA);
                        keyNodeArray.add(matcher.group(1));
                        nodeAccount1 = NodeList.get(nodeA);
                        NodeList.add(new NodeBank(matcher.group(2), NodeList.size()));
                        nodeB = NodeList.size() - 1;
                        keyNodeHash.put(matcher.group(2), nodeB);
                        keyNodeArray.add(matcher.group(2));
                        nodeAccount2 = NodeList.get(nodeB);
                    } else {
                        if (!keyNodeHash.containsKey(matcher.group(1))) {
                            NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                            nodeA = NodeList.size() - 1;
                            keyNodeHash.put(matcher.group(1), nodeA);
                            keyNodeArray.add(matcher.group(1));
                            nodeAccount1 = NodeList.get(nodeA);
                        } else {
                            nodeA = (Integer)keyNodeHash.get(matcher.group(1));
                            nodeAccount1 = NodeList.get(nodeA);
                        }
                        if (!keyNodeHash.containsKey(matcher.group(2))) {
                            NodeList.add(new NodeBank(matcher.group(2), NodeList.size()));
                            nodeB = NodeList.size() - 1;
                            keyNodeHash.put(matcher.group(2), nodeB);
                            keyNodeArray.add(matcher.group(2));
                            nodeAccount2 = NodeList.get(nodeB);
                        } else {
                            nodeB = (Integer)keyNodeHash.get(matcher.group(2));
                            nodeAccount2 = NodeList.get(nodeB);
                        }
                    }
                    boolean depositoParceiroA = nodeAccount1.addParceiro(nodeB);
                    boolean depositoParceiroB = nodeAccount2.addParceiro(nodeA);
                    if (!depositoParceiroA || !depositoParceiroB) continue;
                    EdgeList.add(new EdgeBank(nodeA, nodeB, EdgeList.size()));
                    continue;
                }
                Pattern nodePattern = Pattern.compile("^([^\\s]+)");
                matcher = nodePattern.matcher(links.get(i));
                if (!matcher.find()) continue;
                if (NodeList.isEmpty()) {
                    NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                    int node = NodeList.size() - 1;
                    keyNodeHash.put(matcher.group(1), node);
                    keyNodeArray.add(matcher.group(1));
                    continue;
                }
                if (keyNodeHash.containsKey(matcher.group(1))) continue;
                NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                int node = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(1), node);
                keyNodeArray.add(matcher.group(1));
            }
            this.taskProgress = "endload";
        }
        catch (Exception ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadSample1() {
        ArrayList<String> links = new ArrayList<String>();
        links.add("n1;n2");
        links.add("n1;n3");
        links.add("n1;n4");
        links.add("n1;n5");
        links.add("n1;n6");
        links.add("n1;n7");
        links.add("n1;n8");
        links.add("n1;n9");
        links.add("n2;n10");
        links.add("n2;n11");
        links.add("n2;n12");
        links.add("n2;n13");
        links.add("n2;n14");
        links.add("n2;n15");
        links.add("n2;n16");
        links.add("n2;n17");
        links.add("n2;n18");
        links.add("n2;n19");
        this.loadBanksViaLinks(links);
    }

    private void addLegendSize(List<Float> sizevec, List<String> labvec, List<Color> colvec, float interspace, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype, float edgelen) {
        int nnodes = sizevec.size();
        this.clearLegend(legtype);
        float maxLabLength = 0.0f;
        float a = 0.0f;
        float b = 0.0f;
        for (int i = 0; i < nnodes; ++i) {
            if (a < sizevec.get(i).floatValue()) {
                a = sizevec.get(i).floatValue();
            }
            b = b + sizevec.get(i).floatValue() + interspace;
            String legalias = labvec.get(i);
            if (!(maxLabLength < (float)legalias.length())) continue;
            maxLabLength = legalias.length();
        }
        float totalH = a;
        float totalW = b;
        if (isVertical) {
            totalH = b;
            totalW = a;
        }
        float maxH = Math.min(a, b);
        float maxW = Math.min(a, b);
        for (int i = 0; i < nnodes; ++i) {
            int legID = LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = LegendList.get(legID);
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeColor(colvec.get(i));
            legendAccount.setNodeLineColor(colvec.get(i));
            legendAccount.setLegType(legtype);
            if (legtype.equals("edgewidth")) {
                if (isVertical) {
                    legendAccount.setNode(0.0f, 0.0f);
                    legendAccount.setLegSize(sizevec.get(i).floatValue(), sizevec.get(i).floatValue(), edgelen);
                    totalW = edgelen;
                    maxW = edgelen;
                } else {
                    legendAccount.setNode(0.0f, 0.0f);
                    legendAccount.setLegSize(sizevec.get(i).floatValue(), edgelen, sizevec.get(i).floatValue());
                    totalH = edgelen;
                    maxH = edgelen;
                }
            } else {
                legendAccount.setNode(0.0f, 0.0f);
                legendAccount.setLegSize(sizevec.get(i).floatValue());
            }
            legendAccount.setDim(totalH, totalW, maxH, maxW);
            legendAccount.setMaxLabLength(Float.valueOf(maxLabLength));
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setInterSpace(interspace);
            legendAccount.setNodeLineWidth(0.5f);
        }
    }

    private void addLegendColor(List<Color> colvec, List<String> labvec, float size, float bend, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype) {
        int i;
        float totalW;
        float totalH;
        int nnodes = colvec.size();
        float legbend = bend;
        if (isVertical) {
            legbend = 100.0f - bend;
        }
        this.clearLegend(legtype);
        float maxH = size * (0.5f + legbend / 100.0f);
        float maxW = size * (1.0f + (0.5f - legbend / 100.0f));
        if (isVertical) {
            totalH = maxH * (float)nnodes;
            totalW = maxW;
        } else {
            totalH = maxH;
            totalW = maxW * (float)nnodes;
        }
        float maxLabLength = 0.0f;
        for (i = 0; i < nnodes; ++i) {
            String legalias = labvec.get(i);
            if (!(maxLabLength < (float)legalias.length())) continue;
            maxLabLength = legalias.length();
        }
        for (i = 0; i < nnodes; ++i) {
            int legID = LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = LegendList.get(legID);
            legendAccount.setMaxLabLength(Float.valueOf(maxLabLength));
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setLegSize(size, maxH, maxW);
            legendAccount.setNodeColor(colvec.get(i));
            legendAccount.setNodeLineColor(colvec.get(i));
            legendAccount.setLegBend(bend);
            legendAccount.setLegType(legtype);
            legendAccount.setLegShape("RECTANGLE");
            legendAccount.setDim(totalH, totalW, maxH, maxW);
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setNodeLineWidth(0.5f);
        }
    }

    private void addLegendShape(List<String> shapevec, List<String> labvec, List<Color> colvec, float size, float interspace, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype) {
        int nnodes = shapevec.size();
        this.clearLegend(legtype);
        float a = size;
        float b = 0.0f;
        for (int i = 0; i < nnodes; ++i) {
            b = b + size + interspace;
        }
        float totalH = a;
        float totalW = b;
        if (isVertical) {
            totalH = b;
            totalW = a;
        }
        float maxLabLength = 0.0f;
        for (int i = 0; i < nnodes; ++i) {
            String legalias = labvec.get(i);
            if (!(maxLabLength < (float)legalias.length())) continue;
            maxLabLength = legalias.length();
        }
        float maxH = Math.min(a, b);
        float maxW = Math.min(a, b);
        for (int i = 0; i < nnodes; ++i) {
            int legID = LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = LegendList.get(legID);
            legendAccount.setMaxLabLength(Float.valueOf(maxLabLength));
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeColor(colvec.get(i));
            legendAccount.setNodeLineColor(colvec.get(i));
            legendAccount.setLegType(legtype);
            if (legtype.equals("edgeshape")) {
                float len = 50.0f;
                if (isVertical) {
                    legendAccount.setNode(0.0f, 0.0f);
                    legendAccount.setLegSize(size, size, len);
                    totalW = len;
                    maxW = len;
                } else {
                    legendAccount.setNode(0.0f, 0.0f);
                    legendAccount.setLegSize(size, len, size);
                    totalH = len;
                    maxH = len;
                }
            } else {
                legendAccount.setNode(0.0f, 0.0f);
                legendAccount.setLegSize(size);
            }
            legendAccount.setLegShape(shapevec.get(i));
            legendAccount.setDim(totalH, totalW, maxH, maxW);
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setInterSpace(interspace);
            legendAccount.setNodeLineWidth(0.5f);
        }
    }

    private void clearLegend(String type) {
        for (int i = 0; i < LegendList.size(); ++i) {
            LegendBank legAccount = LegendList.get(i);
            String tp = legAccount.getLegType();
            if (!tp.equals(type)) continue;
            LegendList.remove(i);
            --i;
        }
    }
}

