/*
 * Decompiled with CFR 0.152.
 */
package reder.application.io;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Comment;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import reder.application.RederMainFrame;
import reder.application.graph.EdgeBank;
import reder.application.graph.LegendBank;
import reder.application.graph.NodeBank;

public class SaveData {
    private static ArrayList<NodeBank> NodeList;
    private static ArrayList<EdgeBank> EdgeList;
    private static ArrayList<LegendBank> LegendList;
    private static String saveAddress;
    private float centroX;
    private float centroY;
    private Color backgroundColor;
    private String taskProgress;
    private double zoomInOut;
    private double edgeTarget;
    private double outedgeTarget;
    private double nodeSpeedLimit;
    private double repulserad;
    private double stiffness;
    private double repelFactor;
    private double outRepulsionFactor;
    private double perimeterEffect;
    private double centralPull;
    Document doc;

    public SaveData() {
        NodeList = new ArrayList();
        EdgeList = new ArrayList();
        LegendList = new ArrayList();
        saveAddress = null;
        this.taskProgress = "running";
    }

    public String getProgress() {
        return this.taskProgress;
    }

    public void inputAndGo(String outputAddress, String fileType, ArrayList<NodeBank> outputNodes, ArrayList<EdgeBank> outputEdges, ArrayList<LegendBank> outputLegend, float centroX, float centroY, double zoomInOut, Color backgroundColor, double edgeTarget, double outedgeTarget, double stiffness, double repelFactor, double outRepulsionFactor, double nodeSpeedLimit, double perimeterEffect, double repulserad, double centralPull) {
        try {
            this.dataClear();
            this.centralPull = centralPull;
            this.repulserad = repulserad;
            this.edgeTarget = edgeTarget;
            this.outedgeTarget = outedgeTarget;
            this.stiffness = stiffness;
            this.repelFactor = repelFactor;
            this.outRepulsionFactor = outRepulsionFactor;
            this.nodeSpeedLimit = nodeSpeedLimit;
            this.perimeterEffect = perimeterEffect;
            this.backgroundColor = backgroundColor;
            this.zoomInOut = zoomInOut;
            this.centroX = centroX;
            this.centroY = centroY;
            saveAddress = outputAddress;
            NodeList = outputNodes;
            EdgeList = outputEdges;
            LegendList = outputLegend;
            if (fileType.equals("default")) {
                this.saveDefault();
            }
            if (fileType.equals("xgmml")) {
                this.xgmml();
            }
            if (fileType.equals("sif")) {
                this.sif();
            }
            if (fileType.equals("nodesAndEdges")) {
                this.nodesAndEdges();
            }
            if (fileType.equals("uniqueEdges")) {
                this.uniqueEdges();
            }
            if (fileType.equals("uniqueNodes")) {
                this.uniqueNodes();
            }
            this.taskProgress = "endsave";
        }
        catch (IOException | JDOMException iOException) {
            this.taskProgress = "halt";
        }
        File checkFile = new File(saveAddress);
        if (!checkFile.exists()) {
            this.taskProgress = "halt";
        }
    }

    public void dataClear() {
        NodeList.clear();
        EdgeList.clear();
        LegendList.clear();
        saveAddress = null;
    }

    public void uniqueNodes() throws IOException {
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("tsv")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("#node_id");
        out.newLine();
        for (int i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount1 = NodeList.get(i);
            if (NodeList.get(i).isContainer()) continue;
            out.write(nodeAccount1.getNodeID());
            out.newLine();
        }
        out.close();
    }

    public void uniqueEdges() throws IOException {
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("tsv")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("#node_a\tnode_b");
        out.newLine();
        for (int i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            if (NodeList.get(a).isContainer() || NodeList.get(b).isContainer()) continue;
            String nodeA = NodeList.get(a).getNodeID();
            String nodeB = NodeList.get(b).getNodeID();
            out.write(nodeA + "\t" + nodeB);
            out.newLine();
        }
        out.close();
    }

    public void sif() throws IOException {
        int i;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("sif")) {
            saveAddress = saveAddress + ".sif";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        for (i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            if (NodeList.get(a).isContainer() || NodeList.get(b).isContainer()) continue;
            String nodeA = NodeList.get(a).getNodeID();
            String nodeB = NodeList.get(b).getNodeID();
            out.write(nodeA + "\t---\t" + nodeB);
            out.newLine();
        }
        for (i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount1 = NodeList.get(i);
            if (NodeList.get(i).isContainer() || nodeAccount1.getDegree() != 0) continue;
            out.write(nodeAccount1.getNodeID());
            out.newLine();
        }
        out.close();
    }

    public void xgmml() throws IOException, JDOMException {
        System.gc();
        this.JDomXmlWriter(false);
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("xgmml")) {
            saveAddress = saveAddress + ".xgmml";
        }
        Format formato = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(formato);
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        outputter.output(this.doc, (Writer)out);
        out.close();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDefault() throws JDOMException, IOException {
        System.gc();
        this.JDomXmlWriter(true);
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("reder")) {
            saveAddress = saveAddress + ".reder";
        }
        Format formato = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(formato);
        File tempFile = File.createTempFile("reder", ".xgmml");
        BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
        outputter.output(this.doc, (Writer)out);
        out.close();
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            int n;
            fin = new FileInputStream(tempFile.getAbsolutePath());
            fout = new FileOutputStream(saveAddress);
            ZipOutputStream zout = new ZipOutputStream(fout);
            zout.setLevel(0);
            zout.setComment("Archive created by RedeR v3.0");
            ZipEntry ze = new ZipEntry(tempFile.getAbsolutePath());
            zout.putNextEntry(ze);
            int BUFSIZ = 2048;
            byte[] inbuf = new byte[2048];
            while ((n = fin.read(inbuf)) != -1) {
                zout.write(inbuf, 0, n);
            }
            fin.close();
            fin = null;
            zout.close();
            zout = null;
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        tempFile.deleteOnExit();
        System.gc();
    }

    public void JDomXmlWriter(boolean colorWithAlpha) {
        String label;
        int i;
        this.doc = new Document(){};
        this.doc.addContent(new Comment("Graph File Generated for RedeR v3.0"));
        Namespace ns = Namespace.getNamespace("http://www.cs.rpi.edu/XGMML");
        Element graph = new Element("graph", ns);
        graph.setAttribute("label", "Network");
        graph.setAttribute("directed", "1");
        this.doc.setRootElement(graph);
        Element att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "backgroundColor");
        String background = "#" + RederMainFrame.ColorToHex(this.backgroundColor, colorWithAlpha);
        att.setAttribute("value", background);
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "GRAPH_VIEW_ZOOM");
        att.setAttribute("value", Float.toString((float)this.zoomInOut));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "GRAPH_VIEW_CENTER_X");
        att.setAttribute("value", Float.toString(this.centroX));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "GRAPH_VIEW_CENTER_Y");
        att.setAttribute("value", Float.toString(this.centroY));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_EDGETARGET");
        att.setAttribute("value", Float.toString((float)this.edgeTarget));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_OUTEDGETARGET");
        att.setAttribute("value", Float.toString((float)this.outedgeTarget));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_STIFFNESS");
        att.setAttribute("value", Float.toString((float)this.stiffness));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_REPEL");
        att.setAttribute("value", Float.toString((float)this.repelFactor));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_REPULSERAD");
        att.setAttribute("value", Float.toString((float)this.repulserad));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_OUTREPEL");
        att.setAttribute("value", Float.toString((float)this.outRepulsionFactor));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_PERIMETEREFFECT");
        att.setAttribute("value", Float.toString((float)this.perimeterEffect));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_SPEED");
        att.setAttribute("value", Float.toString((float)this.nodeSpeedLimit));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_CENTRALPULL");
        att.setAttribute("value", Float.toString((float)this.centralPull));
        graph.addContent(att);
        Element leg = new Element("legend", ns);
        for (i = 0; i < LegendList.size(); ++i) {
            Object valuevec = "null";
            String aliasvec = "null";
            String size = "null";
            String legbend = "null";
            Object col = "null";
            String intersp = "null";
            String ftsize = "null";
            String labx = "null";
            String labxdist = "null";
            String position = "null";
            String legDistX = "null";
            String legDistY = "null";
            String isver = "null";
            String edgelen = "null";
            LegendBank legAccount = LegendList.get(i);
            String legtype = legAccount.getLegType();
            if (legAccount.getMembership() == 0) {
                leg = new Element("legend", ns);
                leg.setAttribute("legtype", legtype);
                graph.addContent(leg);
            }
            if (legtype.equals("edgewidth") || legtype.equals("nodesize")) {
                valuevec = Float.toString(legAccount.getLegSize());
                aliasvec = legAccount.getAliases();
                col = "#" + RederMainFrame.ColorToHex(legAccount.getNodeFillColor(), colorWithAlpha);
                intersp = Float.toString(legAccount.getInterSpace());
                ftsize = Integer.toString(legAccount.getFontSize());
                labx = legAccount.getLabx();
                labxdist = Float.toString(legAccount.getLabxDist());
                position = legAccount.getPanelPosition();
                legDistX = Float.toString(legAccount.getDistBorderX());
                legDistY = Float.toString(legAccount.getDistBorderY());
                isver = Boolean.toString(legAccount.isVertical());
                if (legtype.equals("edgewidth")) {
                    edgelen = legAccount.isVertical() ? Float.toString(legAccount.getLegW()) : Float.toString(legAccount.getLegH());
                }
            } else if (legtype.equals("nodecolor") || legtype.equals("edgecolor")) {
                col = valuevec = "#" + RederMainFrame.ColorToHex(legAccount.getNodeFillColor(), colorWithAlpha);
                aliasvec = legAccount.getAliases();
                size = Float.toString(legAccount.getLegSize());
                legbend = Float.toString(legAccount.getLegBend());
                ftsize = Integer.toString(legAccount.getFontSize());
                labx = legAccount.getLabx();
                labxdist = Float.toString(legAccount.getLabxDist());
                position = legAccount.getPanelPosition();
                legDistX = Float.toString(legAccount.getDistBorderX());
                legDistY = Float.toString(legAccount.getDistBorderY());
                isver = Boolean.toString(legAccount.isVertical());
            } else if (legtype.equals("nodeshape") || legtype.equals("edgeshape")) {
                valuevec = legAccount.getLegShape();
                aliasvec = legAccount.getAliases();
                col = "#" + RederMainFrame.ColorToHex(legAccount.getNodeFillColor(), colorWithAlpha);
                size = Float.toString(legAccount.getLegSize());
                intersp = Float.toString(legAccount.getInterSpace());
                ftsize = Integer.toString(legAccount.getFontSize());
                labx = legAccount.getLabx();
                labxdist = Float.toString(legAccount.getLabxDist());
                position = legAccount.getPanelPosition();
                legDistX = Float.toString(legAccount.getDistBorderX());
                legDistY = Float.toString(legAccount.getDistBorderY());
                isver = Boolean.toString(legAccount.isVertical());
            }
            if (!size.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "size");
                att.setAttribute("value", size);
                leg.addContent(att);
            }
            if (!intersp.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "intersp");
                att.setAttribute("value", intersp);
                leg.addContent(att);
            }
            if (!legbend.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "bend");
                att.setAttribute("value", legbend);
                leg.addContent(att);
            }
            if (!ftsize.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "ftsize");
                att.setAttribute("value", ftsize);
                leg.addContent(att);
            }
            if (!labx.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "labx");
                att.setAttribute("value", labx);
                leg.addContent(att);
            }
            if (!labxdist.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "labxdist");
                att.setAttribute("value", labxdist);
                leg.addContent(att);
            }
            if (!position.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "position");
                att.setAttribute("value", position);
                leg.addContent(att);
            }
            if (!legDistX.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "legdx");
                att.setAttribute("value", legDistX);
                leg.addContent(att);
            }
            if (!legDistY.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "legdy");
                att.setAttribute("value", legDistY);
                leg.addContent(att);
            }
            if (!isver.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "boolean");
                att.setAttribute("name", "vertical");
                att.setAttribute("value", isver);
                leg.addContent(att);
            }
            if (!edgelen.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "boolean");
                att.setAttribute("name", "edgelen");
                att.setAttribute("value", edgelen);
                leg.addContent(att);
            }
            Element member = new Element("member", ns);
            member.setAttribute("label", aliasvec);
            member.setAttribute("color", (String)col);
            member.addContent((String)valuevec);
            leg.addContent(member);
        }
        for (i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount = NodeList.get(i);
            label = nodeAccount.getNodeID();
            String id = Integer.toString(i);
            String alias = nodeAccount.getAliases();
            String strX = Float.toString(nodeAccount.getXtoSave());
            String strY = Float.toString(nodeAccount.getYtoSave());
            String strW = Float.toString(nodeAccount.getW());
            String strH = Float.toString(nodeAccount.getH());
            String bend = Float.toString(nodeAccount.getNodeBend());
            String size = Float.toString(nodeAccount.getNodeSize());
            String nodeShape = nodeAccount.getNodeShape();
            String nodeLineType = nodeAccount.getNodeLineType();
            String nodeColor = "#" + RederMainFrame.ColorToHex(nodeAccount.getNodeFillColor(), colorWithAlpha);
            String lineSize = Float.toString(nodeAccount.getNodeLineWidth());
            String lineColor = "#" + RederMainFrame.ColorToHex(nodeAccount.getNodeLineColor(), colorWithAlpha);
            String fontName = nodeAccount.getFont().getName();
            String fontStyle = Integer.toString(nodeAccount.getFont().getStyle());
            String fontSize = Integer.toString(nodeAccount.getFont().getSize());
            String font = fontName + "-" + fontStyle + "-" + fontSize;
            String fontColor = "#" + RederMainFrame.ColorToHex(nodeAccount.getNodeFontColor(), colorWithAlpha);
            String weight = Double.toString(nodeAccount.getNodeWeight());
            String fontOffsetX = Float.toString(nodeAccount.getFontOffsetX());
            String fontOffsetY = Float.toString(nodeAccount.getFontOffsetY());
            String fontPositionX = nodeAccount.getFontPositionX();
            String fontPositionY = nodeAccount.getFontPositionY();
            String groupComponets = nodeAccount.getGroupComponets();
            String groupCompNumber = Integer.toString(nodeAccount.getGroupCompNumber());
            String relativeSize = Double.toString(nodeAccount.getRelativeSize() * 100.0);
            Element node = new Element("node", ns);
            node.setAttribute("label", label);
            node.setAttribute("id", id);
            graph.addContent(node);
            if (nodeAccount.isGroup()) {
                att = new Element("att", ns);
                att.setAttribute("type", "integer");
                att.setAttribute("name", "group");
                att.setAttribute("value", groupComponets);
                node.addContent(att);
                att = new Element("att", ns);
                att.setAttribute("type", "integer");
                att.setAttribute("name", "componets");
                att.setAttribute("value", groupCompNumber);
                node.addContent(att);
            }
            if (nodeAccount.isContainer()) {
                att = new Element("att", ns);
                att.setAttribute("type", "double");
                att.setAttribute("name", "container.rsize");
                att.setAttribute("value", relativeSize);
                node.addContent(att);
                boolean c1 = nodeAccount.isAnchored();
                boolean c2 = nodeAccount.isContainerHided();
                boolean c3 = nodeAccount.isContainerTransparent();
                if (c1 && c2 && c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "TTT");
                    node.addContent(att);
                } else if (c1 && !c2 && c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "TFT");
                    node.addContent(att);
                } else if (!c1 && c2 && c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "FTT");
                    node.addContent(att);
                } else if (!c1 && !c2 && c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "FFT");
                    node.addContent(att);
                } else if (c1 && c2 && !c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "TTF");
                    node.addContent(att);
                } else if (c1 && !c2 && !c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "TFF");
                    node.addContent(att);
                } else if (!c1 && c2 && !c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "FTF");
                    node.addContent(att);
                } else if (!(c1 || c2 || c3)) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "FFF");
                    node.addContent(att);
                }
            }
            if (nodeAccount.isNodeGradient()) {
                att = new Element("att", ns);
                att.setAttribute("type", "boolean");
                att.setAttribute("name", "gradient");
                att.setAttribute("value", "true");
                node.addContent(att);
            }
            if (nodeAccount.isSpot()) {
                att = new Element("att", ns);
                att.setAttribute("type", "boolean");
                att.setAttribute("name", "spot");
                att.setAttribute("value", "true");
                node.addContent(att);
                att = new Element("att", ns);
                att.setAttribute("type", "double");
                att.setAttribute("name", "spoteffect");
                att.setAttribute("value", Double.toString(nodeAccount.getSpotEffect()));
                node.addContent(att);
                att = new Element("att", ns);
                att.setAttribute("type", "double");
                att.setAttribute("name", "spotrange");
                att.setAttribute("value", Double.toString(nodeAccount.getSpotRange()));
                node.addContent(att);
                att = new Element("att", ns);
                att.setAttribute("type", "integer");
                att.setAttribute("name", "spotdirection");
                att.setAttribute("value", Integer.toString(nodeAccount.getSpotDirection()));
                node.addContent(att);
            }
            att = new Element("att", ns);
            att.setAttribute("type", "string");
            att.setAttribute("name", "line.type");
            att.setAttribute("value", nodeLineType);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "string");
            att.setAttribute("name", "alias");
            att.setAttribute("value", alias);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "node.bend");
            att.setAttribute("value", bend);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "node.size");
            att.setAttribute("value", size);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "hexadecimal");
            att.setAttribute("name", "node.labelColor");
            att.setAttribute("value", fontColor);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "string");
            att.setAttribute("name", "node.font");
            att.setAttribute("value", font);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "double");
            att.setAttribute("name", "node.weight");
            att.setAttribute("value", weight);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "font.x.position");
            att.setAttribute("value", fontPositionX);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "font.y.position");
            att.setAttribute("value", fontPositionY);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "font.x.offset");
            att.setAttribute("value", fontOffsetX);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "font.y.offset");
            att.setAttribute("value", fontOffsetY);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "string");
            att.setAttribute("name", "node.shape");
            String type = "ellipse";
            if (nodeShape.equals("RECTANGLE")) {
                type = "rectangle";
            }
            if (nodeShape.equals("ROUNDED_RECTANGLE")) {
                type = "roundrect";
            }
            if (nodeShape.equals("TRIANGLE")) {
                type = "triangle";
            }
            if (nodeShape.equals("DIAMOND")) {
                type = "diamond";
            }
            att.setAttribute("value", type);
            node.addContent(att);
            if (nodeAccount.isAnchored()) {
                att = new Element("att", ns);
                att.setAttribute("type", "boolean");
                att.setAttribute("name", "anchored");
                att.setAttribute("value", "true");
                node.addContent(att);
            }
            Element nodeAttribute = new Element("graphics", ns);
            nodeAttribute.setAttribute("type", nodeShape);
            nodeAttribute.setAttribute("h", strH);
            nodeAttribute.setAttribute("w", strW);
            nodeAttribute.setAttribute("x", strX);
            nodeAttribute.setAttribute("y", strY);
            nodeAttribute.setAttribute("fill", nodeColor);
            nodeAttribute.setAttribute("width", lineSize);
            nodeAttribute.setAttribute("outline", lineColor);
            node.addContent(nodeAttribute);
        }
        for (i = 0; i < EdgeList.size(); ++i) {
            Element edgeAttribute;
            Element edgeAttribute2;
            EdgeBank edgeAccount = EdgeList.get(i);
            label = Integer.toString(i);
            String source = Integer.toString(edgeAccount.getA());
            String target = Integer.toString(edgeAccount.getB());
            String direction = Integer.toString(edgeAccount.getArrowDirection());
            String width = Float.toString(edgeAccount.getWidth());
            String edgeColor = "#" + RederMainFrame.ColorToHex(edgeAccount.getEdgeColor(), colorWithAlpha);
            String lineType = edgeAccount.getType();
            Element edge = new Element("edge", ns);
            edge.setAttribute("label", label);
            edge.setAttribute("source", source);
            edge.setAttribute("target", target);
            edge.setAttribute("direction", direction);
            graph.addContent(edge);
            if (edgeAccount.getMeanWeight() != 0.0) {
                String weight = Double.toString(edgeAccount.getMeanWeight());
                edgeAttribute2 = new Element("att", ns);
                edgeAttribute2.setAttribute("type", "double");
                edgeAttribute2.setAttribute("name", "weight");
                edgeAttribute2.setAttribute("value", weight);
                edge.addContent(edgeAttribute2);
            }
            if (edgeAccount.getArrowLength() != 10.0f) {
                String arrowlen = Float.toString(edgeAccount.getArrowLength());
                edgeAttribute2 = new Element("att", ns);
                edgeAttribute2.setAttribute("type", "float");
                edgeAttribute2.setAttribute("name", "arrowlength");
                edgeAttribute2.setAttribute("value", arrowlen);
                edge.addContent(edgeAttribute2);
            }
            if (edgeAccount.getArrowAngle() != 45.0f) {
                String arrowangle = Float.toString(edgeAccount.getArrowAngle());
                edgeAttribute2 = new Element("att", ns);
                edgeAttribute2.setAttribute("type", "float");
                edgeAttribute2.setAttribute("name", "arrowangle");
                edgeAttribute2.setAttribute("value", arrowangle);
                edge.addContent(edgeAttribute2);
            }
            if (!edgeAccount.isDefaultEdgeAssignmet()) {
                edgeAttribute = new Element("att", ns);
                edgeAttribute.setAttribute("type", "boolean");
                edgeAttribute.setAttribute("name", "defaultnesting");
                edgeAttribute.setAttribute("value", "false");
                edge.addContent(edgeAttribute);
            }
            edgeAttribute = new Element("graphics", ns);
            edgeAttribute.setAttribute("width", width);
            edgeAttribute.setAttribute("fill", edgeColor);
            edgeAttribute.setAttribute("edgeLineType", lineType);
            edge.addContent(edgeAttribute);
        }
    }

    public void nodesAndEdges() throws IOException {
        int i;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("tsv")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("#node_id\tx\ty");
        out.newLine();
        for (i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount = NodeList.get(i);
            String nodeID = nodeAccount.getNodeID();
            float x = SaveData.round(nodeAccount.getXtoSave(), 2);
            float y = SaveData.round(nodeAccount.getYtoSave(), 2);
            out.write(nodeID + "\t" + x + "\t" + y);
            out.newLine();
        }
        out.write("#node_a\tnode_b");
        out.newLine();
        for (i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            NodeBank nodeAccountA = NodeList.get(a);
            NodeBank nodeAccountB = NodeList.get(b);
            out.write(nodeAccountA.getNodeID() + "\t" + nodeAccountB.getNodeID() + "\t");
            out.newLine();
        }
        out.close();
    }

    public static float round(float val, int places) {
        return (float)SaveData.round((double)val, places);
    }

    public static double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }
}

