/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

public class DnaSequence {
    private static final int PAD = 128;
    static final char[] state2char = new char[]{'-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'T', 'W', 'Y', 'H', 'K', 'D', 'B', 'X'};
    static final int[] state2bitCount = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    byte[] mySites;
    int myLength;
    int myScore;
    String myName;
    private transient long p0;
    private transient long p1;
    private transient long p2;
    private transient long p3;
    private transient long p4;
    private transient long p5;
    private transient long p6;
    private transient long p7;
    private transient long p8;
    private transient long p9;
    private transient long pa;
    private transient long pb;
    private transient long pc;
    private transient long pd;
    private transient long pe;
    private transient long pf;

    public DnaSequence() {
        this(0, 0, null);
    }

    public DnaSequence(int n) {
        this(n, 0, null);
    }

    public DnaSequence(int n, int n2) {
        this(n, n2, null);
    }

    public DnaSequence(int n, int n2, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("DnaSequence(): N (= " + n + ") < 0, illegal)");
        }
        this.mySites = new byte[n + 128];
        this.myLength = n;
        this.myScore = n2;
        this.myName = string;
    }

    public DnaSequence(DnaSequence dnaSequence) {
        this.mySites = (byte[])dnaSequence.mySites.clone();
        this.myLength = dnaSequence.myLength;
        this.myScore = dnaSequence.myScore;
        this.myName = dnaSequence.myName;
    }

    public int length() {
        return this.myLength;
    }

    public int score() {
        return this.myScore;
    }

    public void score(int n) {
        this.myScore = n;
    }

    public String name() {
        return this.myName;
    }

    public void name(String string) {
        this.myName = string;
    }

    public void copySites(DnaSequence dnaSequence) {
        System.arraycopy(dnaSequence.mySites, 0, this.mySites, 0, this.myLength);
    }

    public double distance(DnaSequence dnaSequence) {
        byte[] byArray = this.mySites;
        byte[] byArray2 = dnaSequence.mySites;
        int n = 0;
        int n2 = this.myLength;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            ++n;
        }
        return n;
    }

    public void setFitchAncestor(DnaSequence dnaSequence, DnaSequence dnaSequence2) {
        byte[] byArray = this.mySites;
        byte[] byArray2 = dnaSequence.mySites;
        byte[] byArray3 = dnaSequence2.mySites;
        int n = this.myLength;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray2[i];
            byte by2 = byArray3[i];
            int n3 = by & by2;
            if (n3 == 0) {
                n3 = by | by2;
                ++n2;
            }
            byArray[i] = (byte)n3;
        }
        this.myScore = dnaSequence.myScore + dnaSequence2.myScore + n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = this.mySites;
        int n = this.myLength;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(state2char[byArray[i]]);
        }
        return stringBuilder.toString();
    }
}

