/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.network;

import edu.rit.util.Random;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;

public class FloydRandom {
    private FloydRandom() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 4) {
            FloydRandom.usage();
        }
        long l = Long.parseLong(stringArray[0]);
        double d = Double.parseDouble(stringArray[1]);
        int n = Integer.parseInt(stringArray[2]);
        String string = stringArray[3];
        Random random = Random.getInstance(l);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = random.nextDouble();
            dArray2[i] = random.nextDouble();
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d2 = dArray[i] - dArray[j];
                double d3 = dArray2[i] - dArray2[j];
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                dataOutputStream.writeDouble(d4 <= d ? d4 : Double.POSITIVE_INFINITY);
            }
        }
        dataOutputStream.close();
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.hyb.network.FloydRandom <seed> <radius> <N> <matrixfile>");
        System.err.println("<seed> = Random seed");
        System.err.println("<radius> = Node adjacency radius");
        System.err.println("<N> = Number of nodes");
        System.err.println("<matrixfile> = Distance matrix file");
        System.exit(1);
    }
}

