/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.XYSeries;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Scanner;

public class ListXYSeries
extends XYSeries
implements Externalizable {
    private static final long serialVersionUID = 3623908540262724935L;
    private static final int INCR = 16;
    private double[] xArray = new double[16];
    private double[] yArray = new double[16];
    private int myLength = 0;

    public int length() {
        return this.myLength;
    }

    public double x(int n) {
        if (0 > n || n >= this.myLength) {
            throw new ArrayIndexOutOfBoundsException("ListXYSeries.x(): Index = " + n + " out of bounds");
        }
        return this.xArray[n];
    }

    public double y(int n) {
        if (0 > n || n >= this.myLength) {
            throw new ArrayIndexOutOfBoundsException("ListXYSeries.y(): Index = " + n + " out of bounds");
        }
        return this.yArray[n];
    }

    public ListXYSeries clear() {
        this.myLength = 0;
        return this;
    }

    public ListXYSeries add(double d, double d2) {
        this.allocate(1, 16);
        this.xArray[this.myLength] = d;
        this.yArray[this.myLength] = d2;
        ++this.myLength;
        return this;
    }

    public ListXYSeries add(double ... dArray) {
        int n = dArray.length / 2;
        this.allocate(n, n);
        for (int i = 0; i < n; ++i) {
            this.xArray[this.myLength] = dArray[2 * i];
            this.yArray[this.myLength] = dArray[2 * i + 1];
            ++this.myLength;
        }
        return this;
    }

    public ListXYSeries add(double[] dArray, double[] dArray2) {
        return this.add(dArray, dArray2, 0, dArray.length);
    }

    public ListXYSeries add(double[] dArray, double[] dArray2, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length || n + n2 > dArray2.length) {
            throw new IndexOutOfBoundsException();
        }
        this.allocate(n2, n2);
        System.arraycopy(dArray, n, this.xArray, this.myLength, n2);
        System.arraycopy(dArray2, n, this.yArray, this.myLength, n2);
        this.myLength += n2;
        return this;
    }

    public ListXYSeries add(XYSeries xYSeries) {
        return this.add(xYSeries, 0, xYSeries.length());
    }

    public ListXYSeries add(XYSeries xYSeries, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > xYSeries.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.allocate(n2, n2);
        while (n2 > 0) {
            this.xArray[this.myLength] = xYSeries.x(n);
            this.yArray[this.myLength] = xYSeries.y(n);
            ++this.myLength;
            ++n;
            --n2;
        }
        return this;
    }

    public ListXYSeries add(Scanner scanner) {
        while (scanner.hasNextDouble()) {
            double d = scanner.nextDouble();
            if (!scanner.hasNextDouble()) continue;
            double d2 = scanner.nextDouble();
            this.add(d, d2);
        }
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.myLength;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.xArray[i]);
            objectOutput.writeDouble(this.yArray[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.xArray = new double[n];
        this.yArray = new double[n];
        this.myLength = n;
        for (int i = 0; i < n; ++i) {
            this.xArray[i] = objectInput.readDouble();
            this.yArray[i] = objectInput.readDouble();
        }
    }

    private void allocate(int n, int n2) {
        if (this.myLength + n > this.xArray.length) {
            double[] dArray = new double[this.myLength + n2];
            System.arraycopy(this.xArray, 0, dArray, 0, this.myLength);
            this.xArray = dArray;
            double[] dArray2 = new double[this.myLength + n2];
            System.arraycopy(this.yArray, 0, dArray2, 0, this.myLength);
            this.yArray = dArray2;
        }
    }
}

