## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

options(
  rmarkdown.html_vignette.check_title = FALSE
)

## ----setup, message = FALSE---------------------------------------------------
library(tidytof)
library(dplyr)
library(ggplot2)

## -----------------------------------------------------------------------------
data(phenograph_data)

# perform the dimensionality reduction
phenograph_tsne <-
    phenograph_data |>
    tof_preprocess() |>
    tof_reduce_dimensions(method = "tsne")

# select only the tsne embedding columns
phenograph_tsne |>
    select(contains("tsne")) |>
    head()

## -----------------------------------------------------------------------------
phenograph_data |>
    tof_preprocess() |>
    tof_reduce_dimensions(method = "tsne", augment = FALSE)

## -----------------------------------------------------------------------------
phenograph_data |>
    tof_reduce_dimensions(method = "umap", augment = FALSE)

phenograph_data |>
    tof_reduce_dimensions(method = "pca", augment = FALSE)

## -----------------------------------------------------------------------------
# 2 principal components
phenograph_data |>
    tof_reduce_pca(num_comp = 2)

## -----------------------------------------------------------------------------
# 3 principal components
phenograph_data |>
    tof_reduce_pca(num_comp = 3)

## -----------------------------------------------------------------------------
# plot the tsne embeddings using color to distinguish between clusters
phenograph_tsne |>
    tof_plot_cells_embedding(
        embedding_cols = contains(".tsne"),
        color_col = phenograph_cluster
    )

# plot the tsne embeddings using color to represent CD11b expression
phenograph_tsne |>
    tof_plot_cells_embedding(
        embedding_cols = contains(".tsne"),
        color_col = cd11b
    ) +
    ggplot2::scale_fill_viridis_c()

## -----------------------------------------------------------------------------
sessionInfo()

