## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

options(
  tibble.print_min = 4L, 
  tibble.print_max = 4L, 
  rmarkdown.html_vignette.check_title = FALSE
)

## ----setup, message = FALSE, include = FALSE----------------------------------
library(tidytof)

## ----eval = FALSE-------------------------------------------------------------
# vignette("dplyr")

## -----------------------------------------------------------------------------
data(ddpr_data)

set.seed(777L)

ddpr_data |>
    tof_preprocess() |>
    tof_cluster(
        cluster_cols = starts_with("cd"), # column specification
        method = "phenograph", # method specification,
    ) |>
    tof_metacluster(
        cluster_col = .phenograph_cluster, # column specification
        num_metaclusters = 4, # method specification
        method = "kmeans" # method specification
    ) |>
    tof_downsample(
        group_cols = .kmeans_metacluster, # column specification
        num_cells = 200, # method specification
        method = "constant" # method specification
    ) |>
    tof_plot_cells_layout(
        knn_cols = starts_with("cd"), # column specification
        color_col = .kmeans_metacluster, # column specification
        num_neighbors = 7L, # method specification
        node_size = 2L # method specification
    )

## -----------------------------------------------------------------------------
ddpr_data |>
    # step 1
    tof_preprocess() |>
    # step 2
    tof_cluster(
        cluster_cols = starts_with("cd"),
        method = "phenograph",
        # num_metaclusters = 4L,
        seed = 2020L
    ) |>
    # step 3
    tof_downsample(
        group_cols = .phenograph_cluster,
        method = "constant",
        num_cells = 400
    ) |>
    # step 4
    tof_reduce_dimensions(method = "tsne") |>
    # step 5
    tof_plot_cells_embedding(
        embedding_cols = contains("tsne"),
        color_col = .phenograph_cluster
    ) +
    ggplot2::theme(legend.position = "none")

## ----eval = FALSE-------------------------------------------------------------
# browseVignettes(package = "tidytof")

## -----------------------------------------------------------------------------
sessionInfo()

