### Name: zmahomologyDATA
### Title: Genes that are Homologous to Zea mays
### Aliases: zmahomologyDATA
### Keywords: datasets

### ** Examples

    require("annotate") || stop("annotate unavailable")
    # Convert homologyDATA to a list
    xx <- as.list(zmahomologyDATA)

    if(length(xx) > 0){
        # Gets the homology data for the first key of zmahomologyDATA
        homodata <- xx[[1]]
        # Gets the organism name, LocusLink id, internal HomoloGene id,
        # GenBank accession number, type of similarity, percent
        # similarity, and URL for percent similarity for the first
        # homoData object in the list obtained previously
        homodata[[1]][["homoOrg"]]
        homodata[[1]][["homoHGID"]]
        homodata[[1]][["homoType"]]
        homodata[[1]][["homoPS"]]
        homodata[[1]][["homoURL"]]
        # Gets the values for more than one keys
        xx[1:3]
    }



