/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Swapper;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;

public class GenericPermuting {
    protected GenericPermuting() {
    }

    public static int[] permutation(long l, int n) {
        if (l < 1L) {
            throw new IllegalArgumentException("Permutations are enumerated 1 .. N!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Must satisfy N >= 0");
        }
        int[] nArray = new int[n];
        if (n > 20) {
            int n2 = n;
            while (--n2 >= 0) {
                nArray[n2] = n2;
            }
            Uniform uniform = new Uniform(new MersenneTwister((int)l));
            int n3 = 0;
            while (n3 < n - 1) {
                int n4 = uniform.nextIntFromTo(n3, n - 1);
                int n5 = nArray[n4];
                nArray[n4] = nArray[n3];
                nArray[n3] = n5;
                ++n3;
            }
            return nArray;
        }
        if (l > Arithmetic.longFactorial(n)) {
            throw new IllegalArgumentException("N too large (a sequence of N elements only has N! permutations).");
        }
        int[] nArray2 = new int[n];
        int n6 = 1;
        while (n6 <= n) {
            nArray2[n6 - 1] = n6;
            ++n6;
        }
        long l2 = l - 1L;
        int n7 = n - 1;
        while (n7 >= 1) {
            long l3 = Arithmetic.longFactorial(n7);
            int n8 = (int)(l2 / l3) + 1;
            l2 %= l3;
            nArray[n - n7 - 1] = nArray2[n8 - 1];
            int n9 = n8;
            while (n9 <= n7) {
                nArray2[n9 - 1] = nArray2[n9];
                ++n9;
            }
            --n7;
        }
        if (n > 0) {
            nArray[n - 1] = nArray2[0];
        }
        int n10 = n;
        while (--n10 >= 0) {
            nArray[n10] = nArray[n10] - 1;
        }
        return nArray;
    }

    public static void permute(int[] nArray, int[] nArray2) {
        int[] nArray3 = (int[])nArray.clone();
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = nArray3[nArray2[n]];
        }
    }

    public static void permute(int[] nArray, Swapper swapper, int[] nArray2) {
        GenericPermuting.permute(nArray, swapper, nArray2, null);
    }

    public static void permute(int[] nArray, Swapper swapper, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        int[] nArray4 = nArray2;
        int[] nArray5 = nArray3;
        if (nArray4 == null || nArray4.length < n) {
            nArray4 = new int[n];
        }
        if (nArray5 == null || nArray5.length < n) {
            nArray5 = new int[n];
        }
        int n2 = n;
        while (--n2 >= 0) {
            nArray4[n2] = n2;
            nArray5[n2] = n2;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            int n5 = nArray4[n4];
            swapper.swap(n3, n5);
            nArray4[n4] = n3;
            nArray4[nArray5[n3]] = n5;
            int n6 = nArray5[n3];
            nArray5[n3] = nArray5[n5];
            nArray5[n5] = n6;
            ++n3;
        }
    }

    public static void permute(Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        int n = objectArray.length;
        while (--n >= 0) {
            objectArray[n] = objectArray2[nArray[n]];
        }
    }
}

