/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.StaticMemberPlaceHolder;

public interface Alphabet
extends Annotatable {
    public static final ChangeType SYMBOLS = new ChangeType("The set of symbols in this alphabet has changed.", "org.biojava.bio.symbol.Alphabet", "SYMBOLS");
    public static final ChangeType PARSERS = new ChangeType("The set of parsers has changed.", "org.biojava.bio.symbol.Alphabet", "PARSERS");
    public static final Alphabet EMPTY_ALPHABET = new EmptyAlphabet();

    public boolean contains(Symbol var1);

    public List getAlphabets();

    public Symbol getAmbiguity(Set var1) throws IllegalSymbolException;

    public String getName();

    public SymbolParser getParser(String var1) throws NoSuchElementException, BioException;

    public Symbol getSymbol(List var1) throws IllegalSymbolException;

    public void validate(Symbol var1) throws IllegalSymbolException;

    public static class EmptyAlphabet
    implements FiniteAlphabet,
    Serializable {
        static /* synthetic */ Class class$org$biojava$bio$symbol$Alphabet;

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public void addSymbol(Symbol symbol) throws IllegalSymbolException {
            throw new IllegalSymbolException("Can't add symbols to alphabet: " + symbol.getName() + " in " + this.getName());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public boolean contains(Symbol symbol) {
            return symbol == AlphabetManager.getGapSymbol();
        }

        public List getAlphabets() {
            return Collections.EMPTY_LIST;
        }

        public Symbol getAmbiguity(Set set) throws IllegalSymbolException {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.validate((Symbol)iterator.next());
            }
            return AlphabetManager.getGapSymbol();
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public String getName() {
            return "Empty Alphabet";
        }

        public SymbolParser getParser(String string) throws NoSuchElementException {
            throw new NoSuchElementException("There is no parser for the empty alphabet. Attempted to retrieve " + string);
        }

        public Symbol getSymbol(List list) throws IllegalSymbolException {
            if (list.size() != 0) {
                throw new IllegalSymbolException("The empty alphabet contains nothing");
            }
            return AlphabetManager.getGapSymbol();
        }

        public Iterator iterator() {
            return SymbolList.EMPTY_LIST.iterator();
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public void removeSymbol(Symbol symbol) throws IllegalSymbolException {
            throw new IllegalSymbolException("Can't remove symbols from alphabet: " + symbol.getName() + " in " + this.getName());
        }

        public int size() {
            return 0;
        }

        public SymbolList symbols() {
            return SymbolList.EMPTY_LIST;
        }

        public void validate(Symbol symbol) throws IllegalSymbolException {
            throw new IllegalSymbolException("The empty alphabet does not contain symbol " + symbol.getName());
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$Alphabet != null ? class$org$biojava$bio$symbol$Alphabet : (class$org$biojava$bio$symbol$Alphabet = EmptyAlphabet.class$("org.biojava.bio.symbol.Alphabet"))).getField("EMPTY_ALPHABET"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NotSerializableException(noSuchFieldException.getMessage());
            }
        }
    }
}

