/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.gbregion;

import edu.msu.cme.rdp.readseq.utils.gbregion.Extends;
import edu.msu.cme.rdp.readseq.utils.gbregion.SingleSeqRegion;
import java.util.List;

public class JoinRegion
extends SingleSeqRegion {
    private List<SingleSeqRegion> joinRegions;
    private String id = null;
    private boolean isOrder;
    private int smallestStart = Integer.MAX_VALUE;
    private int largestStop = Integer.MIN_VALUE;

    public JoinRegion(String id, List<SingleSeqRegion> joinRegions, boolean isOrder) {
        if (joinRegions == null || joinRegions.size() < 2) {
            throw new IllegalArgumentException("JoinRegions must join at least 2 regions");
        }
        for (SingleSeqRegion region : joinRegions) {
            if (region.getSeqStart() < this.smallestStart) {
                this.smallestStart = region.getSeqStart();
            }
            if (region.getSeqStop() <= this.largestStop) continue;
            this.largestStop = region.getSeqStop();
        }
        this.id = id;
        this.joinRegions = joinRegions;
    }

    public List<SingleSeqRegion> getJoinRegions() {
        return this.joinRegions;
    }

    public String toString() {
        String ret = "";
        ret = this.isOrder ? "order(" : "join(";
        for (SingleSeqRegion r : this.joinRegions) {
            ret = ret + r.toString() + ",";
        }
        return ret.substring(0, ret.length() - 1) + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getSeqStart() {
        return this.smallestStart;
    }

    @Override
    public int getSeqStop() {
        return this.largestStop;
    }

    @Override
    public String getSeqRegion(String seq, int offset) {
        StringBuffer ret = new StringBuffer();
        for (SingleSeqRegion region : this.joinRegions) {
            ret.append(region.getSeqRegion(seq, offset));
        }
        return ret.toString();
    }

    @Override
    public Extends getExtends() {
        Extends ret = Extends.EXACT;
        if (this.joinRegions.size() > 0) {
            Extends e = this.joinRegions.get(0).getExtends();
            if (e == Extends.BEYOND_BEGIN || e == Extends.BEYOND_BOTH) {
                ret = Extends.BEYOND_BEGIN;
            }
            if ((e = this.joinRegions.get(this.joinRegions.size() - 1).getExtends()) == Extends.BEYOND_END || e == Extends.BEYOND_BOTH) {
                ret = ret == Extends.EXACT ? Extends.BEYOND_END : Extends.BEYOND_BOTH;
            }
        }
        return ret;
    }
}

